package fuku.eb4j;

import java.io.*;

import fuku.eb4j.io.EBFile;
import fuku.eb4j.io.BookInputStream;
import fuku.eb4j.util.ByteUtil;

/**
 * Ͽѥå饹
 *
 * @author Hisaya FUKUMOTO
 * @version 0.3.3
 */
final class Appendix {

    /** ϿѥåΥǥ쥯ȥ */
    private String _appendixPath = null;

    /** Ͽѥåμ */
    private int _appendixType = -1;

    /** Ͽѥå */
    private SubAppendix[] _sub = null;


    /**
     * 󥹥ȥ饯
     *
     * @param path ϿѥåΥѥ
     * @exception EBException ˥顼ȯ
     */
    Appendix(String path) throws EBException {
        super();

        _appendixPath = path;
        File dir = new File(path);
        if (!dir.exists()) {
            throw new EBException(EBException.DIR_NOT_FOUND, path);
        }
        if (!dir.canRead()) {
            throw new EBException(EBException.CANT_READ_DIR, path);
        }
        _loadCatalog(dir);
    }


    /**
     * ϿѥåΥѥʸ֤ޤ
     *
     * @return ϿѥåΥѥʸ
     */
    String getPath() {
        return _appendixPath;
    }

    /**
     * Ͽѥåμ֤ޤ
     *
     * @return appendixѥåμ򼨤ե饰
     * @see Book#DISC_EB
     * @see Book#DISC_EPWING
     */
    int getAppendixType() {
        return _appendixType;
    }

    /**
     * Ͽѥå֤ܿޤ
     *
     * @return ܿ
     */
    int getSubAppendixCount() {
        int ret = 0;
        if (_sub != null) {
            ret = _sub.length;
        }
        return ret;
    }

    /**
     * ϿѥåܥꥹȤ֤ޤ
     *
     * @return ܤ
     */
    SubAppendix[] getSubAppendixes() {
        return _sub;
    }

    /**
     * Ͽѥåλꤷǥåܤ֤ޤ
     *
     * @param index ǥå
     * @return  (ϰϳΥǥånull)
     */
    SubAppendix getSubAppendix(int index) {
        if (index < 0 || index >= _sub.length) {
            return null;
        }
        return _sub[index];
    }

    /**
     * CATALOG(S)ե뤫ɤ߹ߤޤ
     *
     * @param dir ϿѥåΥǥ쥯ȥ
     * @exception EBException CATALOG(S)եɤ߹˥顼ȯ
     */
    private void _loadCatalog(File dir) throws EBException {
        // եθ
        EBFile file = null;
        try {
            file = new EBFile(dir, "catalog", EBFile.FORMAT_PLAIN);
            _appendixType = Book.DISC_EB;
        } catch (EBException e) {
            file = new EBFile(dir, "catalogs", EBFile.FORMAT_PLAIN);
            _appendixType = Book.DISC_EPWING;
        }

        BookInputStream bis = file.getInputStream();
        try {
            byte[] b = new byte[16];
            bis.readFully(b, 0, b.length);

            // ܿμ
            int subCount = ByteUtil.getInt2(b, 0);
            if (subCount <= 0) {
                throw new EBException(EBException.UNEXP_FILE, file.getPath());
            }

            // ܤξ
            _sub = new SubAppendix[subCount];
            b = new byte[Book.SIZE_CATALOG[_appendixType]];
            int off = 2 + Book.SIZE_TITLE[_appendixType];
            for (int i=0; i<subCount; i++) {
                bis.readFully(b, 0, b.length);
                // ܥ֥Ȥκ
                String path = new String(b, off, Book.SIZE_DIRNAME).trim();
                _sub[i] = new SubAppendix(this, path);
            }
        } finally {
            bis.close();
        }
    }
}

// end of Appendix.java
