package fuku.eb4j;

/**
 * 㳰饹
 *
 * @author Hisaya FUKUMOTO
 * @version 0.3.3
 */
public final class EBException extends Exception {

    /** 顼 (ǥ쥯ȥ꤬Ĥʤ) */
    public static final int DIR_NOT_FOUND = 0;
    /** 顼 (ǥ쥯ȥ꤬ɤʤ) */
    public static final int CANT_READ_DIR = 1;

    /** 顼 (ե뤬Ĥʤ) */
    public static final int FILE_NOT_FOUND = 2;
    /** 顼 (ե뤬ɤʤ) */
    public static final int CANT_READ_FILE = 3;
    /** 顼 (եɤ߹ߥ顼) */
    public static final int FAILED_READ_FILE = 4;
    /** 顼 (եեޥåȥ顼) */
    public static final int UNEXP_FILE = 5;
    /** 顼 (ե륷顼) */
    public static final int FAILED_SEEK_FILE = 6;

    /** 顼å */
    private static final String[] _ERR_MSG = {
        "directory not found",
        "can't read directory",

        "file not found",
        "can't read a file",
        "failed to read a file",
        "unexpected format in a file",
        "failed to seek a file"
    };


    /**
     * ꤵ줿åEBExceptionۤޤ<BR>
     * å: "msg"
     *
     * @param msg ܺ٥å
     */
    public EBException(String msg) {
        super(msg);
    }

    /**
     * ꤵ줿顼ɤEBExceptionۤޤ<BR>
     * å: "ERR_MSG"
     *
     * @param code 顼
     */
    public EBException(int code) {
        this(_ERR_MSG[code]);
    }

    /**
     * ꤵ줿顼ɡEBExceptionۤޤ<BR>
     * å: "ERR_MSG (cause)"
     *
     * @param code 顼
     * @param cause 
     */
    public EBException(int code, Throwable cause) {
        this(_ERR_MSG[code] + " (" + cause.getMessage() + ")");
        setStackTrace(cause.getStackTrace());
    }

    /**
     * ꤵ줿顼ɡɲååEBExceptionۤޤ<BR>
     * å: "ERR_MSG (msg)"
     *
     * @param code 顼
     * @param msg ɲåå
     */
    public EBException(int code, String msg) {
        this(_ERR_MSG[code] + " (" + msg + ")");
    }

    /**
     * ꤵ줿顼ɡɲååEBExceptionۤޤ<BR>
     * å: "ERR_MSG (msg: cause)"
     *
     * @param code 顼
     * @param msg ɲåå
     * @param cause 
     */
    public EBException(int code, String msg, Throwable cause) {
        this(_ERR_MSG[code] + " (" + msg + ": " + cause.getMessage() + ")");
        setStackTrace(cause.getStackTrace());
    }

    /**
     * ꤵ줿顼ɡɲååEBExceptionۤޤ<BR>
     * å: "ERR_MSG (msg1: msg2)"
     *
     * @param code 顼
     * @param msg1 ɲåå1
     * @param msg2 ɲåå2
     */
    public EBException(int code, String msg1, String msg2) {
        this(_ERR_MSG[code] + " (" + msg1 + ": " + msg2 + ")");
    }
}

// end of EBException.java
