package fuku.eb4j;

import fuku.eb4j.util.ByteUtil;

/**
 * ǥå󥯥饹
 *
 * @author Hisaya FUKUMOTO
 * @version 0.3.3
 */
final class IndexStyle {

    /** ǥåե饰 (Ѵ) */
    static final int CONVERT = 0;
    /** ǥåե饰 (̵Ѵ) */
    static final int ASIS = 1;
    /** ǥåե饰 (Ѵ) */
    static final int REVERSE = 2;
    /** ǥåե饰 () */
    static final int DELETE = 2;
    /** ǥåID */
    private int _indexID = 0;
    /** ϥڡ */
    private long _startPage = 0L;
    /** λڡ */
    private long _endPage = 0L;
    /** ڡ */
    private long _candidatePage = 0L;
    /** Υ */
    private int _space = DELETE;
    /** Ҳ̾Υ */
    private int _katakana = CONVERT;
    /** ʸΥ */
    private int _lower = CONVERT;
    /** Υ */
    private int _mark = DELETE;
    /** Ĺ첻Υ */
    private int _longVowel = CONVERT;
    /** ¥Υ */
    private int _doubleConsonant = CONVERT;
    /** ٹΥ */
    private int _contractedSound = CONVERT;
    /** Υ */
    private int _voicedConsonant = CONVERT;
    /** 첻Υ */
    private int _smallVowel = CONVERT;
    /** ȾΥ */
    private int _psound = CONVERT;
    /** ٥ */
    private String _label = null;


    /**
     * 󥹥ȥ饯
     *
     */
    IndexStyle() {
        super();
    }


    /**
     * ǥåIDꤷޤ
     *
     * @param indexID ǥåID
     */
    void setIndexID(int indexID) {
        _indexID = indexID;
    }

    /**
     * ǥåID֤ޤ
     *
     * @return ǥåID
     */
    int getIndexID() {
        return _indexID;
    }

    /**
     * ϥڡ֤ꤷޤ
     *
     * @param startPage ϥڡ
     */
    void setStartPage(long startPage) {
        _startPage = startPage;
    }

    /**
     * ϥڡ֤֤ޤ
     *
     * @return ϥڡ
     */
    long getStartPage() {
        return _startPage;
    }

    /**
     * λڡ֤ꤷޤ
     *
     * @param endPage λڡ
     */
    void setEndPage(long endPage) {
        _endPage = endPage;
    }

    /**
     * λڡ֤֤ޤ
     *
     * @return λڡ
     */
    long getEndPage() {
        return _endPage;
    }

    /**
     * ڡ֤ꤷޤ
     *
     * @param candidatePage ڡ
     */
    void setCandidatePage(long candidatePage) {
        _candidatePage = candidatePage;
    }

    /**
     * ڡ֤֤ޤ
     *
     * @return ڡ
     */
    long getCandidatePage() {
        return _candidatePage;
    }

    /**
     * Υꤷޤ
     *
     * @param style Υ
     */
    void setSpaceStyle(int style) {
        _space = style;
    }

    /**
     * Ҳ̾Υꤷޤ
     *
     * @param style Ҳ̾Υ
     */
    void setKatakanaStyle(int style) {
        _katakana = style;
    }

    /**
     * ʸΥꤷޤ
     *
     * @param style ʸΥ
     */
    void setLowerStyle(int style) {
        _lower = style;
    }

    /**
     * Υꤷޤ
     *
     * @param style Υ
     */
    void setMarkStyle(int style) {
        _mark = style;
    }

    /**
     * Ĺ첻Υꤷޤ
     *
     * @param style Ĺ첻Υ
     */
    void setLongVowelStyle(int style) {
        _longVowel = style;
    }

    /**
     * ¥Υꤷޤ
     *
     * @param style ¥Υ
     */
    void setDoubleConsonantStyle(int style) {
        _doubleConsonant = style;
    }

    /**
     * ٹΥꤷޤ
     *
     * @param style ٹΥ
     */
    void setContractedSoundStyle(int style) {
        _contractedSound = style;
    }

    /**
     * Υꤷޤ
     *
     * @param style Υ
     */
    void setVoicedConsonantStyle(int style) {
        _voicedConsonant = style;
    }

    /**
     * 첻Υꤷޤ
     *
     * @param style 첻Υ
     */
    void setSmallVowelStyle(int style) {
        _smallVowel = style;
    }

    /**
     * ȾΥꤷޤ
     *
     * @param style ȾΥ
     */
    void setPSoundStyle(int style) {
        _psound = style;
    }

    /**
     * ٥ꤷޤ
     *
     * @param label ٥
     */
    void setLabel(String label) {
        _label = label;
    }

    /**
     * ٥֤ޤ
     *
     * @return ٥
     */
    String getLabel() {
        return _label;
    }

    /**
     * ꤵ줿ХΥޤ
     *
     * @param b ISO 8859-1ʸåȤΥХ
     */
    void fixWordLatin(byte[] b) {
        if (_indexID == 0xa1 && _candidatePage != 0) {
            return;
        }

        if (_space == DELETE) {
            ByteUtil.deleteSpaceLatin(b);
        }
        if (_lower == CONVERT) {
            ByteUtil.lowerToUpperLatin(b);
        }
    }

    /**
     * ꤵ줿ХΥޤ
     *
     * @param b JIS X 0208ʸåȤΥХ
     */
    void fixWord(byte[] b) {
        if (_indexID == 0xa1 && _candidatePage != 0) {
            return;
        }

        if (_space == DELETE) {
            ByteUtil.deleteSpace(b);
        }
        if (_katakana == CONVERT) {
            ByteUtil.katakanaToHiragana(b);
        } else if (_katakana == REVERSE) {
            ByteUtil.hiraganaToKatakana(b);
        }
        if (_lower == CONVERT) {
            ByteUtil.lowerToUpper(b);
        }
        if (_mark == DELETE) {
            ByteUtil.deleteMark(b);
        }
        if (_longVowel == CONVERT) {
            ByteUtil.convertLongVowel(b);
        } else if (_longVowel == DELETE) {
            ByteUtil.deleteLongVowel(b);
        }
        if (_doubleConsonant == CONVERT) {
            ByteUtil.convertDoubleConsonant(b);
        }
        if (_contractedSound == CONVERT) {
            ByteUtil.convertContractedSound(b);
        }
        if (_smallVowel == CONVERT) {
            ByteUtil.convertSmallVowel(b);
        }
        if (_voicedConsonant == CONVERT) {
            ByteUtil.convertVoicedConsonant(b);
        }
        if (_psound == CONVERT) {
            ByteUtil.convertPSound(b);
        }
    }
}

// end of IndexStyle.java
