package fuku.eb4j;

import java.util.*;

import fuku.eb4j.io.EBFile;

/**
 * ʣ측饹
 *
 * @author Hisaya FUKUMOTO
 * @version 0.3.3
 */
final class SearchMultiple extends SearchMethod {

    /**  */
    private SubBook _sub = null;
    /** ǥå */
    private IndexStyle _style = null;
    /** ȥΥǥå */
    private IndexStyle[] _entry = null;
    /** ƸˤĤƸ븡֥ */
    private SearchSingle[] _searcher = null;


    /**
     * 󥹥ȥ饯
     *
     * @param sub 
     * @param style ǥå
     */
    SearchMultiple(SubBook sub, IndexStyle style) {
        super();
        _sub = sub;
        _style = style;
    }

    /**
     * 󥹥ȥ饯
     *
     * @param sub 
     * @param multi ʣ縡ѥǥå
     * @param entry ʣ縡ȥѥǥå
     */
    SearchMultiple(SubBook sub, IndexStyle multi, IndexStyle[] entry) {
        super();
        _sub = sub;
        _style = multi;
        _entry = entry;
    }


    /**
     * Ԥޤ
     *
     * @param word 
     * @param file ե
     * @exception EBException ˥顼ȯ
     */
    void search(byte[][] word, EBFile file) throws EBException {
        int len = word.length;
        List list = new ArrayList(len);
        if (_entry == null) {
            for (int i=0; i<len; i++) {
                if (word[i] != null && word[i].length > 0) {
                    SearchSingle search =
                        new SearchSingle(_sub, _style, SearchSingle.KEYWORD);
                    search.search(word[i], file);
                    list.add(search);
                }
            }
        } else {
            for (int i=0; i<len; i++) {
                if (word[i] != null && word[i].length > 0) {
                    SearchSingle search =
                        new SearchSingle(_sub, _entry[i], SearchSingle.MULTI);
                    search.search(word[i], file);
                    list.add(search);
                }
            }
        }
        _searcher = (SearchSingle[])list.toArray(new SearchSingle[0]);
    }

    /**
     * θ̤֤ޤ
     *
     * @return  (θ̤ʤnull)
     * @exception EBException ˥顼ȯ
     */
    Result getNextResult() throws EBException {
        if (_searcher == null || _searcher.length <= 0) {
            return null;
        }
        Result[] result = new Result[_searcher.length];
        return _getAndResult(result, -1);
    }

    /**
     * ٤Ƥξ˹פ븡̤֤ޤ
     *
     * @param list ̥ꥹ
     * @param index ʸ֤Υǥå
     * @return 
     * @exception EBException ˥顼ȯ
     */
    private Result _getAndResult(Result[] result, int index) throws EBException {
        long pos1 = -1L;
        long pos2 = -1L;
        int max = 0;
        int len = result.length;
        if (index < 0) {
            // ̤μ
            for (int i=0; i<len; i++) {
                result[i] = _searcher[i].getNextResult();
                if (result[i] == null) {
                    return null;
                }
                pos2 = result[i].getTextPosition();
                if (pos1 < 0) {
                    pos1 = pos2;
                    max = i;
                } else if (pos1 < pos2) {
                    pos1 = pos2;
                    max = i;
                }
            }
        } else {
            // ̤ι
            pos1 = result[index].getTextPosition();
            max = index;
            for (int i=0; i<len; i++) {
                if (pos1 != result[i].getTextPosition()) {
                    result[i] = _searcher[i].getNextResult();
                    if (result[i] == null) {
                        return null;
                    }
                    pos2 = result[i].getTextPosition();
                    if (pos1 < pos2) {
                        pos1 = pos2;
                        max = i;
                    }
                }
            }
        }

        // ʸ֤Ʊ֤θ̿
        int count = 0;
        pos1 = result[max].getTextPosition();
        for (int i=0; i<len; i++) {
            if (pos1 == result[i].getTextPosition()) {
                count++;
            }
        }

        if (count != len) {
            return _getAndResult(result, max);
        }
        return result[max];
    }
}

// end of SearchMultiple.java
