package fuku.eb4j;

import fuku.eb4j.io.EBFile;
import fuku.eb4j.io.BookInputStream;
import fuku.eb4j.util.ByteUtil;
import fuku.eb4j.util.CompareUtil;

/**
 * ñ측측饹
 *
 * @author Hisaya FUKUMOTO
 * @version 0.3.3
 */
final class SearchSingle extends SearchMethod {

    /** ׸򼨤 */
    static final int WORD = 0;
    /** ׸򼨤 */
    static final int ENDWORD = 1;
    /** ׸򼨤 */
    static final int EXACTWORD = 2;
    /** ︡򼨤 */
    static final int KEYWORD = 3;
    /** ʣ縡򼨤 */
    static final int MULTI = 4;

    /** 祤ǥå */
    private static final int MAX_INDEX_DEPTH = 6;

    /** ܤ֥ */
    private static final int VARIABLE = 0;
    /** ܤ֥ */
    private static final int FIXED = 1;

    /**  */
    private SubBook _sub = null;
    /** ǥå */
    private IndexStyle _style = null;
    /** ߤθ */
    private int _type = 0;

    /**  */
    private byte[] _word = null;
    /**  */
    private byte[] _canonical = null;
    /** ե */
    private EBFile _file = null;

    /** å */
    private byte[] _cache = new byte[BookInputStream.PAGE_SIZE];
    /** 㥷Υڡ */
    private long _cachePage = 0L;
    /** 㥷ΥեåȰ */
    private int _off = 0;

    /** ǡΥڡ */
    private long _page = 0L;
    /** ǡΥڡID */
    private int _pageID = 0;
    /** ȥΥ */
    private int _entryLength = 0;
    /** ȥˡ */
    private int _entryArrangement = 0;
    /** ȥο */
    private int _entryCount = 0;
    /** ȥΥǥå */
    private int _entryIndex = 0;
    /** 롼ץȥǤ뤳Ȥ򼨤ե饰 */
    private boolean _inGroupEntry = false;
    /** ӷ */
    private int _comparison = -1;

    /** ɸѸФ */
    private long _keywordHeading = 0L;


    /**
     * 󥹥ȥ饯
     *
     * @param sub 
     * @param style ǥå
     * @param type 
     * @see SearchSingle#WORD
     * @see SearchSingle#ENDWORD
     * @see SearchSingle#EXACTWORD
     * @see SearchSingle#KEYWORD
     * @see SearchSingle#MULTI
     */
    SearchSingle(SubBook sub, IndexStyle style, int type) {
        super();
        _sub = sub;
        _style = style;
        _type = type;
    }


    /**
     * ꤷޤ
     *
     * @param word 
     */
    private void _setWord(byte[] word) {
        _word = word;
        _canonical = new byte[_word.length];
        System.arraycopy(_word, 0, _canonical, 0, _word.length);

        if (_sub.getBook().getCharCode() == Book.CHARCODE_ISO8859_1) {
            _style.fixWordLatin(_canonical);
        } else {
            _style.fixWord(_canonical);
        }

        if (_style.getIndexID() != 0x70 && _style.getIndexID() != 0x90) {
            System.arraycopy(_canonical, 0, _word, 0, _word.length);
        }

        // ξ硢ȿž
        if (_type == ENDWORD) {
            if (_sub.getBook().getCharCode() == Book.CHARCODE_ISO8859_1) {
                ByteUtil.reverseWordLatin(_word);
                ByteUtil.reverseWordLatin(_canonical);
            } else {
                ByteUtil.reverseWord(_word);
                ByteUtil.reverseWord(_canonical);
            }
        }
    }

    /**
     * ȥѥӤޤ
     *
     * @param canonical 
     * @param pattern ѥ
     * @return ѥƱ:0
     *         ѥ礭:1ʾ塢
     *         ѥ꾮:-1ʲ
     */
    private int _compareToCanonical(byte[] canonical, byte[] pattern) {
        boolean exact = false;
        if (_type == EXACTWORD || _type == KEYWORD || _type == MULTI) {
            exact = true;
        }
        return CompareUtil.compareToCanonical(canonical, pattern, exact);
    }

    /**
     * ȥѥӤޤ
     *
     * @param word 
     * @param pattern ѥ
     * @return 줬ѥƱ:0
     *         줬ѥ礭:1ʾ塢
     *         줬ѥ꾮:-1ʲ
     */
    private int _compareToWord(byte[] word, byte[] pattern) {
        boolean exact = false;
        if (_type == EXACTWORD || _type == KEYWORD || _type == MULTI) {
            exact = true;
        }
        int ret = 0;
        if (_sub.getBook().getCharCode() == Book.CHARCODE_ISO8859_1) {
            ret = CompareUtil.compareToLatin(word, pattern, exact);
        } else {
            ret = CompareUtil.compareTo(word, pattern, exact);
        }
        return ret;
    }

    /**
     * Ԥޤ
     *
     * @param word 
     * @param file ե
     * @exception EBException ˥顼ȯ
     */
    void search(byte[] word, EBFile file) throws EBException {
        _setWord(word);
        _file = file;
        _page = _style.getStartPage();

        BookInputStream bis = _file.getInputStream();
        try {
            long nextPage = _page;
            int depth;
            for (depth=0; depth<MAX_INDEX_DEPTH; depth++) {
                // ǡ򥭥åɤ߹
                bis.seek(_page, 0);
                bis.readFully(_cache, 0, _cache.length);
                _cachePage = _page;

                _pageID = _cache[0] & 0xff;
                _entryLength = _cache[1] & 0xff;
                if (_entryLength == 0) {
                    _entryArrangement = VARIABLE;
                } else {
                    _entryArrangement = FIXED;
                }
                _entryCount = ByteUtil.getInt2(_cache, 2);
                _off = 4;

                // ꡼եǥåãä롼׽λ
                if (_isLeafLayer(_pageID)) {
                    break;
                }

                // Υ٥Υǥå
                byte[] b = new byte[_entryLength];
                for (_entryIndex=0; _entryIndex<_entryCount; _entryIndex++) {
                    if (_off + _entryLength + 4 > BookInputStream.PAGE_SIZE) {
                        throw new EBException(EBException.UNEXP_FILE,
                                              _file.getPath());
                    }
                    System.arraycopy(_cache, _off, b, 0, b.length);
                    _off += _entryLength;
                    if (_compareToCanonical(_canonical, b) <= 0) {
                        nextPage = ByteUtil.getLong4(_cache, _off);
                        break;
                    }
                    _off += 4;
                }
                if (_entryIndex >= _entryCount || nextPage == _page) {
                    _comparison = -1;
                    return;
                }
                _page = nextPage;
            }

            // ǥåΥå
            if (depth == MAX_INDEX_DEPTH) {
                throw new EBException(EBException.UNEXP_FILE,
                                      _file.getPath());
            }
        } finally {
            bis.close();
        }
        _entryIndex = 0;
        _comparison = 1;
        _inGroupEntry = false;
    }

    /**
     * θ̤֤ޤ
     *
     * @return  (θ̤ʤnull)
     * @exception EBException ˥顼ȯ
     */
    Result getNextResult() throws EBException {
        if (_comparison < 0) {
            return null;
        }

        while (true) {
            // åȥǡΥڡۤʤɤ߹
            if (_cachePage != _page) {
                BookInputStream bis = _file.getInputStream();
                try {
                    bis.seek(_page, 0);
                    bis.readFully(_cache, 0, _cache.length);
                } finally {
                    bis.close();
                }
                _cachePage = _page;

                if (_entryIndex == 0) {
                    _pageID = _cache[0] & 0xff;
                    _entryLength = _cache[1] & 0xff;
                    if (_entryLength == 0) {
                        _entryArrangement = VARIABLE;
                    } else {
                        _entryArrangement = FIXED;
                    }
                    _entryCount = ByteUtil.getInt2(_cache, 2);
                    _entryIndex = 0;
                    _off = 4;
                }
            }

            if (!_isLeafLayer(_pageID)) {
                // ꡼եǥåǤʤ㳰
                throw new EBException(EBException.UNEXP_FILE,
                                      _file.getPath());
            }

            if (!_hasGroupEntry(_pageID)) {
                // 롼ץȥʤ
                while (_entryIndex < _entryCount) {
                    if (_entryArrangement == VARIABLE) {
                        if (_off + 1 > BookInputStream.PAGE_SIZE) {
                            throw new EBException(EBException.UNEXP_FILE,
                                                  _file.getPath());
                        }
                        _entryLength = _cache[_off] & 0xff;
                        _off++;
                    }

                    if (_off + _entryLength + 12 > BookInputStream.PAGE_SIZE) {
                        throw new EBException(EBException.UNEXP_FILE,
                                              _file.getPath());
                    }

                    byte[] b = new byte[_entryLength];
                    System.arraycopy(_cache, _off, b, 0, b.length);
                    _off += _entryLength;

                    _comparison = _compareToWord(_word, b);
                    Result result = null;
                    if (_comparison == 0) {
                        // ʸ/Ф֤μ
                        long tPage = ByteUtil.getLong4(_cache, _off);
                        int tOff = ByteUtil.getInt2(_cache, _off+4);
                        long hPage = ByteUtil.getLong4(_cache, _off+6);
                        int hOff = ByteUtil.getInt2(_cache, _off+10);
                        result = new Result(hPage, hOff, tPage, tOff);
                    }

                    _entryIndex++;
                    _off += 12;

                    if (result != null) {
                        return result;
                    }

                    if (_comparison < 0) {
                        return null;
                    }
                }
            } else {
                // 롼ץȥꤢ
                while (_entryIndex < _entryCount) {
                    if (_off + 2 > BookInputStream.PAGE_SIZE) {
                        throw new EBException(EBException.UNEXP_FILE,
                                              _file.getPath());
                    }
                    int groupID = _cache[_off] & 0xff;
                    Result result = null;
                    if (groupID == 0x00) {
                        // 󥰥륨ȥ
                        _entryLength = _cache[_off+1] & 0xff;
                        if (_off + _entryLength + 14 > BookInputStream.PAGE_SIZE) {
                            throw new EBException(EBException.UNEXP_FILE,
                                                  _file.getPath());
                        }

                        byte[] b = new byte[_entryLength];
                        System.arraycopy(_cache, _off+2, b, 0, b.length);
                        _off += _entryLength + 2;

                        _comparison = _compareToWord(_canonical, b);
                        if (_comparison == 0 && _compareToWord(_word, b) == 0) {
                            // ʸ/Ф֤μ
                            long tPage = ByteUtil.getLong4(_cache, _off);
                            int tOff = ByteUtil.getInt2(_cache, _off+4);
                            long hPage = ByteUtil.getLong4(_cache, _off+6);
                            int hOff = ByteUtil.getInt2(_cache, _off+10);
                            result = new Result(hPage, hOff, tPage, tOff);
                        }
                        _off += 12;
                        _inGroupEntry = false;
                    } else if (groupID == 0x80) {
                        // 롼ץȥγ
                        _entryLength = _cache[_off+1] & 0xff;
                        byte[] b = new byte[_entryLength];
                        if (_type == KEYWORD) {
                            if (_off + _entryLength + 12 > BookInputStream.PAGE_SIZE) {
                                throw new EBException(EBException.UNEXP_FILE,
                                                      _file.getPath());
                            }

                            System.arraycopy(_cache, _off+6, b, 0, b.length);
                            _off += _entryLength + 6;
                            _comparison = _compareToWord(_word, b);
                            long hPage = ByteUtil.getLong4(_cache, _off);
                            int hOff = ByteUtil.getInt2(_cache, _off+4);
                            _keywordHeading =
                                BookInputStream.getPosition(hPage, hOff);
                            _off += 6;
                        } else if (_type == MULTI) {
                            if (_off + _entryLength + 6 > BookInputStream.PAGE_SIZE) {
                                throw new EBException(EBException.UNEXP_FILE,
                                                      _file.getPath());
                            }

                            System.arraycopy(_cache, _off+6, b, 0, b.length);
                            _comparison = _compareToWord(_word, b);
                            _off += _entryLength + 6;
                        } else {
                            if (_off + _entryLength + 4 > BookInputStream.PAGE_SIZE) {
                                throw new EBException(EBException.UNEXP_FILE,
                                                      _file.getPath());
                            }

                            System.arraycopy(_cache, _off+4, b, 0, b.length);
                            _comparison = _compareToWord(_canonical, b);
                            _off += _entryLength + 4;
                        }
                        _inGroupEntry = true;
                    } else if (groupID == 0xc0) {
                        // 롼ץȥ
                        if (_type == KEYWORD) {
                            if (_off + 7 > BookInputStream.PAGE_SIZE) {
                                throw new EBException(EBException.UNEXP_FILE,
                                                      _file.getPath());
                            }

                            if (_comparison == 0 && _inGroupEntry) {
                                // ʸ/Ф֤μ
                                long tPage = ByteUtil.getLong4(_cache, _off+1);
                                int tOff = ByteUtil.getInt2(_cache, _off+5);
                                result = new Result(_keywordHeading, tPage, tOff);
                                _keywordHeading =
                                    _sub.getNextHeadingPosition(_keywordHeading);
                            }
                            _off += 7;
                        } else if (_type == MULTI) {
                            if (_off + 13 > BookInputStream.PAGE_SIZE) {
                                throw new EBException(EBException.UNEXP_FILE,
                                                      _file.getPath());
                            }

                            if (_comparison == 0 && _inGroupEntry) {
                                // ʸ/Ф֤μ
                                long tPage = ByteUtil.getLong4(_cache, _off+1);
                                int tOff = ByteUtil.getInt2(_cache, _off+5);
                                long hPage = ByteUtil.getLong4(_cache, _off+7);
                                int hOff = ByteUtil.getInt2(_cache, _off+11);
                                result = new Result(hPage, hOff, tPage, tOff);
                            }
                            _off += 13;
                        } else {
                            _entryLength = _cache[_off+1] & 0xff;
                            if (_off + _entryLength + 14 > BookInputStream.PAGE_SIZE) {
                                throw new EBException(EBException.UNEXP_FILE,
                                                      _file.getPath());
                            }

                            byte[] b = new byte[_entryLength];
                            System.arraycopy(_cache, _off+2, b, 0, b.length);
                            _off += _entryLength + 2;
                            if (_comparison == 0 && _inGroupEntry
                                && _compareToWord(_word, b) == 0) {
                                // ʸ/Ф֤μ
                                long tPage = ByteUtil.getLong4(_cache, _off);
                                int tOff = ByteUtil.getInt2(_cache, _off+4);
                                long hPage = ByteUtil.getLong4(_cache, _off+6);
                                int hOff = ByteUtil.getInt2(_cache, _off+10);
                                result = new Result(hPage, hOff, tPage, tOff);
                            }
                            _off += 12;
                        }
                    } else {
                        // ̤ΤID
                        throw new EBException(EBException.UNEXP_FILE,
                                              _file.getPath());
                    }

                    _entryIndex++;

                    if (result != null) {
                        return result;
                    }

                    if (_comparison < 0) {
                        return null;
                    }
                }
            }

            // ڡ¸ߤ³ԡ¸ߤʤнλ
            if (_isLayerEnd(_pageID)) {
                _comparison = -1;
                break;
            }
            _page++;
            _entryIndex = 0;
        }
        return null;
    }

    /**
     * ꤵ줿ڡǲؤɤȽ̤ޤ
     *
     * @param id ڡID
     * @return ǲؤǤtrueǤʤfalse
     */
    private boolean _isLeafLayer(int id) {
        if ((id & 0x80) == 0x80) {
            return true;
        }
        return false;
    }

    /**
     * ꤵ줿ڡسϥڡɤȽ̤ޤ
     *
     * @param id ڡID
     * @return سϥڡǤtrueǤʤfalse
     */
    private boolean _isLayerStart(int id) {
        if ((id & 0x40) == 0x40) {
            return true;
        }
        return false;
    }

    /**
     * ꤵ줿ڡؽλڡɤȽ̤ޤ
     *
     * @param id ڡID
     * @return ؽλڡǤtrueǤʤfalse
     */
    private boolean _isLayerEnd(int id) {
        if ((id & 0x20) == 0x20) {
            return true;
        }
        return false;
    }

    /**
     * ꤵ줿ڡ롼ץȥޤǤ뤫ɤȽ̤ޤ
     *
     * @param id ڡID
     * @return 롼ץȥޤǤtrueǤʤfalse
     */
    private boolean _hasGroupEntry(int id) {
        if ((id & 0x10) == 0x10) {
            return true;
        }
        return false;
    }
}

// end of SearchSingle.java
