package fuku.eb4j.io;

import java.io.*;

import fuku.eb4j.Book;
import fuku.eb4j.SubBook;
import fuku.eb4j.EBException;
import fuku.eb4j.hook.Hook;
import fuku.eb4j.hook.DefaultHook;
import fuku.eb4j.util.ByteUtil;

/**
 * ϥȥ꡼फƥȤɤ߹९饹
 *
 * @author Hisaya FUKUMOTO
 * @version 0.3.3
 */
public final class BookReader {

    /** ʸǤ뤳Ȥ򼨤 */
    private static final int TEXT = 0;
    /** ФǤ뤳Ȥ򼨤 */
    private static final int HEADING = 1;

    /**  */
    private SubBook _sub = null;
    /** ե */
    private EBFile _file = null;
    /** ɤ߹ߥȥ꡼ */
    private BookInputStream _bis = null;
    /** եå */
    private Hook _hook = null;
    /** ȥåץ */
    private int _autoStopCode = -1;
    /** åץ */
    private int _skipCode = -1;


    /**
     * 󥹥ȥ饯
     *
     * @param sub 
     * @param file ե
     * @exception EBException ϥ顼ȯ
     */
    public BookReader(SubBook sub, EBFile file) throws EBException {
        this(sub, file, null);
    }

    /**
     * 󥹥ȥ饯
     *
     * @param sub 
     * @param file ե
     * @param hook եå
     * @exception EBException ϥ顼ȯ
     */
    public BookReader(SubBook sub, EBFile file, Hook hook) throws EBException {
        super();
        _sub = sub;
        _file = file;
        _bis = file.getInputStream();
        if (hook == null) {
            _hook = new DefaultHook(_sub);
        } else {
            _hook = hook;
        }
    }


    /**
     * ɤ߹ߥȥ꡼Ĥޤ
     *
     */
    public void close() {
        _bis.close();
    }

    /**
     * Фɤ߹ߡեåǲùޤ
     *
     * @param page ڡֹ
     * @param offset ڡ⥪եå
     * @return եåǲù줿֥
     *         (ȥ꡼νãäƤnull)
     * @exception EBException ϥ顼ȯ
     */
    public Object readHeading(long page, int offset) throws EBException {
        return _read(BookInputStream.getPosition(page, offset), HEADING, false);
    }

    /**
     * Фɤ߹ߡեåǲùޤ
     *
     * @param pos ɤ߹߰
     * @return եåǲù줿֥
     *         (ȥ꡼νãäƤnull)
     * @exception EBException ϥ顼ȯ
     */
    public Object readHeading(long pos) throws EBException {
        return _read(pos, HEADING, false);
    }

    /**
     * ꤵ줿֤μθФ֤֤ޤ
     *
     * @param pos ɤ߹߰
     * @return θФ (ȥ꡼νãäƤ-1)
     * @exception EBException ϥ顼ȯ
     */
    public long nextHeadingPosition(long pos) throws EBException {
        Long val = (Long)_read(pos, HEADING, true);
        if (val == null) {
            return -1L;
        }
        return val.longValue();
    }

    /**
     * ʸɤ߹ߡեåǲùޤ
     *
     * @param page ڡֹ
     * @param offset ڡ⥪եå
     * @return եåǲù줿֥
     *         (ȥ꡼νãäƤnull)
     * @exception EBException ϥ顼ȯ
     */
    public Object readText(long page, int offset) throws EBException {
        return _read(BookInputStream.getPosition(page, offset), TEXT, false);
    }

    /**
     * ʸɤ߹ߡեåǲùޤ
     *
     * @param pos ɤ߹߰
     * @return եåǲù줿֥
     *         (ȥ꡼νãäƤnull)
     * @exception EBException ϥ顼ȯ
     */
    public Object readText(long pos) throws EBException {
        return _read(pos, TEXT, false);
    }

    /**
     * ƥȤɤ߹ߡեåǲùޤ
     *
     * @param pos ɤ߹߰
     * @param type ɤ߹ߥǡΥ
     * @param skip ΰ֤֤
     * @return եåǲù줿֥
     *         (ȥ꡼νãäƤnull)
     * @exception EBException ϥ顼ȯ
     */
    private Object _read(long pos, int type, boolean skip) throws EBException {
        _bis.seek(pos);
        if (!skip) {
            _hook.clear();
        }

        // ǡɤ߹
        byte[] b = new byte[BookInputStream.PAGE_SIZE];
        int len = _bis.read(b, 0, b.length);
        if (len < 0) {
            return null;
        } else if (len == 0) {
            throw new EBException(EBException.UNEXP_FILE, _file.getPath());
        }

        // ǡβ
        int off = 0;
        boolean eof = false;
        boolean printable = false;
        while (!eof) {
            if (off + 2 > len) {
                int n = _readRaw(b, off, len-off);
                len = len - off + n;
                off = 0;
            }
            if ((b[off] & 0xff) == 0x1f) { // ץ
                int code = ByteUtil.getInt2(b, off);
                int page1, page2, off1, off2, format, width, height;
                switch (b[off+1] & 0xff) {
                    case 0x02:
                        // ƥȳ
                        off += 2;
                        break;
                    case 0x03:
                        // ƥȽλ
                        eof = true;
                        break;
                    case 0x04:
                        // Ⱦɽγ
                        off += 2;
                        if (!skip) {
                            _hook.beginNarrow();
                        }
                        break;
                    case 0x05:
                        // Ⱦɽνλ
                        off += 2;
                        if (!skip) {
                            _hook.endNarrow();
                        }
                        break;
                    case 0x06:
                        // դγ
                        off += 2;
                        if (!skip) {
                            _hook.beginSubscript();
                        }
                        break;
                    case 0x07:
                        // դνλ
                        off += 2;
                        if (!skip) {
                            _hook.endSubscript();
                        }
                        break;
                    case 0x09:
                        // 
                        if (off + 4 > len) {
                            int n = _readRaw(b, off, len-off);
                            len = len - off + n;
                            off = 0;
                        }

                        if (printable && type == TEXT
                            && _isStopCode(code, ByteUtil.getInt2(b, off+2))) {
                            eof = true;
                        } else if (!skip) {
                            _hook.setIndent(ByteUtil.getInt2(b, off+2));
                        }
                        off += 4;
                        break;
                    case 0x0a:
                        // 
                        off += 2;
                        if (type == HEADING) {
                            eof = true;
                        } else if (!skip) {
                            _hook.newLine();
                        }
                        break;
                    case 0x0e:
                        // դγ
                        off += 2;
                        if (!skip) {
                            _hook.beginSuperscript();
                        }
                        break;
                    case 0x0f:
                        // դνλ
                        off += 2;
                        if (!skip) {
                            _hook.endSuperscript();
                        }
                        break;
                    case 0x10:
                        // Զػߤγ
                        off += 2;
                        if (!skip) {
                            _hook.beginNoNewLine();
                        }
                        break;
                    case 0x11:
                        // Զػߤνλ
                        off += 2;
                        if (!skip) {
                            _hook.endNoNewLine();
                        }
                        break;
                    case 0x12:
                        // Ĵγ
                        off += 2;
                        if (!skip) {
                            _hook.beginEmphasis();
                        }
                        break;
                    case 0x13:
                        // Ĵνλ
                        off += 2;
                        if (!skip) {
                            _hook.endEmphasis();
                        }
                        break;
                    case 0x14:
                        off += 4;
                        _skipCode = 0x15;
                        break;
                    case 0x1a:
                    case 0x1b:
                    case 0x1c:
                    case 0x1d:
                    case 0x1e:
                    case 0x1f:
                        if (off + 4 > len) {
                            int n = _readRaw(b, off, len-off);
                            len = len - off + n;
                            off = 0;
                        }
                        if (_sub.getBook().getBookType() == Book.DISC_EB
                            && (b[off+2] & 0xff) == 0x1f) {
                            off += 2;
                        } else {
                            off += 4;
                        }
                        break;
                    case 0x32:
                        // ΥȤγ (for EB)
                        off += 2;
                        if (!skip) {
                            _hook.beginMonoGraphic(0, 0);
                        }
                        break;
                    case 0x39:
                        // MPEGưγ
                        if (off + 46 > len) {
                            int n = _readRaw(b, off, len-off);
                            len = len - off + n;
                            off = 0;
                        }
                        if (!skip) {
                            int n = 8;
                            int[] args = new int[n];
                            for (int i=0; i<n; i++) {
                                args[i] = ByteUtil.getInt2(b, off+22+i*2);
                            }
                            byte[] name = new byte[n];
                            int size = n;
                            for (int i=0; i<n; i++) {
                                int high = (args[i] >>> 8) & 0xff;
                                int low = args[i] & 0xff;
                                if ((high == 0x21 && low == 0x21)
                                    || (high == 0x00 && low == 0x00)) {
                                    size = i;
                                    break;
                                } else if (high == 0x23) {
                                    if ((low >= 0x30 && low <= 0x39)
                                        || (low >= 0x61 && low <= 0x7a)) {
                                        name[i] = (byte)low;
                                    } else if (low >= 0x41 && low <= 0x5a) {
                                        name[i] = (byte)(low | 0x20);
                                    } else {
                                        size = 0;
                                        break;
                                    }
                                } else {
                                    size = 0;
                                    break;
                                }
                            }
                            if (size != 0) {
                                _hook.beginMPEG(new String(name, 0, size));
                            }
                        }
                        off += 46;
                        break;
                    case 0x3c:
                        // 饤󥫥顼γ
                        if (off + 20 > len) {
                            int n = _readRaw(b, off, len-off);
                            len = len - off + n;
                            off = 0;
                        }
                        if (!skip) {
                            format = ByteUtil.getInt2(b, off+2);
                            page1 = ByteUtil.getBCD4(b, off+14);
                            off1 = ByteUtil.getBCD2(b, off+18);
                            if (format >>> 8 == 0x00) {
                                _hook.beginInlineColorDIB(BookInputStream.getPosition(page1, off1));
                            } else {
                                _hook.beginInlineColorJPEG(BookInputStream.getPosition(page1, off1));
                            }
                        }
                        off += 20;
                        break;
                    case 0x35:
                    case 0x36:
                    case 0x37:
                    case 0x38:
                    case 0x3a:
                    case 0x3b:
                    case 0x3d:
                    case 0x3e:
                    case 0x3f:
                        off += 2;
                        _skipCode = (b[off-1] & 0xff) + 0x20;
                        break;
                    case 0x41:
                        // ɤγ
                        if (off + 4 > len) {
                            int n = _readRaw(b, off, len-off);
                            len = len - off + n;
                            off = 0;
                        }
                        if (printable && type == TEXT
                            && _isStopCode(code, ByteUtil.getInt2(b, off+2))) {
                            eof = true;
                        } else {
                            if (_autoStopCode < 0) {
                                _autoStopCode = ByteUtil.getInt2(b, off+2);
                            }
                            if (!skip) {
                                _hook.beginKeyword();
                            }
                        }
                        off += 4;
                        break;
                    case 0x42:
                        // Ȥγ
                        if (off + 4 > len) {
                            int n = _readRaw(b, off, len-off);
                            len = len - off + n;
                            off = 0;
                        }
                        if ((b[off+2] & 0xff) != 0x00) {
                            off += 2;
                        } else {
                            off += 4;
                        }
                        if (!skip) {
                            _hook.beginReference();
                        }
                        break;
                    case 0x43:
                        // ܤγ
                        off += 2;
                        if (_skipCode == -1) {
                        }
                        if (!skip) {
                            _hook.beginCandidate();
                        }
                        break;
                    case 0x44:
                        // ΥȤγ (for EPWING)
                        if (off + 12 > len) {
                            int n = _readRaw(b, off, len-off);
                            len = len - off + n;
                            off = 0;
                        }
                        if (!skip) {
                            height = ByteUtil.getBCD4(b, off+4);
                            width = ByteUtil.getBCD4(b, off+8);
                            if (width > 0 && height > 0) {
                                _hook.beginMonoGraphic(width, height);
                            }
                        }
                        off += 12;
                        break;
                    case 0x45:
                        // ֥åγ
                        if (off + 4 > len) {
                            int n = _readRaw(b, off, len-off);
                            len = len - off + n;
                            off = 0;
                        }
                        if ((b[off+2] & 0xff) != 0x1f) {
                            off += 4;
                        } else {
                            off += 6;
                        }
                        break;
                    case 0x4a:
                        // WAVEγ
                        if (off + 18 > len) {
                            int n = _readRaw(b, off, len-off);
                            len = len - off + n;
                            off = 0;
                        }
                        if (!skip) {
                            page1 = ByteUtil.getBCD4(b, off+6);
                            off1 = ByteUtil.getBCD2(b, off+10);
                            page2 = ByteUtil.getBCD4(b, off+12);
                            off2 = ByteUtil.getBCD2(b, off+16);
                            _hook.beginWaveSound(BookInputStream.getPosition(page1, off1),
                                                 BookInputStream.getPosition(page2, off2));
                        }
                        off += 18;
                        break;
                    case 0x4b:
                        // ڡȤγ
                        if (off + 8 > len) {
                            int n = _readRaw(b, off, len-off);
                            len = len - off + n;
                            off = 0;
                        }
                        off += 8;
                        break;
                    case 0x4d:
                        // 顼(DIB/JPEG)γ
                        if (off + 20 > len) {
                            int n = _readRaw(b, off, len-off);
                            len = len - off + n;
                            off = 0;
                        }
                        if (!skip) {
                            format = ByteUtil.getInt2(b, off+2);
                            page1 = ByteUtil.getBCD4(b, off+14);
                            off1 = ByteUtil.getBCD2(b, off+18);
                            if (format >>> 8 == 0x00) {
                                _hook.beginColorDIB(BookInputStream.getPosition(page1, off1));
                            } else {
                                _hook.beginColorJPEG(BookInputStream.getPosition(page1, off1));
                            }
                        }
                        off += 20;
                        break;
                    case 0x49:
                    case 0x4c:
                    case 0x4e:
                    case 0x4f:
                        off += 2;
                        _skipCode = (b[off-1] & 0xff) + 0x20;
                        break;
                    case 0x52:
                        // ΥȤνλ (for EB)
                        if (off + 8 > len) {
                            int n = _readRaw(b, off, len-off);
                            len = len - off + n;
                            off = 0;
                        }
                        if (!skip) {
                            page1 = ByteUtil.getBCD4(b, off+2);
                            off1 = ByteUtil.getBCD2(b, off+6);
                            _hook.endMonoGraphic(BookInputStream.getPosition(page1, off1));
                        }
                        off += 8;
                        break;
                    case 0x53:
                        // νλ (for EB)
                        if (off + 10 > len) {
                            int n = _readRaw(b, off, len-off);
                            len = len - off + n;
                            off = 0;
                        }
                        off += 10;
                        break;
                    case 0x59:
                        // MPEGưνλ
                        off += 2;
                        if (!skip) {
                            _hook.endMPEG();
                        }
                        break;
                    case 0x5c:
                        // 饤󥫥顼νλ
                        off += 2;
                        if (!skip) {
                            _hook.endInlineColorGraphic();
                        }
                        break;
                    case 0x61:
                        // ɤνλ
                        off += 2;
                        if (!skip) {
                            _hook.endKeyword();
                        }
                        break;
                    case 0x62:
                        // Ȥνλ
                        if (off + 8 > len) {
                            int n = _readRaw(b, off, len-off);
                            len = len - off + n;
                            off = 0;
                        }
                        if (!skip) {
                            page1 = ByteUtil.getBCD4(b, off+2);
                            off1 = ByteUtil.getBCD2(b, off+6);
                            _hook.endReference(BookInputStream.getPosition(page1, off1));
                        }
                        off += 8;
                        break;
                    case 0x63:
                        // ܤνλ
                        if (off + 8 > len) {
                            int n = _readRaw(b, off, len-off);
                            len = len - off + n;
                            off = 0;
                        }
                        if (!skip) {
                            page1 = ByteUtil.getBCD4(b, off+2);
                            off1 = ByteUtil.getBCD2(b, off+6);
                            if (page1 == 0 && off1 == 0) {
                                _hook.endCandidateLeaf();
                            } else {
                                _hook.endCandidateGroup(BookInputStream.getPosition(page1, off1));
                            }
                        }
                        off += 8;
                        break;
                    case 0x64:
                        // Υνλ (for EPWING)
                        if (off + 8 > len) {
                            int n = _readRaw(b, off, len-off);
                            len = len - off + n;
                            off = 0;
                        }
                        if (!skip) {
                            page1 = ByteUtil.getBCD4(b, off+2);
                            off1 = ByteUtil.getBCD2(b, off+6);
                            _hook.endMonoGraphic(BookInputStream.getPosition(page1, off1));
                        }
                        off += 8;
                        break;
                    case 0x6a:
                        // WAVEνλ
                        off += 2;
                        if (!skip) {
                            _hook.endWaveSound();
                        }
                        break;
                    case 0x6b:
                        // ڡȤνλ
                        off += 2;
                        break;
                    case 0x6d:
                        // 顼(DIB/JPEG)νλ
                        off += 2;
                        if (!skip) {
                            _hook.endColorGraphic();
                        }
                        break;
                    case 0x70:
                    case 0x71:
                    case 0x72:
                    case 0x73:
                    case 0x74:
                    case 0x75:
                    case 0x76:
                    case 0x77:
                    case 0x78:
                    case 0x79:
                    case 0x7a:
                    case 0x7b:
                    case 0x7c:
                    case 0x7d:
                    case 0x7e:
                    case 0x7f:
                    case 0x80:
                    case 0x81:
                    case 0x82:
                    case 0x83:
                    case 0x84:
                    case 0x85:
                    case 0x86:
                    case 0x87:
                    case 0x88:
                    case 0x89:
                    case 0x8a:
                    case 0x8b:
                    case 0x8c:
                    case 0x8d:
                    case 0x8e:
                    case 0x8f:
                        off += 2;
                        _skipCode = (b[off-1] & 0xff) + 0x20;
                        break;
                    case 0xe0:
                        // ʸγ
                        if (off + 4 > len) {
                            int n = _readRaw(b, off, len-off);
                            len = len - off + n;
                            off = 0;
                        }
                        off += 4;
                        break;
                    case 0xe1:
                        // ʸνλ
                        off += 2;
                        break;
                    case 0xe4:
                    case 0xe6:
                    case 0xe8:
                    case 0xea:
                    case 0xec:
                    case 0xee:
                    case 0xf0:
                    case 0xf2:
                    case 0xf4:
                    case 0xf6:
                    case 0xf8:
                    case 0xfa:
                    case 0xfc:
                    case 0xfe:
                        off += 2;
                        _skipCode = (b[off-1] & 0xff) + 0x01;
                        break;
                    default:
                        off += 2;
                        if ((b[off-1] & 0xff) == _skipCode) {
                            _skipCode = -1;
                        }
                }
            } else if (_sub.getBook().getCharCode() == Book.CHARCODE_ISO8859_1) {
                printable = true;
                if (_skipCode == -1) {
                    int ch = b[off] & 0xff;
                    if ((ch >= 0x20 && ch <= 0x7f) || (ch >= 0xa0 && ch <= 0xff)) {
                        // ISO 8859-1
                        if (!skip) {
                            _hook.append((char)ch);
                        }
                        off++;
                    } else {
                        // 
                        int code = ByteUtil.getInt2(b, off);
                        if (!skip) {
                            _hook.append(code);
                        }
                        off += 2;
                    }
                }
            } else {
                printable = true;
                if (_skipCode == -1) {
                    int high = b[off] & 0xff;
                    int low = b[off+1] & 0xff;
                    if (high > 0x20 && high < 0x7f && low > 0x20 && low < 0x7f) {
                        // JIS X 0208
                        if (!skip) {
                            _hook.append(ByteUtil.jisx0208ToString(b, off, 2));
                        }
                    } else if (high > 0x20 && high > 0x7f
                               && low > 0xa0 && low < 0xff) {
                        // GB 2312
                        if (!skip) {
                            _hook.append(ByteUtil.gb2312ToString(b, off, 2));
                        }
                    } else if (high > 0xa0 && high < 0xff
                               && low > 0x20 && low < 0x7f) {
                        // 
                        int code = ByteUtil.getInt2(b, off);
                        if (!skip) {
                            _hook.append(code);
                        }
                    }
                }
                off += 2;
            }
            if (!skip) {
                if (!_hook.isMoreInput()) {
                    break;
                }
            }
        }
        if (skip) {
            return new Long(pos + off);
        }
        return _hook.getObject();
    }

    /**
     * Х˥ǡɤ߹ߤޤ<BR>
     * off֤lenХȤΥǡƬ˰ư
     * ĤΥХ˥ǡɤ߹ߤޤ
     *
     * @param b Х
     * @param off եåȰ
     * @param len Хȿ
     * @return ɤ߹Хȿ
     * @exception EBException ϥ顼ȯ
     */
    private int _readRaw(byte[] b, int off, int len) throws EBException {
        System.arraycopy(b, off, b, 0, len);
        int n = _bis.read(b, len, b.length-len);
        if (n == 0) {
            throw new EBException(EBException.UNEXP_FILE, _file.getPath());
        }
        return n;
    }

    /**
     * ץ󥹤ȥåץɤɤȽǤޤ
     *
     * @param code0 0
     * @param code1 1
     * @return ȥåץɤξtrueǤʤfalse
     */
    private boolean _isStopCode(int code0, int code1) {
        if (_sub.getAppendix() != null && _sub.getAppendix().hasStopCode()) {
            return _sub.getAppendix().isStopCode(code0, code1);
        } else {
            if (code0 == 0x1f41 && code1 == _autoStopCode) {
                return true;
            }
        }
        return false;
    }
}

// end of BookReader.java
