package fuku.eb4j.io;

import java.io.*;
import java.util.zip.*;

import fuku.eb4j.EBException;
import fuku.eb4j.util.ByteUtil;

/**
 * EBZIPνϥȥ꡼९饹
 *
 * @author Hisaya FUKUMOTO
 * @version 0.3.3
 */
public final class EBZipInputStream
    extends BookInputStream implements EBZipConstants {

    /**
     * 󥹥ȥ饯
     *
     * @param info ե
     * @exception EBException ϥ顼ȯ
     */
    EBZipInputStream(FileInfo info) throws EBException {
        super(info);
        synchronized (info) {
            if (info.realFileSize <= 0) {
                try {
                    open();
                    _init();
                } finally {
                    close();
                }
            }
        }
    }


    /**
     * EBZIPΥեޤ
     *
     * @exception EBException ϥ顼ȯ
     */
    private void _init() throws EBException {
        try {
            _info.realFileSize = _stream.length();
        } catch (IOException e) {
            throw new EBException(EBException.FAILED_READ_FILE,
                                  _info.file.getPath(), e);
        }

        // إåɤ߹
        byte[] b = new byte[EBZIP_HEADER_SIZE];
        readRawFully(b, 0, b.length);

        _info.zipLevel = b[5] & 0x0f;
        _info.sliceSize = PAGE_SIZE << _info.zipLevel;
        _info.fileSize = ByteUtil.getLong4(b, 10);
        _info.zipCrc = ByteUtil.getLong4(b, 14);

        if (_info.fileSize < (1<<16)) {
            _info.zipIndexSize = 2;
        } else if (_info.fileSize < (1<<24)) {
            _info.zipIndexSize = 3;
        } else {
            _info.zipIndexSize = 4;
        }

        // θ
        String str = new String(b, 0, 5);
        if (!str.equals("EBZip")
            || (b[5] >>> 4) != EBFile.FORMAT_EBZIP
            || _info.sliceSize > (PAGE_SIZE << EBZIP_MAX_LEVEL)) {
            throw new EBException(EBException.UNEXP_FILE, _info.file.getPath());
        }
    }

    /**
     * Υեΰ̥٥֤ޤ
     *
     * @return ̥٥
     */
    public int getLevel() {
        return _info.zipLevel;
    }

    /**
     * ΥեCRC֤ޤ
     *
     * @return CRC
     */
    public long getCRC() {
        return _info.zipCrc;
    }

    /**
     * EBZIPΥե뤫lenХȤΥǡХɤ߹ߤޤ
     *
     * @param b ǡɤ߹ΥХåե
     * @param off ǡγϥեå
     * @param len ɤ߹ޤХȿ
     * @return Хåեɤ߹ޤ줿ХȤι׿
     *         (ȥ꡼νãƥǡʤ-1)
     * @exception EBException ϥ顼ȯ
     */
    public int read(byte[] b, int off, int len) throws EBException {
        int rlen = 0;
        while (rlen < len) {
            if (_info.fileSize <= _filePos) {
                // ȥ꡼ν
                if (rlen == 0) {
                    // ǡɤ߹Ǥʤ-1
                    return -1;
                } else {
                    // ǡɤ߹ǤХХȿ֤
                    return rlen;
                }
            }
            // åκ
            if (_cachePos < 0
                || _filePos < _cachePos
                || _cachePos + PAGE_SIZE <= _filePos) {
                // åΥǡ
                // _filePosΰ֤ޤޤڡƬ
                _cachePos = _filePos - (_filePos % PAGE_SIZE);

                // ǥåǡΰ
                // (եå * ǥå) + إå
                long pos = _filePos / _info.sliceSize * _info.zipIndexSize
                    + EBZIP_HEADER_SIZE;
                try {
                    _stream.seek(pos);
                } catch (IOException e) {
                    throw new EBException(EBException.FAILED_SEEK_FILE,
                                          _info.file.getPath(), e);
                }
                byte[] buf = new byte[_info.zipIndexSize*2];
                readRawFully(buf, 0, buf.length);

                // 饤֤μ
                long slicePos = 0L;
                long nextSlicePos = 0L;
                switch (_info.zipIndexSize) {
                    case 2:
                        slicePos = ByteUtil.getInt2(buf, 0);
                        nextSlicePos = ByteUtil.getInt2(buf, 2);
                        break;
                    case 3:
                        slicePos = ByteUtil.getInt3(buf, 0);
                        nextSlicePos = ByteUtil.getInt3(buf, 3);
                        break;
                    case 4:
                        slicePos = ByteUtil.getLong4(buf, 0);
                        nextSlicePos = ByteUtil.getLong4(buf, 4);
                        break;
                    default:
                        break;
                }

                // ̤줿饤Υ
                int sliceSize = (int)(nextSlicePos - slicePos);
                // ڡΥեå
                int offset = (int)((_filePos % _info.sliceSize) / PAGE_SIZE);
                if (sliceSize <= 0 || _info.sliceSize < sliceSize) {
                    return -1;
                }

                // ̥饤ǥɤƥåɤ߹
                try {
                    _stream.seek(slicePos);
                } catch (IOException e) {
                    throw new EBException(EBException.FAILED_SEEK_FILE,
                                          _info.file.getPath(), e);
                }
                _decode(offset, sliceSize);
            }

            // å夫ǡμ
            int n = (int)(PAGE_SIZE - (_filePos % PAGE_SIZE));
            if (len - rlen < n) {
                n = len - rlen;
            }
            if (_info.fileSize - _filePos < n) {
                n = (int)(_info.fileSize - _filePos);
            }
            int p = (int)(_filePos % PAGE_SIZE);
            System.arraycopy(_cache, p, b, off+rlen, n);
            rlen += n;
            _filePos += n;
        }
        return rlen;
    }

    /**
     * 沽ޤ
     *
     * @param offset ڡ⥪եå
     * @param size ̥饤
     * @exception EBException ϥ顼ȯ
     */
    private void _decode(int offset, int size) throws EBException {
        if (size == _info.sliceSize) {
            // ̤ƤʤΤǤΤޤɤ߹
            // ŪΥڡޤǥå
            for (int i=0; i<offset; i++) {
                try {
                    if (_stream.skipBytes(PAGE_SIZE) != PAGE_SIZE) {
                        throw new EBException(EBException.FAILED_SEEK_FILE,
                                              _info.file.getPath());
                    }
                } catch (IOException e) {
                    throw new EBException(EBException.FAILED_SEEK_FILE,
                                          _info.file.getPath(), e);
                }
            }
            // åɤ߹
            readRawFully(_cache, 0, PAGE_SIZE);
        } else {
            byte[] b = new byte[PAGE_SIZE];
            Inflater inf = new Inflater();
            inf.setInput(b, 0, 0);
            try {
                // षǡŪΥڡΥڡˤʤޤ
                while (inf.getTotalOut() < (offset + 1) * PAGE_SIZE) {
                    int tout = inf.getTotalOut();
                    int off = 0;
                    int len = 0;
                    if (tout >= offset * PAGE_SIZE) {
                        // ŪΥڡʤΤ³ƻĤΥǡɤ߹
                        off = tout - offset * PAGE_SIZE;
                        len = PAGE_SIZE - off;
                    } else {
                        if (tout < (offset - 1) * PAGE_SIZE) {
                            // ŪΥڡǤʤΤŬɤ߹
                            len = PAGE_SIZE;
                        } else {
                            // ŪΥڡ1ʤΤǥڡνޤɤ߹
                            len = offset * PAGE_SIZE - tout;
                        }
                    }
                    inf.inflate(_cache, off, len);

                    if (inf.finished() || inf.needsDictionary()) {
                        // ̥ǡʾʤ
                        if (inf.getTotalOut() != (offset + 1) * PAGE_SIZE) {
                            throw new EBException(EBException.UNEXP_FILE,
                                                  _info.file.getPath());
                        }
                        return;
                    }

                    if (inf.needsInput()) {
                        // ̥饤ۤʤ褦˰̥ǡ
                        int in = inf.getTotalIn();
                        if (size - in < PAGE_SIZE) {
                            len = size - in;
                        } else {
                            len = PAGE_SIZE;
                        }
                        readRawFully(b, 0, len);
                        inf.setInput(b, 0, len);
                    }
                }
            } catch (DataFormatException e) {
                throw new EBException(EBException.UNEXP_FILE,
                                      _info.file.getPath(), e);
            } finally {
                inf.end();
            }
        }
    }
}

// end of EBZipInputStream.java
