package fuku.eb4j.tool;

import java.io.*;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;

import fuku.eb4j.Book;
import fuku.eb4j.SubBook;
import fuku.eb4j.ExtFont;
import fuku.eb4j.Version;
import fuku.eb4j.EBException;

/**
 * Ҿɽץࡣ
 *
 * @author Hisaya FUKUMOTO
 * @version 0.3.3
 */
public final class EBInfo {

    /** ץ֥̾ */
    private static final String _PROGRAM = "fuku.eb4j.tool.EBInfo";

    /** ǥեɤ߹ߥǥ쥯ȥ */
    private static final String DEFAULT_BOOK_DIR = ".";

    /** ޥɥ饤󥪥ץ */
    private static final LongOpt[] LONGOPT = {
        new LongOpt("multi-search", LongOpt.NO_ARGUMENT, null, 'm'),
        new LongOpt("help", LongOpt.NO_ARGUMENT, null, 'h'),
        new LongOpt("version", LongOpt.NO_ARGUMENT, null, 'v'),
    };

    /**  */
    private Book _book = null;


    /**
     * ᥤ᥽åɡ
     *
     * @param args ޥɹ԰
     */
    public static void main(String[] args) {
        Getopt g = new Getopt(_PROGRAM, args, "mhv", LONGOPT);
        int c;
        boolean multi = false;
        while ((c=g.getopt()) != -1) {
            switch (c) {
                case 'm':
                    multi = true;
                    break;
                case 'h':
                    _usage(0);
                    break;
                case 'v':
                    _version();
                    break;
                default:
                    _usage(1);
            }
        }

        String path = null;
        int idx = g.getOptind();
        if (idx+1 == args.length) {
            path = args[idx];
        } else if (idx+1 > args.length) {
            path = DEFAULT_BOOK_DIR;
        } else {
            System.err.println(_PROGRAM + ": too many arguments");
            _usage(1);
        }

        try {
            EBInfo ebinfo = new EBInfo(path);
            ebinfo._show(multi);
        } catch (EBException e) {
            System.err.println(_PROGRAM + ": " + e.getMessage());
        }
    }


    /**
     * ˡɽޤ
     *
     * @param status λơ
     */
    private static void _usage(int status) {
        if (status != 0) {
            System.out.println("Try `java " + _PROGRAM + " --help' for more information");
        } else {
            System.out.println("Usage: java " + _PROGRAM + " [option...] [book-directory]");
            System.out.println("");
            System.out.println("Options:");
            System.out.println("  -m, --multi-search         also output multi-search information");
            System.out.println("  -h, --help                 display this help and exit");
            System.out.println("  -v, --version              output version information and exit");
            System.out.println("");
            System.out.println("Argument:");
            System.out.println("  book-directory             top directory of a book");
            System.out.println("                             (default: " + DEFAULT_BOOK_DIR + ")");
            System.out.println("");
            System.out.println("Report bugs to <" + Version.EMAIL + ">.");
        }
        System.exit(status);
    }

    /**
     * Сɽޤ
     *
     */
    private static void _version() {
        System.out.println(_PROGRAM + " " + Version.VERSION);
        System.out.println(Version.COPYRIGHT);
        System.out.println("All right reserved.");
        System.exit(0);
    }


    /**
     * 󥹥ȥ饯
     *
     * @param path ҤΥѥ
     * @exception EBException Ҥν㳰ȯ
     */
    public EBInfo(String path) throws EBException {
        super();
        _book = new Book(path);
    }


    /**
     * ҤξϤޤ
     *
     * @param multi ʣ縡ξܺپϤ뤳Ȥ򼨤ե饰
     */
    private void _show(boolean multi) {
        String text = null;
        // Ҥμ
        System.out.print("disc type: ");
        if (_book.getBookType() == Book.DISC_EB) {
            text = "EB/EBG/EBXA/EBXA-C/S-EBXA";
        } else if (_book.getBookType() == Book.DISC_EPWING) {
            text = "EPWING V" + _book.getVersion();
        } else {
            text = "unknown";
        }
        System.out.println(text);

        // Ҥʸå
        System.out.print("character code: ");
        switch (_book.getCharCode()) {
            case Book.CHARCODE_ISO8859_1:
                text = "ISO 8859-1";
                break;
            case Book.CHARCODE_JISX0208:
                text = "JIS X 0208";
                break;
            case Book.CHARCODE_JISX0208_GB2312:
                text = "JIS X 0208 + GB 2312";
                break;
            default:
                text = "unknown";
        }
        System.out.println(text);

        // Ҥ˴ޤޤܿ
        System.out.print("the number of subbooks: ");
        System.out.println(_book.getSubBookCount());
        System.out.println("");

        // ܤξ
        SubBook[] subs = _book.getSubBooks();
        for (int i=0; i<subs.length; i++) {
            System.out.println("subbook " + (i+1) + ":");

            // ܤΥȥ
            System.out.println("  title: " + subs[i].getTitle());

            // ܤΥǥ쥯ȥ
            System.out.println("  directory: " + subs[i].getName());

            // бƤ븡
            System.out.print("  search methods:");
            if (subs[i].hasWordSearch()) {
                System.out.print(" word");
            }
            if (subs[i].hasEndwordSearch()) {
                System.out.print(" endword");
            }
            if (subs[i].hasExactwordSearch()) {
                System.out.print(" exactword");
            }
            if (subs[i].hasKeywordSearch()) {
                System.out.print(" keyword");
            }
            if (subs[i].hasMultiSearch()) {
                System.out.print(" multi");
            }
            if (subs[i].hasMenu()) {
                System.out.print(" menu");
            }
            if (subs[i].hasCopyright()) {
                System.out.print(" copyright");
            }
            System.out.println("");

            // Υ
            System.out.print("  font sizes:");
            for (int j=0; j<4; j++) {
                ExtFont font = subs[i].getFont(j);
                if (font.hasFont()) {
                    System.out.print(" " + font.getFontHeight());
                }
            }
            System.out.println("");

            // Ⱦѳʸϰ
            ExtFont font = subs[i].getFont();
            System.out.print("  narrow font characters:");
            if (font.hasNarrowFont()) {
                System.out.print(" 0x");
                int code = font.getNarrowFontStart();
                String hex = Integer.toHexString(code).toUpperCase();
                int len = 4 - hex.length();
                if (len > 0) {
                    for (int j=0; j<len; j++) {
                        System.out.print("0");
                    }
                }
                System.out.print(hex + " -- ");
                System.out.print(" 0x");
                code = font.getNarrowFontEnd();
                hex = Integer.toHexString(code).toUpperCase();
                len = 4 - hex.length();
                if (len > 0) {
                    for (int j=0; j<len; j++) {
                        System.out.print("0");
                    }
                }
                System.out.print(hex);
            }
            System.out.println("");

            // ѳʸϰ
            System.out.print("  wide font characters:");
            if (font.hasWideFont()) {
                System.out.print(" 0x");
                int code = font.getWideFontStart();
                String hex = Integer.toHexString(code).toUpperCase();
                int len = 4 - hex.length();
                if (len > 0) {
                    for (int j=0; j<len; j++) {
                        System.out.print("0");
                    }
                }
                System.out.print(hex + " -- ");
                System.out.print(" 0x");
                code = font.getWideFontEnd();
                hex = Integer.toHexString(code).toUpperCase();
                len = 4 - hex.length();
                if (len > 0) {
                    for (int j=0; j<len; j++) {
                        System.out.print("0");
                    }
                }
                System.out.print(hex);
            }
            System.out.println("");

            if (multi) {
                _showMulti(subs[i]);
            }
        }
    }

    /**
     * ʣ縡ˤĤƤξϤޤ
     *
     * @param sub 
     */
    private void _showMulti(SubBook sub) {
        if (!sub.hasMultiSearch()) {
            return;
        }
        System.out.println("");
        int count = sub.getMultiCount();
        for (int i=0; i<count; i++) {
            System.out.println("  multi search " + Integer.toString(i+1) + ":");
            int entry = sub.getMultiEntryCount(i);
            for (int j=0; j<entry; j++) {
                System.out.println("    label " + Integer.toString(j+1) + ": "
                                   + sub.getMultiEntryLabel(i, j));
                String text = null;
                if (sub.hasMultiEntryCandidate(i, j)) {
                    text = "exist";
                } else {
                    text = "not-exist";
                }
                System.out.println("     candidates: " + text);
            }
        }
    }
}

// end of EBInfo.java
