package fuku.eb4j.util;

import java.io.*;
import java.util.*;

/**
 * ӥ桼ƥƥ饹
 *
 * @author Hisaya FUKUMOTO
 * @version 0.3.3
 */
public final class CompareUtil {

    /**
     * ǥեȥ󥹥ȥ饯
     *
     */
    private CompareUtil() {
        super();
    }


    /**
     * ȥѥХͤӤޤ
     *
     * @param key 
     * @param pattern ѥ
     * @param exact פӤ뤫פӤ뤫
     *              (פξ硢ѥ˰פƱȤߤʤ)
     * @return ѥƱ0
     *         ѥ礭1ʾ塢
     *         ѥ꾮-1ʲ
     */
    public static int compareToCanonical(byte[] key, byte[] pattern, boolean exact) {
        int ret = 0;
        int len = key.length;
        int kByte, pByte;
        for (int i=0; i<len; i++) {
            if (i >= pattern.length) {
                return key[i] & 0xff;
            }
            if (key[i] == '\0') {
                if (exact) {
                    ret = - (pattern[i] & 0xff);
                } else {
                    ret = 0;
                }
                return ret;
            }

            kByte = key[i] & 0xff;
            pByte = pattern[i] & 0xff;
            if (kByte != pByte) {
                return ret = kByte - pByte;
            }
        }
        if (len < pattern.length && exact) {
            ret = - (pattern[len] & 0xff);
        }
        return ret;
    }

    /**
     * ȥѥISO 8859-1ʸåȤ
     * ʸ/ʸζ̤ʤӤޤ
     *
     * @param key  (ISO 8859-1)
     * @param pattern ѥ (ISO 8859-1)
     * @param exact פӤ뤫פӤ뤫
     *              (פξ硢ѥ˰פƱȤߤʤ)
     * @return ѥƱ0
     *         ѥ礭1ʾ塢
     *         ѥ꾮-1ʲ
     */
    public static int compareToLatin(byte[] key, byte[] pattern, boolean exact) {
        int ret = 0;
        int len = key.length;
        int kByte, pByte;
        for (int i=0; i<len; i++) {
            if (i >= pattern.length) {
                return key[i] & 0xff;
            }
            if (key[i] == '\0') {
                if (exact) {
                    ret = - (pattern[i] & 0xff);
                } else {
                    ret = 0;
                }
                return ret;
            }

            kByte = key[i] & 0xff;
            pByte = pattern[i] & 0xff;
            if (kByte != pByte) {
                return kByte - pByte;
            }
        }
        if (len < pattern.length && exact) {
            ret = - (pattern[len] & 0xff);
        }
        return ret;
    }

    /**
     * ȥѥJIS X 0208ʸåȤ
     * ʸ/ʸʿ̾/Ҳ̾ζ̤ʤӤޤ
     *
     * @param key  (JIS X 0208)
     * @param pattern ѥ (JIS X 0208)
     * @param exact פӤ뤫פӤ뤫
     *              (פξ硢ѥ˰פƱȤߤʤ)
     * @return ѥƱ0
     *         ѥ礭1ʾ塢
     *         ѥ꾮-1ʲ
     */
    public static int compareTo(byte[] key, byte[] pattern, boolean exact) {
        int ret = 0;
        int len = key.length;
        int kByte, pByte;
        for (int i=0; i<len; i+=2) {
            if (i >= pattern.length) {
                return key[i] & 0xff;
            }
            if (key[i] == '\0') {
                if (exact) {
                    ret = - (pattern[i] & 0xff);
                } else {
                    ret = 0;
                }
                return ret;
            }
            if (i+1 >= pattern.length || i+1 >= len) {
                return (key[i] & 0xff) - (pattern[i] & 0xff);
            }

            kByte = key[i] & 0xff;
            pByte = pattern[i] & 0xff;
            if (kByte != pByte) {
                return kByte - pByte;
            }
            kByte = key[i+1] & 0xff;
            pByte = pattern[i+1] & 0xff;
            if (kByte != pByte) {
                return kByte - pByte;
            }
        }
        if (len < pattern.length && exact) {
            ret = - (pattern[len] & 0xff);
        }
        return ret;
     }
}

// end of CompareUtil.java
