package fuku.webbook;

import fuku.eb4j.SubBook;
import fuku.eb4j.EBException;
import fuku.eb4j.hook.HookAdapter;
import fuku.eb4j.util.ByteUtil;

/**
 * ꥹȥåѥץ󥹲ù饹
 *
 * @author Hisaya FUKUMOTO
 * @version 0.3.3
 */
public final class ListupHook extends HookAdapter {

    /** ȾɽϤƤ뤫ɤ򼨤ե饰 */
    private boolean _narrow = false;
    /** ʸɲä̵뤹ե饰 */
    private boolean _ignore = true;

    /** HTMLǡ */
    private StringBuffer _html = new StringBuffer(512);
    /** ʸХåե */
    private StringBuffer _buf = new StringBuffer(32);

    /**  */
    private SubBook _sub = null;


    /**
     * 󥹥ȥ饯
     *
     * @param sub 
     */
    public ListupHook(SubBook sub) {
        super();
        _sub = sub;
    }


    /**
     * ٤ƤϤ򥯥ꥢޤ
     *
     */
    public void clear() {
        _html.delete(0, _html.length());
        _buf.delete(0, _buf.length());
        _narrow = false;
        _ignore = true;
    }

    /**
     * եåˤäƲù줿֥Ȥ֤ޤ
     *
     * @return ʸ󥪥֥
     */
    public Object getObject() {
        return _html.toString();
    }

    /**
     * Ϥǽɤ֤ޤ
     *
     * @return ޤϤĤtrueǤʤfalse
     */
    public boolean isMoreInput() {
        return true;
    }

    /**
     * ʸɲäޤ
     *
     * @param str ʸ
     */
    public void append(String str) {
        if (_ignore) {
            return;
        }
        if (_narrow) {
            str = ByteUtil.wideToNarrow(str);
        }
        StringBuffer tmp = new StringBuffer(str);
        int idx = tmp.indexOf("&");
        while (idx >= 0) {
            tmp.replace(idx, idx+1, "&amp;");
            idx = tmp.indexOf("&", idx+5);
        }
        idx = tmp.indexOf("<");
        while (idx >= 0) {
            tmp.replace(idx, idx+1, "&lt;");
            idx = tmp.indexOf("<", idx+4);
        }
        idx = tmp.indexOf(">");
        while (idx >= 0) {
            tmp.replace(idx, idx+1, "&gt;");
            idx = tmp.indexOf(">", idx+4);
        }
        _buf.append(tmp);
    }

    /**
     * ɲäޤ<BR>
     * "[N-####]", "[W-####]"Ѵɲäޤ
     *
     * @param code ʸ
     */
    public void append(int code) {
        String str = null;
        if (_narrow) {
            str = "[N-" + Integer.toHexString(code).toUpperCase() + "]";
        } else {
            str = "[W-" + Integer.toHexString(code).toUpperCase() + "]";
        }
        _buf.append(str);
    }

    /**
     * ȾɽγϤɽץ󥹤ФեåǤ
     *
     */
    public void beginNarrow() {
        _narrow = true;
    }

    /**
     * Ⱦɽνλɽץ󥹤ФեåǤ
     *
     */
    public void endNarrow() {
        _narrow = false;
    }

    /**
     * ʣ縡θȤʤγϤɽץ󥹤ФեåǤ
     *
     */
    public void beginCandidate() {
        _ignore = false;
    }

    /**
     * ʣ縡θȤʤνλɽץ󥹤ФեåǤ<BR>
     * ȤʤϤ˺٤ʬƤ뤳Ȥ򼨤ޤ
     *
     * @param pos γؤθǡΰ
     */
    public void endCandidateGroup(long pos) {
        String str = null;
        try {
            str = (String)_sub.getText(pos, new ListupHook(_sub));
        } catch (EBException e) {
            System.err.println("WebBook: " + e.getMessage());
        }
        if (str != null) {
            _html.append("<OPTGROUP label=\"").append(_buf).append("\">");
            _html.append(str).append("</OPTGROUP>");
        }
        _buf.delete(0, _buf.length());
        _ignore = true;
    }

    /**
     * ʣ縡θȤʤνλɽץ󥹤ФեåǤ<BR>
     * Ȥʤ줬ºݤ˸ϸȤƻȤΤǤ뤳Ȥ򼨤ޤ
     *
     */
    public void endCandidateLeaf() {
        _html.append("<OPTION value=\"").append(_buf).append("\">");
        _html.append(_buf).append("</OPTION>");
        _buf.delete(0, _buf.length());
        _ignore = true;
    }
}

// end of ListupHook.java
