package fuku.webbook;

import java.awt.Color;
import java.io.*;
import java.util.*;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * WebBookեɤ߹ߥ饹
 *
 * @author Hisaya FUKUMOTO
 * @version 0.3.3
 */
public final class WebBookConfig {

    /** ʿΥǥå */
    private static final int FOREGROUND = 0;
    /** طʿΥǥå */
    private static final int BACKGROUND = 1;
    /** ΥɽΥǥå */
    private static final int KEYWORD = 2;
    /** λɽΥǥå */
    private static final int ANCHOR = 3;

    /** Υǥեɽ */
    private static final Color[] DEF_COLOR = {
        Color.BLACK, Color.WHITE, Color.GREEN, Color.BLUE
    };

    /** ɽꥹ */
    private Color[] _colorList = null;

    /** ҥꥹ */
    private String[] _bookList = null;
    /** Ͽꥹ */
    private String[] _appendixList = null;

    /** å */
    private static final int CACHE_GAIJI = 0;
    /** å */
    private static final int CACHE_IMAGE = 1;
    /** å */
    private static final int CACHE_SOUND = 2;
    /** åǥ쥯ȥ */
    private static final int CACHE_DIR = 3;
    /** å̵ͭ */
    private boolean[] _cache = new boolean[3];
    /** åǥ쥯ȥ */
    private File _cacheDir = null;


    /**
     * 󥹥ȥ饯
     *
     */
    WebBookConfig() {
        super();
    }


    /**
     * ϥȥ꡼फɤ߹ߤޤ
     *
     * @param stream ϥȥ꡼
     */
    public synchronized void load(InputStream stream) {
        List list = new ArrayList(10);
        try {
            DocumentBuilderFactory factory =
                DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document root = builder.parse(stream);
            Node webbook = root.getFirstChild();
            NodeList nodes = webbook.getChildNodes();
            int len = nodes.getLength();
            for (int i=0; i<len; i++) {
                Node node = nodes.item(i);
                if (node.getNodeType() != Node.ELEMENT_NODE) {
                    continue;
                }
                if (node.getNodeName().equals("book")) {
                    // ɤ߹
                    NodeList book = node.getChildNodes();
                    int num = book.getLength();
                    String[] val = new String[2];
                    for (int j=0; j<num; j++) {
                        Node n = book.item(j);
                        if (n.getNodeType() != Node.ELEMENT_NODE) {
                            continue;
                        }
                        String tag = n.getNodeName();
                        if (tag.equals("data")) {
                            val[0] = n.getFirstChild().getNodeValue().trim();
                        } else if (tag.equals("appendix")) {
                            val[1] = n.getFirstChild().getNodeValue().trim();
                        }
                    }
                    if (val[0] != null) {
                        list.add(val);
                    }
                } else if (node.getNodeName().equals("cache")) {
                    // å
                    if (_cacheDir != null) {
                        // Ǥɤ߹ǤΤ̵
                        continue;
                    }
                    NodeList cache = node.getChildNodes();
                    int num = cache.getLength();
                    for (int j=0; j<num; j++) {
                        Node n = cache.item(j);
                        if (n.getNodeType() != Node.ELEMENT_NODE) {
                            continue;
                        }
                        String val = null;
                        int idx = -1;
                        String tag = n.getNodeName();
                        if (tag.equals("gaiji")) {
                            val = n.getFirstChild().getNodeValue().trim();
                            idx = CACHE_GAIJI;
                        } else if (tag.equals("image")) {
                            val = n.getFirstChild().getNodeValue().trim();
                            idx = CACHE_IMAGE;
                        } else if (tag.equals("sound")) {
                            val = n.getFirstChild().getNodeValue().trim();
                            idx = CACHE_SOUND;
                        } else if (tag.equals("dir")) {
                            val = n.getFirstChild().getNodeValue().trim();
                            idx = CACHE_DIR;
                        } else {
                            continue;
                        }
                        if (idx == CACHE_DIR) {
                            if (val.length() > 0) {
                                _cacheDir = new File(val, "webbook");
                            }
                        } else {
                            if (val.equalsIgnoreCase("true")) {
                                _cache[idx] = true;
                            } else if (val.equalsIgnoreCase("yes")) {
                                _cache[idx] = true;
                            } else if (val.equalsIgnoreCase("on")) {
                                _cache[idx] = true;
                            } else {
                                _cache[idx] = false;
                            }
                        }
                    }
                } else if (node.getNodeName().equals("gaiji-color")) {
                    // ɽɤ߹
                    if (_colorList != null) {
                        // Ǥɤ߹ǤΤ̵
                        continue;
                    }
                    _colorList = new Color[DEF_COLOR.length];
                    NodeList color = node.getChildNodes();
                    int num = color.getLength();
                    for (int j=0; j<num; j++) {
                        Node n = color.item(j);
                        if (n.getNodeType() != Node.ELEMENT_NODE) {
                            continue;
                        }
                        String val = null;
                        int idx = -1;
                        String tag = n.getNodeName();
                        if (tag.equals("foreground")) {
                            val = n.getFirstChild().getNodeValue().trim();
                            idx = FOREGROUND;
                        } else if (tag.equals("background")) {
                            val = n.getFirstChild().getNodeValue().trim();
                            idx = BACKGROUND;
                        } else if (tag.equals("keyword")) {
                            val = n.getFirstChild().getNodeValue().trim();
                            idx = KEYWORD;
                        } else if (tag.equals("anchor")) {
                            val = n.getFirstChild().getNodeValue().trim();
                            idx = ANCHOR;
                        } else {
                            continue;
                        }
                        try {
                            if (idx >= 0 && idx < _colorList.length) {
                                int rgb = Integer.parseInt(val, 16);
                                _colorList[idx] = new Color(rgb);
                            }
                        } catch (NumberFormatException e) {
                        }
                    }
                }
            }
        } catch (FactoryConfigurationError e) {
            System.err.println("WebBook: " + e.getMessage());
        } catch (ParserConfigurationException e) {
            System.err.println("WebBook: " + e.getMessage());
        } catch (SAXException e) {
            System.err.println("WebBook: " + e.getMessage());
        } catch (IOException e) {
            System.err.println("WebBook: " + e.getMessage());
        } finally {
            try {
                stream.close();
            } catch (IOException e) {
            }
        }

        if (!list.isEmpty()) {
            // ҥꥹȤν
            int len = list.size();
            _bookList = new String[len];
            _appendixList = new String[len];
            for (int i=0; i<len; i++) {
                String[] item = (String[])list.get(i);
                _bookList[i] = item[0];
                _appendixList[i] = item[1];
            }
        }

        if (_cacheDir == null) {
            _cacheDir =
                new File(System.getProperty("java.io.tmpdir"), "webbook");
        }
    }

    /**
     * ҥꥹȤ֤ޤ
     *
     * @return ҥꥹ (ʤnull)
     */
    public String[] getBookList() {
        return _bookList;
    }

    /**
     * ϿꥹȤ֤ޤ
     *
     * @return ҥꥹ (ʤnull)
     */
    public String[] getAppendixList() {
        return _appendixList;
    }

    /**
     * å̵֤ͭޤ
     *
     * @return å̵ͭ
     */
    public boolean isGaijiCache() {
        return _cache[CACHE_GAIJI];
    }

    /**
     * å̵֤ͭޤ
     *
     * @return å̵ͭ
     */
    public boolean isImageCache() {
        return _cache[CACHE_IMAGE];
    }

    /**
     * å̵֤ͭޤ
     *
     * @return å̵ͭ
     */
    public boolean isSoundCache() {
        return _cache[CACHE_SOUND];
    }

    /**
     * åǥ쥯ȥ֤ޤ
     *
     * @return åǥ쥯ȥ
     */
    public File getCacheDir() {
        return _cacheDir;
    }

    /**
     * ʿ֤ޤ
     *
     * @return ʿ
     */
    public Color getForegroundColor() {
        if (_colorList == null || _colorList[FOREGROUND] == null) {
            return DEF_COLOR[FOREGROUND];
        }
        return _colorList[FOREGROUND];
    }

    /**
     * طʿ֤ޤ
     *
     * @return طʿ
     */
    public Color getBackgroundColor() {
        if (_colorList == null || _colorList[BACKGROUND] == null) {
            return DEF_COLOR[BACKGROUND];
        }
        return _colorList[BACKGROUND];
    }

    /**
     * Υɽ֤ޤ
     *
     * @return Υɽ
     */
    public Color getKeywordColor() {
        if (_colorList == null || _colorList[KEYWORD] == null) {
            return DEF_COLOR[KEYWORD];
        }
        return _colorList[KEYWORD];
    }

    /**
     * Υ󥫡ɽ֤ޤ
     *
     * @return Υ󥫡ɽ
     */
    public Color getAnchorColor() {
        if (_colorList == null || _colorList[ANCHOR] == null) {
            return DEF_COLOR[ANCHOR];
        }
        return _colorList[ANCHOR];
    }
}

// end of WebBookConfig.java
