/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.aws.ui.job;

import java.util.List;
import jp.co.intellilink.aws.api.ElasticComputingCloudInterface;
import jp.co.intellilink.aws.api.transport.EC2AuthorizeRequest;
import jp.co.intellilink.aws.api.transport.EC2DescribeSecurityGroupRequest;
import jp.co.intellilink.aws.core.CoreException;
import jp.co.intellilink.aws.core.EC2ServiceProvider;
import jp.co.intellilink.aws.ui.Activator;
import jp.co.intellilink.aws.ui.view.ActionCallbackHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.swt.widgets.Display;

public class AddIpPermissionJob
extends Job {
    private PreferenceStore store;
    private ActionCallbackHandler handler;

    public AddIpPermissionJob(String name, PreferenceStore store, ActionCallbackHandler handler) {
        super(name);
        this.store = store;
        this.handler = handler;
    }

    protected IStatus run(IProgressMonitor monitor) {
        List securityGroups;
        monitor.beginTask("AddIpPermission", 0);
        monitor.setTaskName("Resolve EC2 Client...");
        EC2ServiceProvider provider = Activator.getDefault().getProvider();
        monitor.worked(10);
        monitor.setTaskName("Add Ip Permission...");
        try {
            ElasticComputingCloudInterface client = provider.getEC2();
            EC2AuthorizeRequest request = new EC2AuthorizeRequest();
            request.setGroupName(this.store.getString("securityGroup"));
            request.setCidrIp(this.store.getString("cidrIp"));
            request.setIpProtocol(this.store.getString("protocol"));
            this.setPortRange(this.store.getString("portRange"), request);
            client.authorizeSecurityGroup(request);
            securityGroups = client.describeSecurityGroups(new EC2DescribeSecurityGroupRequest());
        }
        catch (CoreException e) {
            e.printStackTrace();
            return Status.CANCEL_STATUS;
        }
        if (this.handler != null) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    AddIpPermissionJob.this.handler.onDescribeSecurityGroupsExecuted(securityGroups);
                }
            });
        }
        return Status.OK_STATUS;
    }

    private void setPortRange(String portRange, EC2AuthorizeRequest request) {
        if (portRange.contains("-")) {
            String[] split = portRange.split("-");
            request.setFromPort(Integer.valueOf(Integer.parseInt(split[0].trim())));
            request.setToPort(Integer.valueOf(Integer.parseInt(split[1].trim())));
        } else {
            request.setFromPort(Integer.valueOf(Integer.parseInt(portRange.trim())));
            request.setToPort(Integer.valueOf(Integer.parseInt(portRange.trim())));
        }
    }
}

