/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.aws.ui.job;

import java.util.List;
import jp.co.intellilink.aws.api.ElasticComputingCloudInterface;
import jp.co.intellilink.aws.api.transport.EC2DescribeSnapshotRequest;
import jp.co.intellilink.aws.core.CoreException;
import jp.co.intellilink.aws.core.EC2ServiceProvider;
import jp.co.intellilink.aws.ui.Activator;
import jp.co.intellilink.aws.ui.view.ActionCallbackHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;

public class DescribeSnapshotsJob
extends Job {
    private ActionCallbackHandler handler;
    private List<String> snapshotIds;

    public DescribeSnapshotsJob(String name, ActionCallbackHandler handler, List<String> snapshotIds) {
        super(name);
        this.handler = handler;
        this.snapshotIds = snapshotIds;
    }

    protected IStatus run(IProgressMonitor monitor) {
        List snapshots;
        monitor.beginTask("DescribeSnapshots", 0);
        monitor.setTaskName("Resolve EC2 Client...");
        EC2ServiceProvider provider = Activator.getDefault().getProvider();
        monitor.worked(10);
        monitor.setTaskName("Describe Snapshots...");
        try {
            ElasticComputingCloudInterface client = provider.getEC2();
            EC2DescribeSnapshotRequest request = new EC2DescribeSnapshotRequest();
            request.setSnapshotId(this.snapshotIds);
            snapshots = client.describeSnapshot(request);
            monitor.worked(80);
        }
        catch (CoreException e) {
            e.printStackTrace();
            return Status.CANCEL_STATUS;
        }
        if (this.handler != null && snapshots != null) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    DescribeSnapshotsJob.this.handler.onDescribeSnapshots(snapshots);
                }
            });
        }
        monitor.done();
        return Status.OK_STATUS;
    }
}

