/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.aws.ui.view;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import jp.co.intellilink.aws.api.transport.EC2Address;
import jp.co.intellilink.aws.api.transport.EC2Attachment;
import jp.co.intellilink.aws.api.transport.EC2Image;
import jp.co.intellilink.aws.api.transport.EC2Instance;
import jp.co.intellilink.aws.api.transport.EC2KeyPair;
import jp.co.intellilink.aws.api.transport.EC2Permission;
import jp.co.intellilink.aws.api.transport.EC2SecurityGroup;
import jp.co.intellilink.aws.api.transport.EC2Snapshot;
import jp.co.intellilink.aws.api.transport.EC2Volume;
import jp.co.intellilink.aws.ui.model.ElasticIPModel;
import jp.co.intellilink.aws.ui.model.GroupModel;
import jp.co.intellilink.aws.ui.model.GroupRule;
import jp.co.intellilink.aws.ui.model.IPRangeRule;
import jp.co.intellilink.aws.ui.model.ImageModel;
import jp.co.intellilink.aws.ui.model.InstanceModel;
import jp.co.intellilink.aws.ui.model.KeyPairModel;
import jp.co.intellilink.aws.ui.model.SecurityGroupModel;
import jp.co.intellilink.aws.ui.model.SnapshotModel;
import jp.co.intellilink.aws.ui.model.VolumeModel;
import jp.co.intellilink.aws.ui.view.Messages;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;

public class ActionCallbackHandler {
    private Viewer viewer;

    public ActionCallbackHandler(Viewer viewer) {
        this.viewer = viewer;
    }

    public void onDescribeImagesExecuted(List<EC2Image> items) {
        if (items.isEmpty()) {
            this.viewer.setInput((Object)Messages.getString("ActionCallbackHandler.0"));
        }
        ArrayList<ImageModel> input = new ArrayList<ImageModel>();
        HashMap<String, ImageModel> kernels = new HashMap<String, ImageModel>();
        HashMap<String, ImageModel> ramdisks = new HashMap<String, ImageModel>();
        for (EC2Image type : items) {
            ImageModel model = new ImageModel();
            model.setImageId(type.getImageId());
            model.setImageName(type.getImageLocation());
            model.setImageOwner(type.getImageOwnerId());
            model.setKernelId(type.getKernelId());
            model.setRamdiskId(type.getRamdiskId());
            model.setType(type.getImageType());
            model.setArchitecture(type.getArchitecture());
            model.setPlatform(type.getPlatform());
            if ("kernel".equals(type.getImageType())) {
                kernels.put(model.getImageId(), model);
                continue;
            }
            if ("ramdisk".equals(type.getImageType())) {
                ramdisks.put(model.getImageId(), model);
                continue;
            }
            input.add(model);
        }
        for (ImageModel model : input) {
            model.setKernel((ImageModel)kernels.get(model.getKernelId()));
            model.setRamdisk((ImageModel)ramdisks.get(model.getRamdiskId()));
        }
        this.viewer.setInput(input);
    }

    public void onDescribeAddressExecuted(List<EC2Address> items) {
        ArrayList<ElasticIPModel> input = new ArrayList<ElasticIPModel>();
        for (EC2Address type : items) {
            ElasticIPModel model = new ElasticIPModel();
            model.setIp(type.getAddress());
            model.setInstanceId(type.getInstanceId());
            input.add(model);
        }
        this.viewer.setInput(input);
    }

    public void onDescribeKeyPairsExecuted(List<EC2KeyPair> items) {
        ArrayList<KeyPairModel> input = new ArrayList<KeyPairModel>();
        for (EC2KeyPair type : items) {
            KeyPairModel model = new KeyPairModel();
            model.setKeyName(type.getKeyName());
            model.setKeyFingerprint(type.getKeyFingerprint());
            input.add(model);
        }
        this.viewer.setInput(input);
    }

    public void onDescribeInstancesExecuted(List<EC2Instance> items) {
        ArrayList<InstanceModel> input = new ArrayList<InstanceModel>();
        for (EC2Instance instance : items) {
            InstanceModel i = new InstanceModel();
            i.setInstanceId(instance.getId());
            i.setImageId(instance.getImageId());
            i.setInstanceState(instance.getInstanceState());
            i.setDnsName(instance.getDnsName());
            i.setPrivateDnsName(instance.getPrivateDnsName());
            i.setKey(instance.getKeyName());
            i.setType(instance.getInstanceType());
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss.SSS z");
            i.setLaunchTime(sdf.format(instance.getLaunchTime()));
            i.setReason(instance.getReason());
            List groups = instance.getGroups();
            for (EC2SecurityGroup securityGroup : groups) {
                GroupModel model = new GroupModel();
                model.setGroupName(securityGroup.getName());
                i.addGroup(model);
            }
            input.add(i);
        }
        TreeViewer tree = (TreeViewer)this.viewer;
        Object[] elements = tree.getExpandedElements();
        tree.setInput(input);
        tree.setExpandedElements(elements);
    }

    public void onDescribeSecurityGroupsExecuted(List<EC2SecurityGroup> items) {
        ArrayList<SecurityGroupModel> groupList = new ArrayList<SecurityGroupModel>();
        for (EC2SecurityGroup item : items) {
            SecurityGroupModel group = new SecurityGroupModel();
            group.setName(item.getName());
            group.setOwnerId(item.getOwnerId());
            group.setDescription(item.getDescription());
            List perms = item.getIpPermissions();
            ArrayList<GroupRule> rules = new ArrayList<GroupRule>();
            for (EC2Permission type : perms) {
                GroupRule rule;
                if (!type.getPairs().isEmpty()) {
                    rule = new GroupRule(group);
                    rule.setGroupName(item.getName());
                    rule.setFromPort(Integer.valueOf(type.getFromPort()));
                    rule.setToPort(Integer.valueOf(type.getToPort()));
                    rule.setProtcol(type.getIpProtocol());
                    List pairs = type.getPairs();
                    StringBuilder groups = new StringBuilder();
                    for (EC2Permission.EC2UserGroupPair pair : pairs) {
                        groups.append(pair.getGroup());
                        groups.append(",");
                    }
                    groups.deleteCharAt(groups.lastIndexOf(","));
                    rule.setSourceSecurityGroupName(groups.toString());
                    StringBuilder users = new StringBuilder();
                    for (EC2Permission.EC2UserGroupPair pair : pairs) {
                        users.append(pair.getUser());
                        users.append(",");
                    }
                    users.deleteCharAt(users.lastIndexOf(","));
                    rule.setSourceSecurityGroupOwnerId(users.toString());
                    rules.add(rule);
                    continue;
                }
                rule = new IPRangeRule(group);
                rule.setGroupName(item.getName());
                rule.setFromPort(Integer.valueOf(type.getFromPort()));
                rule.setToPort(Integer.valueOf(type.getToPort()));
                rule.setProtcol(type.getIpProtocol());
                rule.setCidIp(type.getCidrIp());
                rules.add(rule);
            }
            group.setRules(rules);
            groupList.add(group);
        }
        TreeViewer tree = (TreeViewer)this.viewer;
        Object[] elements = tree.getExpandedElements();
        tree.setInput(groupList);
        tree.setExpandedElements(elements);
    }

    public void onDescribeVolumes(List<EC2Volume> items) {
        ArrayList<VolumeModel> input = new ArrayList<VolumeModel>();
        for (EC2Volume vol : items) {
            VolumeModel model = new VolumeModel();
            model.setVolumeId(vol.getVolumeId());
            model.setStatus(vol.getStatus());
            model.setSize(vol.getSize());
            model.setSnapshotId(vol.getSnapshotId());
            model.setCreateTime(vol.getCreateTime());
            model.setAvailabilityZone(vol.getAvailabilityZone());
            if (vol.getAttachment() != null && vol.getAttachment().size() == 1) {
                model.setInstanceId(((EC2Attachment)vol.getAttachment().get(0)).getInstanceId());
                model.setDevice(((EC2Attachment)vol.getAttachment().get(0)).getDevice());
            }
            input.add(model);
        }
        this.viewer.setInput(input);
    }

    public void onDescribeSnapshots(List<EC2Snapshot> items) {
        ArrayList<SnapshotModel> input = new ArrayList<SnapshotModel>();
        for (EC2Snapshot snap : items) {
            SnapshotModel model = new SnapshotModel();
            model.setSnapshotId(snap.getSnapshotId());
            model.setStatus(snap.getStatus());
            model.setProgress(snap.getProgress());
            model.setVolumeId(snap.getVolumeId());
            model.setVolumeSize(snap.getVolumeSize());
            input.add(model);
        }
        this.viewer.setInput(input);
    }
}

