/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.aws.ui.job;

import java.util.ArrayList;
import java.util.List;
import jp.co.intellilink.aws.api.ElasticComputingCloudInterface;
import jp.co.intellilink.aws.api.transport.EC2DeleteSnapshotRequest;
import jp.co.intellilink.aws.api.transport.EC2DescribeVolumesRequest;
import jp.co.intellilink.aws.core.CoreException;
import jp.co.intellilink.aws.core.EC2ServiceProvider;
import jp.co.intellilink.aws.ui.Activator;
import jp.co.intellilink.aws.ui.model.SnapshotModel;
import jp.co.intellilink.aws.ui.view.ActionCallbackHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;

public class DeleteSnapshotJob
extends Job {
    private ActionCallbackHandler handler;
    private List<SnapshotModel> snapshots;

    public DeleteSnapshotJob(String name, ActionCallbackHandler handler, List<SnapshotModel> snapshots) {
        super(name);
        this.handler = handler;
        this.snapshots = snapshots;
    }

    protected IStatus run(IProgressMonitor monitor) {
        monitor.beginTask("Delete Snapshots.", 10);
        monitor.setTaskName("Delete Snapshots");
        monitor.setTaskName("Resolve EC2 Client...");
        EC2ServiceProvider provider = Activator.getDefault().getProvider();
        ElasticComputingCloudInterface client = null;
        monitor.worked(30);
        monitor.setTaskName("Request Generating...");
        final ArrayList volumes = new ArrayList();
        try {
            client = provider.getEC2();
            for (SnapshotModel snap : this.snapshots) {
                EC2DeleteSnapshotRequest request = new EC2DeleteSnapshotRequest();
                request.setSnapshotId(snap.getSnapshotId());
                client.deleteSnapshot(request);
            }
            monitor.worked(80);
            volumes.addAll(client.describeVolumes(new EC2DescribeVolumesRequest()));
        }
        catch (CoreException e) {
            e.printStackTrace();
            return Status.CANCEL_STATUS;
        }
        if (this.handler != null) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    DeleteSnapshotJob.this.handler.onDescribeVolumes(volumes);
                }
            });
        }
        monitor.done();
        return Status.OK_STATUS;
    }
}

