/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.db.names;

import ch.qos.logback.classic.db.names.DBNameResolver;
import ch.qos.logback.classic.db.names.DefaultDBNameResolver;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomDBNameResolver
implements DBNameResolver {
    private final DBNameResolver defaultDbNameResolver = new DefaultDBNameResolver();
    private final Map<String, String> tableNameOverrides = new HashMap<String, String>();
    private final Map<String, String> columnNameOverrides = new HashMap<String, String>();

    @Override
    public <N extends Enum<?>> String getTableName(N tableName) {
        if (this.tableNameOverrides.get(tableName) != null) {
            return this.tableNameOverrides.get(tableName);
        }
        return this.defaultDbNameResolver.getTableName(tableName);
    }

    @Override
    public <N extends Enum<?>> String getColumnName(N columnName) {
        if (this.columnNameOverrides.get(columnName) != null) {
            return this.columnNameOverrides.get(columnName);
        }
        return this.defaultDbNameResolver.getColumnName(columnName);
    }

    public void overrideTableName(String reference, String name) {
        this.tableNameOverrides.put(reference, name);
    }

    public void overrideColumnName(String reference, String name) {
        this.columnNameOverrides.put(reference, name);
    }
}

