/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.internal.base.remote.RemoteHelp;
import org.eclipse.help.internal.base.remote.RemoteSearchManager;
import org.eclipse.help.internal.search.ISearchHitCollector;
import org.eclipse.help.internal.search.ISearchQuery;
import org.eclipse.help.internal.search.LocalSearchManager;
import org.eclipse.help.internal.search.QueryTooComplexException;
import org.eclipse.help.internal.search.federated.FederatedSearchEntry;
import org.eclipse.help.internal.search.federated.FederatedSearchJob;

public class SearchManager {
    private LocalSearchManager localManager = new LocalSearchManager();
    private RemoteSearchManager remoteManager = new RemoteSearchManager();
    private IProgressMonitor localMonitor;
    private IProgressMonitor remoteMonitor;
    private ISearchQuery searchQuery;
    private ISearchHitCollector collector;
    private BufferedSearchHitCollector bufferedCollector = new BufferedSearchHitCollector();
    private Job localSearchJob = new Job("localSearchJob"){

        protected IStatus run(IProgressMonitor monitor) {
            SearchManager.this.localManager.search(SearchManager.this.searchQuery, SearchManager.this.bufferedCollector, SearchManager.this.localMonitor);
            return Status.OK_STATUS;
        }
    };
    private Job remoteSearchJob = new Job("remoteSearchJob"){

        protected IStatus run(IProgressMonitor monitor) {
            SearchManager.this.remoteManager.search(SearchManager.this.searchQuery, SearchManager.this.bufferedCollector, SearchManager.this.remoteMonitor);
            return Status.OK_STATUS;
        }
    };

    public SearchManager() {
        this.localSearchJob.setSystem(true);
        this.remoteSearchJob.setSystem(true);
    }

    public void search(ISearchQuery searchQuery, ISearchHitCollector collector, IProgressMonitor pm) throws QueryTooComplexException {
        if (RemoteHelp.isEnabled()) {
            this.searchLocalAndRemote(searchQuery, collector, pm);
        } else {
            this.searchLocal(searchQuery, collector, pm);
        }
    }

    public void searchLocal(ISearchQuery searchQuery, ISearchHitCollector collector, IProgressMonitor pm) throws QueryTooComplexException {
        this.localManager.search(searchQuery, collector, pm);
    }

    public void searchLocalAndRemote(ISearchQuery searchQuery, ISearchHitCollector collector, IProgressMonitor pm) throws QueryTooComplexException {
        this.searchQuery = searchQuery;
        this.collector = collector;
        pm.beginTask("", 100);
        this.localMonitor = new SubProgressMonitor(pm, 50, 2);
        this.remoteMonitor = new SubProgressMonitor(pm, 50, 2);
        this.localSearchJob.schedule();
        this.remoteSearchJob.schedule();
        try {
            this.localSearchJob.join();
            this.remoteSearchJob.join();
        }
        catch (InterruptedException e) {
            String msg = "Unexpected InterruptedException while waiting for help search jobs to finish";
            HelpBasePlugin.logError(msg, e);
        }
        this.bufferedCollector.flush();
        pm.done();
    }

    public void search(String expression, FederatedSearchEntry[] entries) {
        int i = 0;
        while (i < entries.length) {
            FederatedSearchJob job = new FederatedSearchJob(expression, entries[i]);
            job.schedule();
            ++i;
        }
    }

    public LocalSearchManager getLocalSearchManager() {
        return this.localManager;
    }

    public RemoteSearchManager getRemoteSearchManager() {
        return this.remoteManager;
    }

    public void close() {
        this.localManager.close();
    }

    private class BufferedSearchHitCollector
    implements ISearchHitCollector {
        private Set allHits = new HashSet();
        private String wordsSearched = null;

        private BufferedSearchHitCollector() {
        }

        public void addHits(List hits, String wordsSearched) {
            if (wordsSearched != null) {
                this.wordsSearched = wordsSearched;
            }
            this.allHits.addAll(hits);
        }

        public void flush() {
            ArrayList hitsList = new ArrayList(this.allHits);
            Collections.sort(hitsList);
            SearchManager.this.collector.addHits(hitsList, this.wordsSearched);
            this.allHits.clear();
            this.wordsSearched = null;
        }

        public void addQTCException(QueryTooComplexException exception) throws QueryTooComplexException {
            throw exception;
        }
    }
}

