/*
 * Decompiled with CFR 0.152.
 */
package jp.open.cloud.studio.rcp;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.List;
import jp.open.cloud.studio.rcp.RootModel;
import jp.open.cloud.studio.rcp.SimpleLog;
import jp.open.cloud.studio.rcp.profile.ProfileModel;
import jp.open.cloud.studio.rcp.profile.ProfileModelRoot;
import net.arnx.jsonic.JSON;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "jp.open.cloud.studio.rcp";
    private static Activator plugin;
    private RootModel rootModel;

    public RootModel getRootModel() {
        return this.rootModel;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        try {
            try {
                this.loadProfile(context);
                this.postLoadProfile();
            }
            catch (Exception e) {
                SimpleLog.error("\u30d7\u30ed\u30d5\u30a1\u30a4\u30eb\u60c5\u5831\u306e\u30ed\u30fc\u30c9\u306b\u5931\u6557\u3057\u307e\u3057\u305f", e);
                if (this.rootModel == null) {
                    this.rootModel = new RootModel();
                }
            }
        }
        finally {
            if (this.rootModel == null) {
                this.rootModel = new RootModel();
            }
        }
    }

    private void loadProfile(BundleContext context) throws IOException, UnsupportedEncodingException, FileNotFoundException {
        File file = this.getStateLocation().append("profile.json").toFile();
        if (file.exists()) {
            this.rootModel = (RootModel)JSON.decode((Reader)new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "utf-8")), RootModel.class);
        }
    }

    private void postLoadProfile() {
        ProfileModelRoot root = this.rootModel.getProfileRoot();
        List<ProfileModel> profiles = root.getProfiles();
        for (ProfileModel model : profiles) {
            model.setRoot(root);
        }
    }

    private void saveProfile(BundleContext context) throws IOException, UnsupportedEncodingException, FileNotFoundException {
        File file = this.getStateLocation().append("profile.json").toFile();
        JSON.encode((Object)this.rootModel, (Appendable)new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "utf-8")), (boolean)true);
    }

    public void stop(BundleContext context) throws Exception {
        this.saveProfile(context);
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public static Image getImage(String key) {
        return Activator.getDefault().getImageRegistry().get(key);
    }

    public static ImageDescriptor getDescriptor(String key) {
        return Activator.getDefault().getImageRegistry().getDescriptor(key);
    }

    protected ImageRegistry createImageRegistry() {
        ImageRegistry registry = super.createImageRegistry();
        registry.put("profile", Activator.getImageDescriptor("icons/card.png"));
        registry.put("instance", Activator.getImageDescriptor("icons/leaf.png"));
        registry.put("address", Activator.getImageDescriptor("icons/address.png"));
        registry.put("storage", Activator.getImageDescriptor("icons/storage.png"));
        registry.put("image", Activator.getImageDescriptor("icons/image.png"));
        registry.put("computer", Activator.getImageDescriptor("icons/mycomputer.png"));
        registry.put("stop", Activator.getImageDescriptor("icons/stop.png"));
        registry.put("pause", Activator.getImageDescriptor("icons/pause.png"));
        registry.put("start", Activator.getImageDescriptor("icons/start.png"));
        registry.put("restart", Activator.getImageDescriptor("icons/restart.png"));
        registry.put("lstorage", Activator.getImageDescriptor("icons/large/volume.png"));
        registry.put("linstance", Activator.getImageDescriptor("icons/large/instance.png"));
        registry.put("lgroup", Activator.getImageDescriptor("icons/large/group.png"));
        registry.put("lnetwork", Activator.getImageDescriptor("icons/large/network.png"));
        registry.put("lcloud", Activator.getImageDescriptor("icons/large/cloud.png"));
        registry.put("wizard.profile", Activator.getImageDescriptor("icons/wizard/profile.png"));
        registry.put("background", Activator.getImageDescriptor("icons/background/sky.png"));
        return registry;
    }

    public static void info(String message) {
        if (Activator.getDefault() != null) {
            Activator.getDefault().getLog().log((IStatus)new Status(1, PLUGIN_ID, message));
        } else {
            System.out.println(message);
        }
    }

    public static void warn(String message, Throwable t) {
        if (Activator.getDefault() != null) {
            Activator.getDefault().getLog().log((IStatus)new Status(2, PLUGIN_ID, message, t));
        } else {
            System.out.println(message);
        }
    }
}

