/*
 * Decompiled with CFR 0.152.
 */
package jp.open.cloud.studio.rcp.editor;

import java.util.Timer;
import java.util.TimerTask;
import jp.open.cloud.studio.common.ConnectionConfig;
import jp.open.cloud.studio.rcp.action.ToggleAddressAction;
import jp.open.cloud.studio.rcp.action.ToggleSecurityGroupAction;
import jp.open.cloud.studio.rcp.cloud.animation.AnimationHelper;
import jp.open.cloud.studio.rcp.cloud.animation.AnimationJob;
import jp.open.cloud.studio.rcp.cloud.dnd.ImageLaunchDropTargetListener;
import jp.open.cloud.studio.rcp.cloud.editpart.CloudEditPartFactory;
import jp.open.cloud.studio.rcp.cloud.model.CloudCanvas;
import jp.open.cloud.studio.rcp.connector.CloudConnector;
import jp.open.cloud.studio.rcp.editor.CloudContextMenuProvider;
import jp.open.cloud.studio.rcp.profile.ProfileModel;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.dnd.TransferDropTargetListener;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.ui.parts.GraphicalEditor;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;

public class CloudEditor
extends GraphicalEditor {
    public static final String EDITOR_ID = "jp.open.cloud.studio.rcp.editor.cloudeditor";
    private CloudCanvas canvas;
    private Timer timer;
    private ConnectionConfig config;
    private boolean live = true;
    private AnimationJob job;

    public CloudEditor() {
        DefaultEditDomain domain = new DefaultEditDomain((IEditorPart)this);
        this.setEditDomain(domain);
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        this.setPartName(input.getName());
        ProfileModel model = (ProfileModel)input.getAdapter(ProfileModel.class);
        this.canvas = new CloudCanvas(model);
        this.config = model.toEc2Config();
        this.timer = new Timer();
        this.timer.schedule((TimerTask)new PollingTask(), 0L);
    }

    protected void configureGraphicalViewer() {
        GraphicalViewer viewer = this.getGraphicalViewer();
        viewer.setEditPartFactory((EditPartFactory)new CloudEditPartFactory());
        viewer.setRootEditPart((RootEditPart)new ScalableFreeformRootEditPart());
        viewer.setKeyHandler((KeyHandler)new GraphicalViewerKeyHandler(viewer));
        CloudContextMenuProvider cmProvider = new CloudContextMenuProvider((EditPartViewer)viewer, this.getActionRegistry(), this.config, this.canvas);
        viewer.setContextMenu((MenuManager)cmProvider);
        this.getSite().registerContextMenu((MenuManager)cmProvider, (ISelectionProvider)viewer);
        IActionBars bars = this.getEditorSite().getActionBars();
        bars.getToolBarManager().add((IAction)new ToggleSecurityGroupAction(this.canvas));
        bars.getToolBarManager().add((IAction)new ToggleAddressAction(this.canvas));
        bars.updateActionBars();
    }

    protected void initializeGraphicalViewer() {
        AnimationHelper helper = new AnimationHelper();
        helper.layout(this.canvas);
        this.job = new AnimationJob(this.canvas);
        this.job.setSystem(true);
        this.job.setUser(false);
        this.job.schedule();
        this.getGraphicalViewer().setContents((Object)this.canvas);
        this.getGraphicalViewer().addDropTargetListener((TransferDropTargetListener)new ImageLaunchDropTargetListener((EditPartViewer)this.getGraphicalViewer(), this.config, this.canvas));
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void dispose() {
        super.dispose();
        this.job.cancel();
        try {
            this.job.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.live = false;
        this.timer.cancel();
    }

    public Object getAdapter(Class type) {
        if (type == ProfileModel.class) {
            return this.canvas.getModel();
        }
        return super.getAdapter(type);
    }

    class PollingTask
    extends TimerTask {
        PollingTask() {
        }

        @Override
        public void run() {
            CloudConnector connector = new CloudConnector(CloudEditor.this.canvas, CloudEditor.this.config);
            connector.schedule();
            try {
                connector.join();
                if (CloudEditor.this.live) {
                    CloudEditor.this.timer.schedule((TimerTask)new PollingTask(), 10000L);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

