/*
 * Decompiled with CFR 0.152.
 */
package jp.open.cloud.studio.rcp.image;

import com.xerox.amazonws.ec2.GroupDescription;
import com.xerox.amazonws.ec2.ImageDescription;
import com.xerox.amazonws.ec2.InstanceType;
import com.xerox.amazonws.ec2.KeyPairInfo;
import com.xerox.amazonws.ec2.LaunchConfiguration;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import jp.open.cloud.studio.common.ConnectionConfig;
import jp.open.cloud.studio.common.ConnectionException;
import jp.open.cloud.studio.common.TypicaWrapper;
import jp.open.cloud.studio.rcp.image.GroupKeySettingPage;
import jp.open.cloud.studio.rcp.image.ImageSettingWizardPage;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;

public class LaunchWizard
extends Wizard {
    private ImageDescription imageDescription;
    private List<KeyPairInfo> keypairs;
    private List<GroupDescription> groups;
    private final ConnectionConfig config;
    private ImageSettingWizardPage imagePage;
    private GroupKeySettingPage keySettingPage;

    public LaunchWizard(ConnectionConfig config) {
        this.config = config;
        this.setNeedsProgressMonitor(true);
    }

    public void setImageDescription(ImageDescription imageDescription) {
        this.imageDescription = imageDescription;
    }

    public void setKeypairs(List<KeyPairInfo> keypairs) {
        this.keypairs = keypairs;
    }

    public void setGroups(List<GroupDescription> groups) {
        this.groups = groups;
    }

    public void addPages() {
        this.imagePage = new ImageSettingWizardPage(this.imageDescription);
        this.keySettingPage = new GroupKeySettingPage(this.keypairs, this.groups);
        this.addPage((IWizardPage)this.imagePage);
        this.addPage((IWizardPage)this.keySettingPage);
    }

    public boolean performFinish() {
        try {
            this.getContainer().run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask("\u30a4\u30f3\u30b9\u30bf\u30f3\u30b9\u306e\u8d77\u52d5", 2);
                    monitor.subTask("\u8a2d\u5b9a\u5024\u306e\u53ce\u96c6");
                    TypicaWrapper wrapper = new TypicaWrapper();
                    String imageId = LaunchWizard.this.imagePage.getImageId();
                    String kernelId = LaunchWizard.this.imagePage.getKernelId();
                    String ramdiskId = LaunchWizard.this.imagePage.getRamdiskId();
                    int num = LaunchWizard.this.imagePage.getNumOfInstance();
                    String type = LaunchWizard.this.imagePage.getType();
                    KeyPairInfo keypair = LaunchWizard.this.keySettingPage.getKeyPairInfo();
                    GroupDescription group = LaunchWizard.this.keySettingPage.getGroupDescription();
                    LaunchConfiguration lc = new LaunchConfiguration(imageId);
                    if (!"".equals(kernelId)) {
                        lc.setKernelId(kernelId);
                    }
                    if (!"".equals(ramdiskId)) {
                        lc.setRamdiskId(ramdiskId);
                    }
                    lc.setInstanceType(InstanceType.getTypeFromString((String)type));
                    lc.setMaxCount(num);
                    lc.setMinCount(num);
                    if (keypair != null) {
                        lc.setKeyName(keypair.getKeyName());
                    }
                    if (group != null) {
                        ArrayList<String> groups = new ArrayList<String>();
                        groups.add(group.getName());
                        lc.setSecurityGroup(groups);
                    }
                    try {
                        monitor.worked(1);
                        monitor.subTask("\u30a4\u30f3\u30b9\u30bf\u30f3\u30b9\u8d77\u52d5\u8981\u6c42\u767a\u884c");
                        wrapper.runInstance(LaunchWizard.this.config, lc);
                    }
                    catch (ConnectionException e) {
                        Throwable cause = e.getCause();
                        MessageDialog.openError((Shell)LaunchWizard.this.getShell(), (String)"Failed to Launch Instance", (String)cause.getMessage());
                    }
                }
            });
        }
        catch (InvocationTargetException e1) {
            e1.printStackTrace();
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        return true;
    }
}

