/*
 * Decompiled with CFR 0.152.
 */
package jp.open.cloud.studio.rcp.model;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.arnx.jsonic.JSONHint;
import org.eclipse.swt.widgets.Display;

public class AbstractModel {
    @JSONHint(ignore=true)
    private List<PropertyChangeListener> listeners = new ArrayList<PropertyChangeListener>();

    public void addListener(PropertyChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(PropertyChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void refresh() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                for (PropertyChangeListener listener : AbstractModel.this.listeners) {
                    PropertyChangeEvent event = new PropertyChangeEvent(this, "refresh", null, null);
                    listener.propertyChange(event);
                }
            }
        });
    }

    public void set(String property, Object value) {
        try {
            Method method = this.getClass().getMethod("set" + this.toCamel(property), value.getClass());
            method.invoke((Object)this, value);
            this.refresh();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public Object get(String property) {
        try {
            Method method = this.getClass().getMethod("get" + this.toCamel(property), new Class[0]);
            Object invoke = method.invoke((Object)this, new Object[0]);
            return invoke;
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }

    private String toCamel(String property) {
        return String.valueOf(Character.toString(property.charAt(0)).toUpperCase()) + property.substring(1);
    }
}

