/*
 * Decompiled with CFR 0.152.
 */
package jp.open.cloud.studio.rcp.profile.editor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import jp.open.cloud.studio.rcp.Activator;
import jp.open.cloud.studio.rcp.FileSelectionHandler;
import jp.open.cloud.studio.rcp.ModifyHandler;
import jp.open.cloud.studio.rcp.profile.ProfileModel;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class ProfilePage
extends FormPage
implements PropertyChangeListener {
    private Text nameText;
    private Text ec2Text;
    private Text s3Text;
    private Text accessKeyText;
    private Text secretKeyText;
    private Text cloudcertText;
    private Text x509Text;
    private Text pkText;
    private ProfileModel model;

    public ProfilePage(FormEditor editor, String id, String title) {
        super(editor, id, title);
    }

    protected void createFormContent(IManagedForm managedForm) {
        ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        form.setText("Profile");
        form.setImage(Activator.getImage("profile"));
        form.setBackgroundImage(Activator.getImage("background"));
        form.getBody().setLayout((Layout)new GridLayout());
        Section basicSection = toolkit.createSection(form.getBody(), 384);
        basicSection.setText("\u57fa\u672c\u8a2d\u5b9a");
        basicSection.setDescription("\u57fa\u672c\u8a2d\u5b9a\u306b\u306f\u540d\u524d\u3001\u30af\u30e9\u30a6\u30c9\u30b5\u30fc\u30d3\u30b9\u3078\u306e\u63a5\u7d9a\u8a2d\u5b9a\u304c\u3042\u308a\u307e\u3059\u3002");
        basicSection.setLayoutData((Object)new GridData(768));
        Composite basicComposite = toolkit.createComposite((Composite)basicSection);
        basicComposite.setLayout((Layout)new GridLayout(2, false));
        toolkit.createLabel(basicComposite, "*\u540d\u524d(&N) :");
        this.nameText = toolkit.createText(basicComposite, "");
        this.nameText.setLayoutData((Object)new GridData(768));
        toolkit.createLabel(basicComposite, "*EC2 URL(&E) :");
        this.ec2Text = toolkit.createText(basicComposite, "");
        this.ec2Text.setLayoutData((Object)new GridData(768));
        toolkit.createLabel(basicComposite, "*S3 URL(&S) :");
        this.s3Text = toolkit.createText(basicComposite, "");
        this.s3Text.setLayoutData((Object)new GridData(768));
        basicSection.setClient((Control)basicComposite);
        Section authSection = toolkit.createSection(form.getBody(), 384);
        authSection.setText("\u8a8d\u8a3c");
        authSection.setDescription("\u8a8d\u8a3c\u8a2d\u5b9a\u306b\u306f\u30a2\u30af\u30bb\u30b9\u30ad\u30fc\u3001\u30b7\u30fc\u30af\u30ec\u30c3\u30c8\u30ad\u30fc\u3092\u8a2d\u5b9a\u3057\u307e\u3059\u3002");
        authSection.setLayoutData((Object)new GridData(768));
        Composite authComposite = toolkit.createComposite((Composite)authSection);
        authComposite.setLayout((Layout)new GridLayout(2, false));
        toolkit.createLabel(authComposite, "*Access Key(&A) :");
        this.accessKeyText = toolkit.createText(authComposite, "");
        this.accessKeyText.setLayoutData((Object)new GridData(768));
        toolkit.createLabel(authComposite, "*Secret Key(&c) :");
        this.secretKeyText = toolkit.createText(authComposite, "");
        this.secretKeyText.setLayoutData((Object)new GridData(768));
        authSection.setClient((Control)authComposite);
        Section x509Section = toolkit.createSection(form.getBody(), 384);
        x509Section.setText("X509\u8a3c\u660e\u66f8");
        x509Section.setDescription("\u30a4\u30e1\u30fc\u30b8\u30d5\u30a1\u30a4\u30eb\u306e\u6697\u53f7\u5316\u3001\u5fa9\u53f7\u5316\u306e\u305f\u3081\u306b\u30af\u30e9\u30a6\u30c9\u8a3c\u660e\u66f8\u3001X509\u8a3c\u660e\u66f8\u3001\u79d8\u5bc6\u9375\u3092\u8a2d\u5b9a\u3057\u307e\u3059\u3002");
        x509Section.setLayoutData((Object)new GridData(768));
        Composite x509Composite = toolkit.createComposite((Composite)x509Section);
        x509Composite.setLayout((Layout)new GridLayout(3, false));
        toolkit.createLabel(x509Composite, "\u30af\u30e9\u30a6\u30c9\u8a3c\u660e\u66f8(&C) :");
        this.cloudcertText = toolkit.createText(x509Composite, "");
        this.cloudcertText.setLayoutData((Object)new GridData(768));
        Button ccButton = toolkit.createButton(x509Composite, "...", 8);
        ccButton.addSelectionListener((SelectionListener)new FileSelectionHandler(this.cloudcertText));
        toolkit.createLabel(x509Composite, "X509\u8a3c\u660e\u66f8(&X) :");
        this.x509Text = toolkit.createText(x509Composite, "");
        this.x509Text.setLayoutData((Object)new GridData(768));
        Button xButton = toolkit.createButton(x509Composite, "...", 8);
        xButton.addSelectionListener((SelectionListener)new FileSelectionHandler(this.x509Text));
        toolkit.createLabel(x509Composite, "\u79d8\u5bc6\u9375(&p) :");
        this.pkText = toolkit.createText(x509Composite, "");
        this.pkText.setLayoutData((Object)new GridData(768));
        Button pkButton = toolkit.createButton(x509Composite, "...", 8);
        pkButton.addSelectionListener((SelectionListener)new FileSelectionHandler(this.pkText));
        x509Section.setClient((Control)x509Composite);
        this.init();
    }

    private void init() {
        this.bind();
        this.hookHandler();
        this.model.addListener(this);
    }

    private void hookHandler() {
        this.nameText.addSelectionListener((SelectionListener)new ModifyHandler(this.model, "name"));
        this.nameText.addFocusListener((FocusListener)new ModifyHandler(this.model, "name"));
        this.ec2Text.addSelectionListener((SelectionListener)new ModifyHandler(this.model, "ec2Url"));
        this.ec2Text.addFocusListener((FocusListener)new ModifyHandler(this.model, "ec2Url"));
        this.s3Text.addSelectionListener((SelectionListener)new ModifyHandler(this.model, "s3Url"));
        this.s3Text.addFocusListener((FocusListener)new ModifyHandler(this.model, "s3Url"));
        this.accessKeyText.addSelectionListener((SelectionListener)new ModifyHandler(this.model, "accessKey"));
        this.accessKeyText.addFocusListener((FocusListener)new ModifyHandler(this.model, "accessKey"));
        this.secretKeyText.addSelectionListener((SelectionListener)new ModifyHandler(this.model, "secretKey"));
        this.secretKeyText.addFocusListener((FocusListener)new ModifyHandler(this.model, "secretKey"));
        this.cloudcertText.addModifyListener((ModifyListener)new ModifyHandler(this.model, "cloudCert"));
        this.x509Text.addModifyListener((ModifyListener)new ModifyHandler(this.model, "x509cert"));
        this.pkText.addModifyListener((ModifyListener)new ModifyHandler(this.model, "x509pk"));
    }

    private void bind() {
        this.update(this.nameText, this.model.getName());
        this.update(this.ec2Text, this.model.getEc2Url());
        this.update(this.s3Text, this.model.getS3Url());
        this.update(this.accessKeyText, this.model.getAccessKey());
        this.update(this.secretKeyText, this.model.getSecretKey());
        this.update(this.cloudcertText, this.model.getCloudCert());
        this.update(this.x509Text, this.model.getX509cert());
        this.update(this.pkText, this.model.getX509pk());
    }

    private void update(Text text, String value) {
        if (text.getText().equals(value)) {
            return;
        }
        if (value == null) {
            text.setText("");
        } else {
            text.setText(value);
        }
    }

    public void setModel(ProfileModel model) {
        this.model = model;
    }

    public void dispose() {
        super.dispose();
        this.model.removeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.bind();
    }
}

