/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.aws.ui.action;

import jp.co.intellilink.aws.ui.action.CallbackAction;
import jp.co.intellilink.aws.ui.job.AddIpPermissionJob;
import jp.co.intellilink.aws.ui.model.NetworkRule;
import jp.co.intellilink.aws.ui.model.SecurityGroupModel;
import jp.co.intellilink.aws.ui.view.ActionCallbackHandler;
import jp.co.intellilink.aws.ui.wizard.AddIpPermissionWizard;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.PlatformUI;

public class AddIpPermissionAction
extends CallbackAction
implements ISelectionChangedListener {
    private SecurityGroupModel model;

    public AddIpPermissionAction(ActionCallbackHandler handler) {
        super(handler, "Add IP Permission");
        this.setEnabled(false);
    }

    public void run() {
        super.run();
        PreferenceStore store = new PreferenceStore();
        store.setValue("securityGroup", this.model.getName());
        AddIpPermissionWizard wizard = new AddIpPermissionWizard(store);
        WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            AddIpPermissionJob job = new AddIpPermissionJob("Add Ip Permisiion.", store, this.getHandler());
            job.schedule();
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.setEnabled(false);
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        if (selection.size() == 1) {
            Object[] objectArray = selection.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (object instanceof SecurityGroupModel) {
                    this.model = (SecurityGroupModel)object;
                } else if (object instanceof NetworkRule) {
                    this.model = ((NetworkRule)object).getParent();
                }
                ++n2;
            }
            this.setEnabled(true);
        }
    }
}

