/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.aws.ui.action;

import java.util.List;
import jp.co.intellilink.aws.api.ElasticComputingCloudInterface;
import jp.co.intellilink.aws.api.transport.EC2DescribeAddressRequest;
import jp.co.intellilink.aws.api.transport.EC2DisassociateAddressRequest;
import jp.co.intellilink.aws.core.CoreException;
import jp.co.intellilink.aws.core.EC2ServiceProvider;
import jp.co.intellilink.aws.ui.Activator;
import jp.co.intellilink.aws.ui.action.CallbackAction;
import jp.co.intellilink.aws.ui.model.ElasticIPModel;
import jp.co.intellilink.aws.ui.view.ActionCallbackHandler;
import jp.co.intellilink.aws.ui.view.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class DettachIpAction
extends CallbackAction
implements ISelectionChangedListener {
    private ElasticIPModel model;

    public DettachIpAction(ActionCallbackHandler handler) {
        super(handler, Messages.getString("DettachIpAction.0"));
        this.setImageDescriptor(Activator.imageDescriptorFromPlugin((String)"jp.co.intellilink.aws.ui", (String)"icons/monitor_delete.png"));
        this.setEnabled(false);
    }

    public void run() {
        super.run();
        Job job = new Job(Messages.getString("DettachIpAction.2")){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    monitor.beginTask(Messages.getString("DettachIpAction.3"), 10);
                    monitor.setTaskName(Messages.getString("DettachIpAction.4"));
                    EC2ServiceProvider provider = Activator.getDefault().getProvider();
                    monitor.worked(2);
                    ElasticComputingCloudInterface ec2 = provider.getEC2();
                    monitor.setTaskName(Messages.getString("DettachIpAction.5"));
                    EC2DisassociateAddressRequest ass = new EC2DisassociateAddressRequest();
                    ass.setPublicIp(DettachIpAction.this.model.getIp());
                    ec2.disassociateAddress(ass);
                    monitor.setTaskName(Messages.getString("DettachIpAction.6"));
                    EC2DescribeAddressRequest request = new EC2DescribeAddressRequest();
                    final List responseType = ec2.describeAddress(request);
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            DettachIpAction.this.getHandler().onDescribeAddressExecuted(responseType);
                        }
                    });
                    monitor.done();
                    return Status.OK_STATUS;
                }
                catch (CoreException e) {
                    MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.getString("DettachIpAction.7"), (String)e.getMessage());
                    return Status.CANCEL_STATUS;
                }
            }
        };
        job.schedule();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        if (selection.getFirstElement() instanceof ElasticIPModel) {
            this.model = (ElasticIPModel)selection.getFirstElement();
            if (this.model.getInstanceId() != null && !"".equals(this.model.getInstanceId())) {
                this.setEnabled(true);
            }
        } else {
            this.setEnabled(false);
        }
    }
}

