/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.aws.ui.view;

import java.util.ArrayList;
import java.util.List;
import jp.co.intellilink.aws.api.ElasticComputingCloudInterface;
import jp.co.intellilink.aws.api.transport.EC2Attachment;
import jp.co.intellilink.aws.api.transport.EC2DescribeVolumesRequest;
import jp.co.intellilink.aws.api.transport.EC2Volume;
import jp.co.intellilink.aws.core.CoreException;
import jp.co.intellilink.aws.core.EC2ServiceProvider;
import jp.co.intellilink.aws.ui.Activator;
import jp.co.intellilink.aws.ui.action.AttachVolumeAction;
import jp.co.intellilink.aws.ui.action.DescribeInstancesAction;
import jp.co.intellilink.aws.ui.action.DetachVolumeAction;
import jp.co.intellilink.aws.ui.action.RebootInstanceAction;
import jp.co.intellilink.aws.ui.action.TerminateInstanceAction;
import jp.co.intellilink.aws.ui.model.InstanceModel;
import jp.co.intellilink.aws.ui.view.ActionCallbackHandler;
import jp.co.intellilink.aws.ui.view.InstanceContentProvider;
import jp.co.intellilink.aws.ui.view.InstanceLabelProvider;
import jp.co.intellilink.aws.ui.view.Messages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.DrillDownAdapter;
import org.eclipse.ui.part.ViewPart;

public class InstanceView
extends ViewPart
implements ISelectionChangedListener {
    private static final String VOLUME_STATUS_AVAILABLE = "available";
    private TreeViewer viewer;
    private MenuManager mainMenu;
    private MenuManager attachMenu;
    private MenuManager detachMenu;
    private ActionCallbackHandler handler;
    private DrillDownAdapter drillDownAdapter;
    private DescribeInstancesAction describeInstanceAction;
    private TerminateInstanceAction terminateInstanceAction;
    private RebootInstanceAction rebootInstanceAction;
    private List<InstanceModel> selections;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
    }

    public void createPartControl(Composite parent) {
        this.viewer = new TreeViewer(parent);
        Tree tree = this.viewer.getTree();
        TreeColumn column1 = new TreeColumn(tree, 0);
        column1.setText(Messages.getString("InstanceView.0"));
        column1.setWidth(140);
        TreeColumn column2 = new TreeColumn(tree, 0);
        column2.setText(Messages.getString("InstanceView.1"));
        column2.setWidth(120);
        TreeColumn column3 = new TreeColumn(tree, 0);
        column3.setText(Messages.getString("InstanceView.2"));
        column3.setWidth(160);
        TreeColumn column4 = new TreeColumn(tree, 0);
        column4.setText(Messages.getString("InstanceView.3"));
        column4.setWidth(160);
        TreeColumn column5 = new TreeColumn(tree, 0);
        column5.setText(Messages.getString("InstanceView.4"));
        column5.setWidth(100);
        TreeColumn column6 = new TreeColumn(tree, 0);
        column6.setText(Messages.getString("InstanceView.5"));
        column6.setWidth(100);
        TreeColumn column7 = new TreeColumn(tree, 0);
        column7.setText(Messages.getString("InstanceView.6"));
        column7.setWidth(100);
        TreeColumn column8 = new TreeColumn(tree, 0);
        column8.setText(Messages.getString("InstanceView.7"));
        column8.setWidth(100);
        TreeColumn column9 = new TreeColumn(tree, 0);
        column9.setText(Messages.getString("InstanceView.8"));
        column9.setWidth(100);
        tree.setHeaderVisible(true);
        tree.pack(false);
        this.drillDownAdapter = new DrillDownAdapter(this.viewer);
        this.viewer.setContentProvider((IContentProvider)new InstanceContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new InstanceLabelProvider());
        this.handler = new ActionCallbackHandler((Viewer)this.viewer);
        this.describeInstanceAction = new DescribeInstancesAction(this.handler);
        this.terminateInstanceAction = new TerminateInstanceAction(this.handler);
        this.rebootInstanceAction = new RebootInstanceAction(this.handler, "Reboot Instance");
        IToolBarManager manager = this.getViewSite().getActionBars().getToolBarManager();
        manager.add((IAction)this.describeInstanceAction);
        manager.add((IAction)this.terminateInstanceAction);
        this.drillDownAdapter.addNavigationActions(manager);
        this.attachMenu = new MenuManager("Attach Volume");
        this.detachMenu = new MenuManager("Detach Volume");
        this.mainMenu = new MenuManager("#PopupMenu");
        this.mainMenu.setRemoveAllWhenShown(true);
        this.mainMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IAction)InstanceView.this.describeInstanceAction);
                manager.add((IAction)InstanceView.this.terminateInstanceAction);
                manager.add((IAction)InstanceView.this.rebootInstanceAction);
                manager.add((IContributionItem)InstanceView.this.attachMenu);
                manager.add((IContributionItem)InstanceView.this.detachMenu);
            }
        });
        Menu menu = this.mainMenu.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this.terminateInstanceAction);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this.rebootInstanceAction);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.getSite().registerContextMenu(this.mainMenu, (ISelectionProvider)this.viewer);
    }

    public void setFocus() {
        if (Activator.getDefault().getProvider().canGetEC2()) {
            this.describeInstanceAction.run();
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.attachMenu.setVisible(false);
        this.detachMenu.setVisible(false);
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        this.selections = selection.toList();
        if (this.selections.size() != 1) {
            return;
        }
        this.createVolumeMenu(this.selections.get(0));
    }

    private void createVolumeMenu(InstanceModel instance) {
        this.attachMenu.removeAll();
        this.detachMenu.removeAll();
        List<EC2Volume> volumes = this.describeVolumes();
        if (volumes == null || volumes.size() == 0) {
            return;
        }
        ArrayList<EC2Volume> canAttachVolumes = new ArrayList<EC2Volume>();
        ArrayList<EC2Volume> canDetachVolumes = new ArrayList<EC2Volume>();
        for (EC2Volume volume : volumes) {
            if (VOLUME_STATUS_AVAILABLE.equals(volume.getStatus()) && instance.getZone().equals(volume.getAvailabilityZone())) {
                canAttachVolumes.add(volume);
                continue;
            }
            List attachment = volume.getAttachment();
            if (attachment.size() != 1) continue;
            canDetachVolumes.add(volume);
        }
        if (canAttachVolumes.size() >= 1) {
            for (EC2Volume vol : canAttachVolumes) {
                List<String> usedDevice = this.createUsedDeviceList(instance.getInstanceId(), canDetachVolumes);
                this.attachMenu.add((IAction)new AttachVolumeAction(vol.getVolumeId(), instance.getInstanceId(), usedDevice));
            }
            this.attachMenu.setVisible(true);
        }
        if (canDetachVolumes.size() >= 1) {
            for (EC2Volume vol : canDetachVolumes) {
                this.detachMenu.add((IAction)new DetachVolumeAction(vol.getVolumeId()));
            }
            this.detachMenu.setVisible(true);
        }
    }

    private List<String> createUsedDeviceList(String instanceId, List<EC2Volume> volumes) {
        ArrayList<String> usedDevice = new ArrayList<String>();
        for (EC2Volume volume : volumes) {
            List attachments = volume.getAttachment();
            for (EC2Attachment attachment : attachments) {
                usedDevice.add(attachment.getDevice());
            }
        }
        return usedDevice;
    }

    private List<EC2Volume> describeVolumes() {
        EC2ServiceProvider provider = Activator.getDefault().getProvider();
        List volumes = null;
        try {
            ElasticComputingCloudInterface client = provider.getEC2();
            volumes = client.describeVolumes(new EC2DescribeVolumesRequest());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return volumes;
    }
}

