/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.aws.ui.view;

import jp.co.intellilink.aws.ui.Activator;
import jp.co.intellilink.aws.ui.model.GroupRule;
import jp.co.intellilink.aws.ui.model.IPRangeRule;
import jp.co.intellilink.aws.ui.model.SecurityGroupModel;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class SecurityGroupLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            if (element instanceof SecurityGroupModel) {
                return Activator.imageDescriptorFromPlugin((String)"jp.co.intellilink.aws.ui", (String)"icons/group.png").createImage();
            }
            if (element instanceof GroupRule) {
                return Activator.imageDescriptorFromPlugin((String)"jp.co.intellilink.aws.ui", (String)"icons/user.png").createImage();
            }
            if (element instanceof IPRangeRule) {
                return Activator.imageDescriptorFromPlugin((String)"jp.co.intellilink.aws.ui", (String)"icons/ip.png").createImage();
            }
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof SecurityGroupModel) {
            SecurityGroupModel model = (SecurityGroupModel)element;
            if (columnIndex == 0) {
                return model.getName();
            }
        } else if (element instanceof GroupRule) {
            GroupRule rule = (GroupRule)element;
            switch (columnIndex) {
                case 0: {
                    return rule.getProtcol();
                }
                case 1: {
                    return String.valueOf(rule.getFromPort()) + "-" + rule.getToPort();
                }
                case 2: {
                    return String.valueOf(rule.getSourceSecurityGroupOwnerId()) + "/" + rule.getSourceSecurityGroupName();
                }
            }
        } else if (element instanceof IPRangeRule) {
            IPRangeRule rule = (IPRangeRule)element;
            switch (columnIndex) {
                case 0: {
                    return rule.getProtcol();
                }
                case 1: {
                    return String.valueOf(rule.getFromPort()) + "-" + rule.getToPort();
                }
                case 2: {
                    return rule.getCidrIp();
                }
            }
        }
        return null;
    }
}

