/*
 * Decompiled with CFR 0.152.
 */
package jp.co.intellilink.aws.ui.view;

import jp.co.intellilink.aws.ui.Activator;
import jp.co.intellilink.aws.ui.action.DeleteSnapshotAction;
import jp.co.intellilink.aws.ui.action.DescribeSnapshotsAction;
import jp.co.intellilink.aws.ui.view.ActionCallbackHandler;
import jp.co.intellilink.aws.ui.view.SnapshotLabelProvider;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;

public class SnapshotView
extends ViewPart {
    private ActionCallbackHandler handler;
    private DescribeSnapshotsAction describeSnapshotsAction;
    private DeleteSnapshotAction deleteSnapshotAction;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
    }

    public void createPartControl(Composite parent) {
        TableViewer viewer = new TableViewer(parent);
        Table tree = viewer.getTable();
        TableColumn snapshotId = new TableColumn(tree, 0);
        snapshotId.setText("Snapshot ID");
        snapshotId.setWidth(120);
        TableColumn status = new TableColumn(tree, 0);
        status.setText("Status");
        status.setWidth(90);
        TableColumn progress = new TableColumn(tree, 0);
        progress.setText("Progress");
        progress.setWidth(70);
        TableColumn volumeId = new TableColumn(tree, 0);
        volumeId.setText("Volume ID");
        volumeId.setWidth(100);
        TableColumn volumeSize = new TableColumn(tree, 0);
        volumeSize.setText("Volume Size");
        volumeSize.setWidth(100);
        tree.setHeaderVisible(true);
        tree.pack(false);
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new SnapshotLabelProvider());
        this.handler = new ActionCallbackHandler((Viewer)viewer);
        this.describeSnapshotsAction = new DescribeSnapshotsAction(this.handler);
        this.deleteSnapshotAction = new DeleteSnapshotAction(this.handler);
        IToolBarManager manager = this.getViewSite().getActionBars().getToolBarManager();
        manager.add((IAction)this.describeSnapshotsAction);
        manager.add((IAction)this.deleteSnapshotAction);
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IAction)SnapshotView.this.describeSnapshotsAction);
                manager.add((IAction)SnapshotView.this.deleteSnapshotAction);
            }
        });
        Menu menu = menuMgr.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        viewer.addSelectionChangedListener((ISelectionChangedListener)this.deleteSnapshotAction);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)viewer);
    }

    public void setFocus() {
        if (Activator.getDefault().getProvider().canGetEC2()) {
            this.describeSnapshotsAction.run();
        }
    }
}

