/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.amazonws.common;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

public abstract class AWSConnection {
    private String awsAccessId;
    private String awsSecretKey;
    private boolean isSecure;
    private String server;
    private int port;
    private String resourcePrefix = "/";
    private int sigVersion = 2;
    protected Map<String, List<String>> headers;
    private Map<String, Mac> macMap = new HashMap<String, Mac>();
    private String lastSecretKey;
    private Object macSync = new Object();

    public AWSConnection(String awsAccessId, String awsSecretKey, boolean isSecure, String server, int port) {
        this.awsAccessId = awsAccessId;
        this.awsSecretKey = awsSecretKey;
        this.isSecure = isSecure;
        this.server = server;
        this.port = port;
        this.headers = new TreeMap<String, List<String>>();
    }

    public URL getUrl() {
        try {
            return this.makeURL("");
        }
        catch (MalformedURLException ex) {
            return null;
        }
    }

    public String getAwsAccessKeyId() {
        return this.awsAccessId;
    }

    public String getSecretAccessKey() {
        return this.awsSecretKey;
    }

    public boolean isSecure() {
        return this.isSecure;
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public int getPort() {
        return this.port;
    }

    public String getResourcePrefix() {
        return this.resourcePrefix;
    }

    public void setResourcePrefix(String prefix) {
        this.resourcePrefix = prefix;
    }

    public int getSignatureVersion() {
        return this.sigVersion;
    }

    public void setSignatureVersion(int version) {
        if (version != 0 && version != 1 && version != 2) {
            throw new IllegalArgumentException("Only signature versions 0, 1 and 2 supported");
        }
        this.sigVersion = version;
    }

    protected URL makeURL(String resource) throws MalformedURLException {
        String protocol = this.isSecure ? "https" : "http";
        return new URL(protocol, this.server, this.port, this.resourcePrefix + resource);
    }

    protected String encode(String awsSecretKey, String canonicalString, boolean urlencode) {
        return this.encode(awsSecretKey, canonicalString, urlencode, this.getAlgorithm());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String encode(String awsSecretKey, String canonicalString, boolean urlencode, String algorithm) {
        SecretKeySpec signingKey = new SecretKeySpec(awsSecretKey.getBytes(), algorithm);
        Mac mac = null;
        Object object = this.macSync;
        synchronized (object) {
            mac = this.macMap.get(algorithm);
            if (mac == null || !this.lastSecretKey.equals(awsSecretKey)) {
                try {
                    mac = Mac.getInstance(algorithm);
                }
                catch (NoSuchAlgorithmException e) {
                    throw new RuntimeException("Could not find sha1 algorithm", e);
                }
                try {
                    mac.init(signingKey);
                    this.macMap.put(algorithm, mac);
                }
                catch (InvalidKeyException e) {
                    mac = null;
                    throw new RuntimeException("Could not initialize the MAC algorithm", e);
                }
                this.lastSecretKey = awsSecretKey;
            }
        }
        byte[] signedBytes = null;
        Mac e = mac;
        synchronized (e) {
            try {
                signedBytes = mac.doFinal(canonicalString.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e2) {
                signedBytes = mac.doFinal(canonicalString.getBytes());
            }
        }
        String b64 = new String(Base64.encodeBase64((byte[])signedBytes));
        if (urlencode) {
            return this.urlencode(b64);
        }
        return b64;
    }

    protected String getAlgorithm() {
        return this.sigVersion == 2 ? "HmacSHA256" : "HmacSHA1";
    }

    protected String urlencode(String unencoded) {
        String encoded = unencoded;
        try {
            encoded = this.sigVersion == 2 ? URLEncoder.encode(unencoded, "UTF-8").replace("+", "%20").replace("*", "%2A").replaceAll("%7E", "~") : URLEncoder.encode(unencoded, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Could not url encode to UTF-8", e);
        }
        return encoded;
    }
}

