/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.amazonws.devpay;

import com.xerox.amazonws.common.AWSException;
import com.xerox.amazonws.common.AWSQueryConnection;
import com.xerox.amazonws.devpay.DesktopProductInfo;
import com.xerox.amazonws.devpay.DevPayException;
import com.xerox.amazonws.devpay.HostedProductInfo;
import com.xerox.amazonws.typica.jaxb.ActivateDesktopProductResponse;
import com.xerox.amazonws.typica.jaxb.ActivateDesktopProductResult;
import com.xerox.amazonws.typica.jaxb.ActivateHostedProductResponse;
import com.xerox.amazonws.typica.jaxb.ActivateHostedProductResult;
import com.xerox.amazonws.typica.jaxb.GetActiveSubscriptionsByPidResponse;
import com.xerox.amazonws.typica.jaxb.GetActiveSubscriptionsByPidResult;
import com.xerox.amazonws.typica.jaxb.RefreshUserTokenResponse;
import com.xerox.amazonws.typica.jaxb.RefreshUserTokenResult;
import com.xerox.amazonws.typica.jaxb.VerifyProductSubscriptionByPidResponse;
import com.xerox.amazonws.typica.jaxb.VerifyProductSubscriptionByPidResult;
import com.xerox.amazonws.typica.jaxb.VerifyProductSubscriptionByTokensResponse;
import com.xerox.amazonws.typica.jaxb.VerifyProductSubscriptionByTokensResult;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DevPayLS
extends AWSQueryConnection {
    private static Log logger = LogFactory.getLog(DevPayLS.class);

    public DevPayLS(String awsAccessId, String awsSecretKey) {
        this(awsAccessId, awsSecretKey, true);
    }

    public DevPayLS(String awsAccessId, String awsSecretKey, boolean isSecure) {
        this(awsAccessId, awsSecretKey, isSecure, "ls.amazonaws.com");
    }

    public DevPayLS(String awsAccessId, String awsSecretKey, boolean isSecure, String server) {
        this(awsAccessId, awsSecretKey, isSecure, server, isSecure ? 443 : 80);
    }

    public DevPayLS(String awsAccessId, String awsSecretKey, boolean isSecure, String server, int port) {
        super(awsAccessId, awsSecretKey, isSecure, server, port);
        DevPayLS.setVersionHeader(this);
    }

    @Override
    public int getSignatureVersion() {
        return super.getSignatureVersion();
    }

    @Override
    public void setSignatureVersion(int version) {
        super.setSignatureVersion(version);
    }

    public DesktopProductInfo activateDesktopProduct(String activationKey, String productToken) throws DevPayException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ActivationKey", activationKey);
        params.put("ProductToken", productToken);
        HttpGet method = new HttpGet();
        ActivateDesktopProductResponse response = this.makeRequestInt((HttpRequestBase)method, "ActivateDesktopProduct", params, ActivateDesktopProductResponse.class);
        ActivateDesktopProductResult result = response.getActivateDesktopProductResult();
        return new DesktopProductInfo(result.getAWSAccessKeyId(), result.getSecretAccessKey(), result.getUserToken());
    }

    public HostedProductInfo activateHostedProduct(String activationKey, String productToken) throws DevPayException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ActivationKey", activationKey);
        params.put("ProductToken", productToken);
        HttpGet method = new HttpGet();
        ActivateHostedProductResponse response = this.makeRequestInt((HttpRequestBase)method, "ActivateHostedProduct", params, ActivateHostedProductResponse.class);
        ActivateHostedProductResult result = response.getActivateHostedProductResult();
        return new HostedProductInfo(result.getPersistentIdentifier(), result.getUserToken());
    }

    public List<String> getActiveSubscriptionsByPid(String persistentIdentifier) throws DevPayException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("PersistentIdentifier", persistentIdentifier);
        HttpGet method = new HttpGet();
        GetActiveSubscriptionsByPidResponse response = this.makeRequestInt((HttpRequestBase)method, "GetActiveSubscriptionsByPid", params, GetActiveSubscriptionsByPidResponse.class);
        GetActiveSubscriptionsByPidResult result = response.getGetActiveSubscriptionsByPidResult();
        return result.getProductCodes();
    }

    public boolean isProductSubscribedByPid(String persistentIdentifier, String productCode) throws DevPayException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("PersistentIdentifier", persistentIdentifier);
        params.put("ProductCode", productCode);
        HttpGet method = new HttpGet();
        VerifyProductSubscriptionByPidResponse response = this.makeRequestInt((HttpRequestBase)method, "VerifyProductSubscriptionByPid", params, VerifyProductSubscriptionByPidResponse.class);
        VerifyProductSubscriptionByPidResult result = response.getVerifyProductSubscriptionByPidResult();
        return result.isSubscribed();
    }

    public boolean isProductSubscribedByTokens(String productToken, String userToken) throws DevPayException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ProductToken", productToken);
        params.put("UserToken", userToken);
        HttpGet method = new HttpGet();
        VerifyProductSubscriptionByTokensResponse response = this.makeRequestInt((HttpRequestBase)method, "VerifyProductSubscriptionByTokens", params, VerifyProductSubscriptionByTokensResponse.class);
        VerifyProductSubscriptionByTokensResult result = response.getVerifyProductSubscriptionByTokensResult();
        return result.isSubscribed();
    }

    public String refreshUserToken(String userToken, String additionalTokens) throws DevPayException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("UserToken", userToken);
        if (additionalTokens != null) {
            params.put("AdditionalTokens", additionalTokens);
        }
        HttpGet method = new HttpGet();
        RefreshUserTokenResponse response = this.makeRequestInt((HttpRequestBase)method, "RefreshUserToken", params, RefreshUserTokenResponse.class);
        RefreshUserTokenResult result = response.getRefreshUserTokenResult();
        return result.getUserToken();
    }

    protected <T> T makeRequestInt(HttpRequestBase method, String action, Map<String, String> params, Class<T> respType) throws DevPayException {
        try {
            return this.makeRequest(method, action, params, respType);
        }
        catch (AWSException ex) {
            throw new DevPayException(ex);
        }
        catch (JAXBException ex) {
            throw new DevPayException("Problem parsing returned message.", (Exception)((Object)ex));
        }
        catch (SAXException ex) {
            throw new DevPayException("Problem parsing returned message.", ex);
        }
        catch (HttpException ex) {
            throw new DevPayException(ex.getMessage(), (Exception)((Object)ex));
        }
        catch (IOException ex) {
            throw new DevPayException(ex.getMessage(), ex);
        }
    }

    static void setVersionHeader(AWSQueryConnection connection) {
        ArrayList<String> vals = new ArrayList<String>();
        vals.add("2008-04-28");
        connection.getHeaders().put("Version", vals);
    }
}

