/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.amazonws.ec2;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoScalingGroup {
    private String groupName;
    private String launchConfigurationName;
    private int minSize;
    private int maxSize;
    private int desiredCapacity;
    private int cooldown;
    private List<String> availabilityZones;
    private List<Instance> instances = new ArrayList<Instance>();
    private Calendar createdTime;

    public AutoScalingGroup(String groupName, String launchConfigurationName, int minSize, int maxSize, int desiredCapacity, int cooldown, List<String> availabilityZones, Calendar createdTime) {
        this.groupName = groupName;
        this.launchConfigurationName = launchConfigurationName;
        this.minSize = minSize;
        this.maxSize = maxSize;
        this.desiredCapacity = desiredCapacity;
        this.cooldown = cooldown;
        this.availabilityZones = availabilityZones;
        this.createdTime = createdTime;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public String getLaunchConfigurationName() {
        return this.launchConfigurationName;
    }

    public int getMinSize() {
        return this.minSize;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public int getDesiredCapacity() {
        return this.desiredCapacity;
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public List<String> getAvailabilityZones() {
        return this.availabilityZones;
    }

    public List<Instance> getInstances() {
        return this.instances;
    }

    public Calendar getCreatedTime() {
        return this.createdTime;
    }

    public void addInstance(String instanceId, String lifecycleState) {
        this.instances.add(new Instance(instanceId, lifecycleState));
    }

    public String toString() {
        return "AutoScalingGroup[groupName=" + this.groupName + ", launchConfigurationName=" + this.launchConfigurationName + ", minSize=" + this.minSize + ", maxSize=" + this.maxSize + ", desiredCapacity=" + this.desiredCapacity + ", cooldown=" + this.cooldown + ", zones=" + this.availabilityZones.get(0) + ", instances=" + this.instances + "]";
    }

    public class Instance {
        private String instanceId;
        private String lifecycleState;

        public Instance(String instanceId, String lifecycleState) {
            this.instanceId = instanceId;
            this.lifecycleState = lifecycleState;
        }

        public String getInstanceId() {
            return this.instanceId;
        }

        public String getLifecycleState() {
            return this.lifecycleState;
        }

        public String toString() {
            return "[instance=" + this.instanceId + ", lifecycleState=" + this.lifecycleState + "]";
        }
    }
}

