/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.amazonws.ec2;

import com.xerox.amazonws.ec2.BlockDeviceMapping;
import com.xerox.amazonws.ec2.InstanceType;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LaunchConfiguration {
    private String configName;
    private String imageId;
    private int minCount;
    private int maxCount;
    private String keyName;
    private List<String> securityGroup;
    private String availabilityZone;
    private byte[] userData;
    private InstanceType instanceType = InstanceType.DEFAULT;
    private String kernelId;
    private String ramdiskId;
    private List<BlockDeviceMapping> blockDeviceMappings;
    private boolean monitoring;
    private boolean addressingType = true;
    private String additionalInfo;
    private String subnetId;
    private String privateIpAddress;
    private String groupName;

    public LaunchConfiguration(String imageId) {
        this(imageId, 1, 1);
    }

    public LaunchConfiguration(String imageId, int minCount, int maxCount) {
        this.imageId = imageId;
        this.minCount = minCount;
        this.maxCount = maxCount;
    }

    public LaunchConfiguration(String configName, String imageId, int minCount, int maxCount) {
        this.configName = configName;
        this.imageId = imageId;
        this.minCount = minCount;
        this.maxCount = maxCount;
    }

    public String getConfigName() {
        return this.configName;
    }

    public void setConfigName(String configName) {
        this.configName = configName;
    }

    public String getImageId() {
        return this.imageId;
    }

    public void setImageId(String imageId) {
        this.imageId = imageId;
    }

    public int getMinCount() {
        return this.minCount;
    }

    public void setMinCount(int minCount) {
        this.minCount = minCount;
    }

    public int getMaxCount() {
        return this.maxCount;
    }

    public void setMaxCount(int maxCount) {
        this.maxCount = maxCount;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    public List<String> getSecurityGroup() {
        return this.securityGroup;
    }

    public void setSecurityGroup(List<String> securityGroup) {
        this.securityGroup = securityGroup;
    }

    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    public void setAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
    }

    public InstanceType getInstanceType() {
        return this.instanceType;
    }

    public void setInstanceType(InstanceType instanceType) {
        this.instanceType = instanceType;
    }

    public byte[] getUserData() {
        return this.userData;
    }

    public void setUserData(byte[] userData) {
        this.userData = userData;
    }

    public String getAdditionalInfo() {
        return this.additionalInfo;
    }

    public void setAdditionalInfo(String additionalInfo) {
        this.additionalInfo = additionalInfo;
    }

    public String getKernelId() {
        return this.kernelId;
    }

    public void setKernelId(String kernelId) {
        this.kernelId = kernelId;
    }

    public String getRamdiskId() {
        return this.ramdiskId;
    }

    public void setRamdiskId(String ramdiskId) {
        this.ramdiskId = ramdiskId;
    }

    public List<BlockDeviceMapping> getBlockDevicemappings() {
        return this.blockDeviceMappings;
    }

    public void setBlockDevicemappings(List<BlockDeviceMapping> blockDeviceMappings) {
        this.blockDeviceMappings = blockDeviceMappings;
    }

    public Boolean isMonitoring() {
        return this.monitoring;
    }

    public void setMonitoring(boolean set) {
        this.monitoring = set;
    }

    public Boolean isPublicAddressing() {
        return this.addressingType;
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public void setSubnetId(String subnetId) {
        this.subnetId = subnetId;
    }

    public String getPrivateIpAddress() {
        return this.privateIpAddress;
    }

    public void setPrivateIpAddress(String privateIpAddress) {
        this.privateIpAddress = privateIpAddress;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public void setPublicAddressing(boolean set) {
        this.addressingType = set;
    }

    void prepareQueryParams(String prefix, boolean setMinAndMax, Map<String, String> params) {
        String groupName;
        String privateIpAddress;
        String subnetId;
        int i;
        byte[] userData;
        params.put(prefix + "ImageId", this.getImageId());
        if (setMinAndMax) {
            params.put(prefix + "MinCount", "" + this.getMinCount());
            params.put(prefix + "MaxCount", "" + this.getMaxCount());
        }
        if ((userData = this.getUserData()) != null && userData.length > 0) {
            params.put(prefix + "UserData", new String(Base64.encodeBase64((byte[])userData)));
        }
        params.put(prefix + "AddressingType", this.isPublicAddressing() != false ? "public" : "private");
        String keyName = this.getKeyName();
        if (keyName != null && !keyName.trim().equals("")) {
            params.put(prefix + "KeyName", keyName);
        }
        if (this.getSecurityGroup() != null) {
            for (i = 0; i < this.getSecurityGroup().size(); ++i) {
                params.put(prefix + "SecurityGroup." + (i + 1), this.getSecurityGroup().get(i));
            }
        }
        if (this.getAdditionalInfo() != null && !this.getAdditionalInfo().trim().equals("")) {
            params.put(prefix + "AdditionalInfo", this.getAdditionalInfo());
        }
        params.put(prefix + "InstanceType", this.getInstanceType().getTypeId());
        if (this.getAvailabilityZone() != null && !this.getAvailabilityZone().trim().equals("")) {
            params.put(prefix + "Placement.AvailabilityZone", this.getAvailabilityZone());
        }
        if (this.getKernelId() != null && !this.getKernelId().trim().equals("")) {
            params.put(prefix + "KernelId", this.getKernelId());
        }
        if (this.getRamdiskId() != null && !this.getRamdiskId().trim().equals("")) {
            params.put(prefix + "RamdiskId", this.getRamdiskId());
        }
        if (this.blockDeviceMappings != null) {
            for (i = 0; i < this.blockDeviceMappings.size(); ++i) {
                BlockDeviceMapping bdm = this.blockDeviceMappings.get(i);
                params.put("BlockDeviceMapping." + (i + 1) + ".DeviceName", bdm.getDeviceName());
                if (bdm.getVirtualName() != null) {
                    params.put("BlockDeviceMapping." + (i + 1) + ".VirtualName", bdm.getVirtualName());
                    continue;
                }
                if (bdm.getSnapshotId() != null) {
                    params.put("BlockDeviceMapping." + (i + 1) + ".Ebs.SnapshotId", bdm.getSnapshotId());
                }
                if (bdm.getVolumeSize() > 0) {
                    params.put("BlockDeviceMapping." + (i + 1) + ".Ebs.VolumeSize", "" + bdm.getVolumeSize());
                }
                params.put("BlockDeviceMapping." + (i + 1) + ".Ebs.DeleteOnTermination", bdm.isDeleteOnTerminate() ? "true" : "false");
            }
        }
        if (this.isMonitoring().booleanValue()) {
            params.put(prefix + "Monitoring.Enabled", "true");
        }
        if ((subnetId = this.getSubnetId()) != null && !subnetId.trim().equals("")) {
            params.put(prefix + "SubnetId", subnetId);
        }
        if ((privateIpAddress = this.getPrivateIpAddress()) != null && !privateIpAddress.trim().equals("")) {
            params.put(prefix + "PrivateIpAddress", privateIpAddress);
        }
        if ((groupName = this.getGroupName()) != null && !groupName.trim().equals("")) {
            params.put(prefix + "GroupName", groupName);
        }
    }
}

