/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.amazonws.ec2;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UploadPolicy {
    private static Log logger = LogFactory.getLog(UploadPolicy.class);
    private int minutesToExpiration;
    private String bucket;
    private String acl;
    private String prefix;

    public UploadPolicy(int minutesToExpiration, String bucket, String acl, String prefix) {
        this.minutesToExpiration = minutesToExpiration;
        this.bucket = bucket;
        this.acl = acl;
        this.prefix = prefix;
    }

    UploadPolicy(String jsonPolicyString) {
    }

    public int getMinutesToExpiration() {
        return this.minutesToExpiration;
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getAcl() {
        return this.acl;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getPolicyString() {
        StringBuilder json = new StringBuilder("{\n");
        json.append("\"expiration\": \"");
        String DateFormat2 = "yyyy-MM-dd'T'HH:mm:ss'Z'";
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US);
        format.setTimeZone(TimeZone.getTimeZone("GMT"));
        json.append(format.format(new Date(System.currentTimeMillis() + (long)this.minutesToExpiration * 60000L)));
        json.append("\",\n");
        json.append("\"conditions\": [\n");
        json.append("{\"acl\": \"");
        json.append(this.acl);
        json.append("\"},\n");
        json.append("{\"bucket\": \"");
        json.append(this.bucket);
        json.append("\"},\n");
        json.append("[\"starts-with\", \"$key\", \"");
        json.append(this.prefix);
        json.append("\"],\n");
        json.append("]\n}");
        logger.debug((Object)("JSON policy string = " + json.toString()));
        return new String(Base64.encodeBase64((byte[])json.toString().getBytes()));
    }

    public String toString() {
        return "UploadPolicy[minutesToExpiration=" + this.minutesToExpiration + ", bucket=" + this.bucket + ", acl=" + this.acl + "]";
    }
}

