/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.amazonws.sdb;

import com.xerox.amazonws.sdb.Condition;
import com.xerox.amazonws.sdb.Domain;
import com.xerox.amazonws.sdb.Item;
import com.xerox.amazonws.sdb.ItemAttribute;
import com.xerox.amazonws.sdb.SDBException;
import java.util.ArrayList;
import java.util.List;

public class Counter {
    private Domain domain;
    private String name;

    public Counter(Domain domain, String counterName) throws SDBException {
        this.domain = domain;
        this.name = counterName;
        Item i = domain.getItem(this.name);
        List<ItemAttribute> attrs = i.getAttributes();
        if (attrs == null) {
            attrs = new ArrayList<ItemAttribute>();
        }
        ItemAttribute attr = null;
        if (attrs.size() > 0) {
            attr = attrs.get(0);
        }
        if (attr != null) {
            String val = attr.getValue();
            if (val != null) {
                return;
            }
        } else {
            attrs.add(new ItemAttribute("Value", "0", true));
        }
        i.putAttributes(attrs);
    }

    public Counter(Domain domain, String counterName, long initValue) throws SDBException {
        this(domain, counterName);
        Item i = domain.getItem(this.name);
        ItemAttribute attr = new ItemAttribute("Value", "" + initValue, true);
        ArrayList<ItemAttribute> attrs = new ArrayList<ItemAttribute>();
        attrs.add(attr);
        i.putAttributes(attrs);
    }

    public String getName() {
        return this.name;
    }

    public long nextValue() throws SDBException {
        Item i = this.domain.getItem(this.name);
        List<ItemAttribute> attrs = i.getAttributes();
        ItemAttribute attr = attrs.get(0);
        String val = attr.getValue();
        long value = Long.parseLong(val);
        boolean done = false;
        while (!done) {
            try {
                attr = new ItemAttribute("Value", "" + (value + 1L), true);
                attrs.clear();
                attrs.add(attr);
                ArrayList<Condition> conds = new ArrayList<Condition>();
                conds.add(new Condition("Value", "" + value));
                i.putAttributes(attrs, conds);
                done = true;
            }
            catch (SDBException ex) {
                String msg = ex.getErrors().get(0).getCode();
                if (msg.equals("ConditionalCheckFailed")) {
                    ++value;
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ie) {}
                    continue;
                }
                throw ex;
            }
        }
        return value + 1L;
    }
}

