/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.amazonws.simpledb;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DataUtils {
    private static String dateFormat = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private static final BigDecimal SIGNIFICAND_COLLATOR = BigDecimal.TEN;
    private static final int EXPONENT_COLLATOR = 999;
    private static final DecimalFormat FULL_DECIMAL_FORMAT = new DecimalFormat();
    private static final DecimalFormat SIGNIFICAND_FORMAT;

    public static String encodeZeroPadding(int number, int maxNumDigits) {
        String integerString = Integer.toString(number);
        int numZeroes = maxNumDigits - integerString.length();
        StringBuffer strBuffer = new StringBuffer(numZeroes + integerString.length());
        for (int i = 0; i < numZeroes; ++i) {
            strBuffer.insert(i, '0');
        }
        strBuffer.append(integerString);
        return strBuffer.toString();
    }

    public static String encodeZeroPadding(long number, int maxNumDigits) {
        String longString = Long.toString(number);
        int numZeroes = maxNumDigits - longString.length();
        StringBuffer strBuffer = new StringBuffer(numZeroes + longString.length());
        for (int i = 0; i < numZeroes; ++i) {
            strBuffer.insert(i, '0');
        }
        strBuffer.append(longString);
        return strBuffer.toString();
    }

    public static String encodeZeroPadding(float number, int maxNumDigits) {
        String floatString = Float.toString(number);
        int numBeforeDecimal = floatString.indexOf(46);
        numBeforeDecimal = numBeforeDecimal >= 0 ? numBeforeDecimal : floatString.length();
        int numZeroes = maxNumDigits - numBeforeDecimal;
        StringBuffer strBuffer = new StringBuffer(numZeroes + floatString.length());
        for (int i = 0; i < numZeroes; ++i) {
            strBuffer.insert(i, '0');
        }
        strBuffer.append(floatString);
        return strBuffer.toString();
    }

    public static String encodeZeroPadding(double number, int maxNumDigits) {
        String doubleString = Double.toString(number);
        int numBeforeDecimal = doubleString.indexOf(46);
        numBeforeDecimal = numBeforeDecimal >= 0 ? numBeforeDecimal : doubleString.length();
        int numZeroes = maxNumDigits - numBeforeDecimal;
        StringBuffer strBuffer = new StringBuffer(numZeroes + doubleString.length());
        for (int i = 0; i < numZeroes; ++i) {
            strBuffer.insert(i, '0');
        }
        strBuffer.append(doubleString);
        return strBuffer.toString();
    }

    public static int decodeZeroPaddingInt(String value) {
        return Integer.parseInt(value, 10);
    }

    public static long decodeZeroPaddingLong(String value) {
        return Long.parseLong(value, 10);
    }

    public static float decodeZeroPaddingFloat(String value) {
        return Float.valueOf(value).floatValue();
    }

    public static double decodeZeroPaddingDouble(String value) {
        return Double.valueOf(value);
    }

    public static String encodeRealNumberRange(int number, int maxNumDigits, int offsetValue) {
        long offsetNumber = number + offsetValue;
        String longString = Long.toString(offsetNumber);
        int numZeroes = maxNumDigits - longString.length();
        StringBuffer strBuffer = new StringBuffer(numZeroes + longString.length());
        for (int i = 0; i < numZeroes; ++i) {
            strBuffer.insert(i, '0');
        }
        strBuffer.append(longString);
        return strBuffer.toString();
    }

    public static String encodeRealNumberRange(long number, int maxNumDigits, int offsetValue) {
        long offsetNumber = number + (long)offsetValue;
        String longString = Long.toString(offsetNumber);
        int numZeroes = maxNumDigits - longString.length();
        StringBuffer strBuffer = new StringBuffer(numZeroes + longString.length());
        for (int i = 0; i < numZeroes; ++i) {
            strBuffer.insert(i, '0');
        }
        strBuffer.append(longString);
        return strBuffer.toString();
    }

    public static String encodeRealNumberRange(float number, int maxDigitsLeft, int maxDigitsRight, int offsetValue) {
        long shiftMultiplier = (long)Math.pow(10.0, maxDigitsRight);
        long shiftedNumber = Math.round(number * (float)shiftMultiplier);
        long shiftedOffset = (long)offsetValue * shiftMultiplier;
        long offsetNumber = shiftedNumber + shiftedOffset;
        String longString = Long.toString(offsetNumber);
        int numBeforeDecimal = longString.length();
        int numZeroes = maxDigitsLeft + maxDigitsRight - numBeforeDecimal;
        StringBuffer strBuffer = new StringBuffer(numZeroes + longString.length());
        for (int i = 0; i < numZeroes; ++i) {
            strBuffer.insert(i, '0');
        }
        strBuffer.append(longString);
        return strBuffer.toString();
    }

    public static String encodeRealNumberRange(double number, int maxDigitsLeft, int maxDigitsRight, long offsetValue) {
        int shiftMultiplier = (int)Math.pow(10.0, maxDigitsRight);
        long shiftedNumber = Math.round(number * (double)shiftMultiplier);
        long shiftedOffset = offsetValue * (long)shiftMultiplier;
        long offsetNumber = shiftedNumber + shiftedOffset;
        String longString = Long.toString(offsetNumber);
        int numBeforeDecimal = longString.length();
        int numZeroes = maxDigitsLeft + maxDigitsRight - numBeforeDecimal;
        StringBuffer strBuffer = new StringBuffer(numZeroes + longString.length());
        for (int i = 0; i < numZeroes; ++i) {
            strBuffer.insert(i, '0');
        }
        strBuffer.append(longString);
        return strBuffer.toString();
    }

    public static int decodeRealNumberRangeInt(String value, int offsetValue) {
        long offsetNumber = Long.parseLong(value, 10);
        return (int)(offsetNumber - (long)offsetValue);
    }

    public static long decodeRealNumberRangeLong(String value, long offsetValue) {
        long offsetNumber = Long.parseLong(value, 10);
        return offsetNumber - offsetValue;
    }

    public static float decodeRealNumberRangeFloat(String value, int maxDigitsRight, int offsetValue) {
        long offsetNumber = Long.parseLong(value, 10);
        long shiftMultiplier = (long)Math.pow(10.0, maxDigitsRight);
        double tempVal = offsetNumber - (long)offsetValue * shiftMultiplier;
        return (float)(tempVal / (double)shiftMultiplier);
    }

    public static double decodeRealNumberRangeDouble(String value, int maxDigitsRight, long offsetValue) {
        long offsetNumber = Long.parseLong(value, 10);
        int shiftMultiplier = (int)Math.pow(10.0, maxDigitsRight);
        double tempVal = offsetNumber - offsetValue * (long)shiftMultiplier;
        return tempVal / (double)shiftMultiplier;
    }

    public static String encodeDate(Date date) {
        SimpleDateFormat dateFormatter = new SimpleDateFormat(dateFormat);
        String result = dateFormatter.format(date);
        return result.substring(0, result.length() - 2) + ":" + result.substring(result.length() - 2);
    }

    public static Date decodeDate(String value) throws ParseException {
        String javaValue = value.substring(0, value.length() - 3) + value.substring(value.length() - 2);
        SimpleDateFormat dateFormatter = new SimpleDateFormat(dateFormat);
        return dateFormatter.parse(javaValue);
    }

    public static String encodeDouble(double d) {
        String result;
        String decimalString = FULL_DECIMAL_FORMAT.format(d);
        int splitPoint = decimalString.indexOf(69);
        String significand = decimalString.substring(0, splitPoint);
        String exponent = decimalString.substring(splitPoint + 1);
        boolean negativeExponent = exponent.startsWith("-");
        if (significand.startsWith("-")) {
            BigDecimal significandValue = new BigDecimal(significand);
            BigDecimal collatedSignificand = significandValue.add(SIGNIFICAND_COLLATOR);
            String formattedSignificand = SIGNIFICAND_FORMAT.format(collatedSignificand);
            if (!negativeExponent) {
                int exponentValue = 999 - Integer.parseInt(exponent);
                result = "1 " + exponentValue + " " + formattedSignificand;
            } else {
                result = "2 " + exponent.substring(1) + " " + formattedSignificand;
            }
        } else if (d == 0.0) {
            result = "3 000 0.0000000000000000";
        } else if (negativeExponent) {
            int exponentValue = Integer.parseInt(exponent) + 999;
            result = "4 " + exponentValue + " " + significand;
        } else {
            result = "5 " + exponent + " " + significand;
        }
        return result;
    }

    public static double decodeDouble(String s) {
        char caseNumber = s.charAt(0);
        if (caseNumber == '3') {
            return 0.0;
        }
        String exponentString = s.substring(2, 5);
        int exponent = Integer.parseInt(exponentString);
        String significand = s.substring(6);
        if (caseNumber == '4') {
            exponent -= 999;
        } else if (caseNumber == '1' || caseNumber == '2') {
            BigDecimal collatedSignificand = new BigDecimal(significand);
            BigDecimal significandValue = collatedSignificand.subtract(SIGNIFICAND_COLLATOR);
            significand = significandValue.toString();
            if (caseNumber == '1') {
                exponent = 999 - exponent;
            } else if (caseNumber == '2') {
                exponent = -exponent;
            }
        }
        return Double.parseDouble(significand + "E" + exponent);
    }

    static {
        FULL_DECIMAL_FORMAT.applyPattern("0.0000000000000000E000");
        SIGNIFICAND_FORMAT = new DecimalFormat();
        SIGNIFICAND_FORMAT.applyPattern("0.0000000000000000");
    }
}

