/*
 * Decompiled with CFR 0.152.
 */
package de.jw.cloud42.core.domain;

import com.xerox.amazonws.ec2.ReservationDescription;
import java.util.Calendar;

public class Instance {
    private String imageId;
    private String instanceId;
    private String privateDnsName;
    private String dnsName;
    private String reason;
    private String keyName;
    private String instanceType;
    private Calendar launchTime;
    private String availabilityZone;
    private String kernelId;
    private String ramdiskId;
    private String state;
    private String stateCode;
    private String[] groups;
    private String reservationId;
    private String owner;

    public String getReservationId() {
        return this.reservationId;
    }

    public String getOwner() {
        return this.owner;
    }

    public String[] getGroups() {
        return this.groups;
    }

    public Instance(ReservationDescription resDescr, int instanceIndex) {
        ReservationDescription.Instance instance = (ReservationDescription.Instance)resDescr.getInstances().get(instanceIndex);
        this.groups = resDescr.getGroups().toArray(new String[0]);
        this.owner = resDescr.getOwner();
        this.reservationId = resDescr.getReservationId();
        this.imageId = instance.getImageId();
        this.instanceId = instance.getInstanceId();
        this.privateDnsName = instance.getPrivateDnsName();
        this.dnsName = instance.getDnsName();
        this.state = instance.getState();
        this.stateCode = instance.getStateCode();
        this.reason = instance.getReason();
        this.keyName = instance.getKeyName();
        this.instanceType = instance.getInstanceType().getTypeId();
        this.launchTime = instance.getLaunchTime();
        this.availabilityZone = instance.getAvailabilityZone();
        this.kernelId = instance.getKernelId();
        this.ramdiskId = instance.getRamdiskId();
    }

    public String getImageId() {
        return this.imageId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getPrivateDnsName() {
        return this.privateDnsName;
    }

    public String getDnsName() {
        return this.dnsName;
    }

    public String getReason() {
        return this.reason;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public String getState() {
        return this.state;
    }

    public boolean isRunning() {
        return this.state.equals("running");
    }

    public boolean isPending() {
        return this.state.equals("pending");
    }

    public boolean isShuttingDown() {
        return this.state.equals("shutting-down");
    }

    public boolean isTerminated() {
        return this.state.equals("terminated");
    }

    public String getStateCode() {
        return this.stateCode;
    }

    public String getInstanceType() {
        return this.instanceType;
    }

    public Calendar getLaunchTime() {
        return this.launchTime;
    }

    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    public String getKernelId() {
        return this.kernelId;
    }

    public String getRamdiskId() {
        return this.ramdiskId;
    }

    public String toString() {
        return "[img=" + this.imageId + ", instance=" + this.instanceId + ", privateDns=" + this.privateDnsName + ", dns=" + this.dnsName + ", loc=" + ", state=" + this.state + "(" + this.stateCode + ") reason=" + this.reason + "]";
    }
}

