/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.config;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.el.ELResolver;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import javax.faces.application.NavigationHandler;
import javax.faces.application.StateManager;
import javax.faces.application.ViewHandler;
import javax.faces.context.ExternalContext;
import javax.faces.el.PropertyResolver;
import javax.faces.el.VariableResolver;
import javax.faces.event.ActionListener;
import javax.faces.event.PhaseListener;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.application.ApplicationFactoryImpl;
import org.apache.myfaces.application.ApplicationImpl;
import org.apache.myfaces.config.FacesConfigDispenser;
import org.apache.myfaces.config.FacesConfigUnmarshaller;
import org.apache.myfaces.config.RuntimeConfig;
import org.apache.myfaces.config.element.ManagedBean;
import org.apache.myfaces.config.element.NavigationRule;
import org.apache.myfaces.config.element.Renderer;
import org.apache.myfaces.config.impl.digester.DigesterFacesConfigDispenserImpl;
import org.apache.myfaces.config.impl.digester.DigesterFacesConfigUnmarshallerImpl;
import org.apache.myfaces.context.FacesContextFactoryImpl;
import org.apache.myfaces.el.DefaultPropertyResolver;
import org.apache.myfaces.el.VariableResolverImpl;
import org.apache.myfaces.lifecycle.LifecycleFactoryImpl;
import org.apache.myfaces.renderkit.RenderKitFactoryImpl;
import org.apache.myfaces.renderkit.html.HtmlRenderKitImpl;
import org.apache.myfaces.shared_impl.config.MyfacesConfig;
import org.apache.myfaces.shared_impl.util.ClassUtils;
import org.apache.myfaces.shared_impl.util.LocaleUtils;
import org.apache.myfaces.shared_impl.util.serial.DefaultSerialFactory;
import org.apache.myfaces.shared_impl.util.serial.SerialFactory;
import org.xml.sax.SAXException;

public class FacesConfigurator {
    private static final Log log = LogFactory.getLog(FacesConfigurator.class);
    private static final String STANDARD_FACES_CONFIG_RESOURCE = "META-INF/standard-faces-config.xml";
    private static final String FACES_CONFIG_RESOURCE = "META-INF/faces-config.xml";
    private static final String META_INF_SERVICES_RESOURCE_PREFIX = "META-INF/services/";
    private static final String DEFAULT_RENDER_KIT_CLASS = HtmlRenderKitImpl.class.getName();
    private static final String DEFAULT_APPLICATION_FACTORY = ApplicationFactoryImpl.class.getName();
    private static final String DEFAULT_FACES_CONTEXT_FACTORY = FacesContextFactoryImpl.class.getName();
    private static final String DEFAULT_LIFECYCLE_FACTORY = LifecycleFactoryImpl.class.getName();
    private static final String DEFAULT_RENDER_KIT_FACTORY = RenderKitFactoryImpl.class.getName();
    private static final String DEFAULT_FACES_CONFIG = "/WEB-INF/faces-config.xml";
    private static final Set<String> FACTORY_NAMES = new HashSet<String>();
    private final ExternalContext _externalContext;
    private FacesConfigUnmarshaller _unmarshaller;
    private FacesConfigDispenser _dispenser;
    private RuntimeConfig _runtimeConfig;
    private static final String JAR_EXTENSION = ".jar";
    private static final String META_INF_MANIFEST_SUFFIX = "!/META-INF/MANIFEST.MF";
    private static final String JAR_PREFIX = "jar:";
    private static long lastUpdate;
    public static final String MYFACES_API_PACKAGE_NAME = "myfaces-api";
    public static final String MYFACES_IMPL_PACKAGE_NAME = "myfaces-impl";
    public static final String MYFACES_TOMAHAWK_PACKAGE_NAME = "tomahawk";
    public static final String MYFACES_TOMAHAWK_SANDBOX_PACKAGE_NAME = "tomahawk-sandbox";
    public static final String MYFACES_TOMAHAWK_SANDBOX15_PACKAGE_NAME = "tomahawk-sandbox15";
    public static final String COMMONS_EL_PACKAGE_NAME = "commons-el";
    public static final String JSP_API_PACKAGE_NAME = "jsp-api";

    public FacesConfigurator(ExternalContext externalContext) {
        FACTORY_NAMES.add("javax.faces.application.ApplicationFactory");
        FACTORY_NAMES.add("javax.faces.context.FacesContextFactory");
        FACTORY_NAMES.add("javax.faces.lifecycle.LifecycleFactory");
        FACTORY_NAMES.add("javax.faces.render.RenderKitFactory");
        if (externalContext == null) {
            throw new IllegalArgumentException("external context must not be null");
        }
        this._externalContext = externalContext;
    }

    public void setUnmarshaller(FacesConfigUnmarshaller unmarshaller) {
        this._unmarshaller = unmarshaller;
    }

    protected FacesConfigUnmarshaller getUnmarshaller() {
        if (this._unmarshaller == null) {
            this._unmarshaller = new DigesterFacesConfigUnmarshallerImpl(this._externalContext);
        }
        return this._unmarshaller;
    }

    public void setDispenser(FacesConfigDispenser dispenser) {
        this._dispenser = dispenser;
    }

    protected FacesConfigDispenser getDispenser() {
        if (this._dispenser == null) {
            this._dispenser = new DigesterFacesConfigDispenserImpl();
        }
        return this._dispenser;
    }

    private long getResourceLastModified(String resource) {
        try {
            URL url = this._externalContext.getResource(resource);
            if (url != null) {
                return url.openConnection().getLastModified();
            }
        }
        catch (IOException e) {
            log.error((Object)("Could not read resource " + resource), (Throwable)e);
        }
        return 0L;
    }

    private long getLastModifiedTime() {
        long lastModified = 0L;
        long resModified = this.getResourceLastModified(DEFAULT_FACES_CONFIG);
        if (resModified > lastModified) {
            lastModified = resModified;
        }
        List configFilesList = this.getConfigFilesList();
        for (int i = 0; i < configFilesList.size(); ++i) {
            String systemId = (String)configFilesList.get(i);
            resModified = this.getResourceLastModified(systemId);
            if (resModified <= lastModified) continue;
            lastModified = resModified;
        }
        return lastModified;
    }

    public void update() {
        long refreshPeriod = MyfacesConfig.getCurrentInstance(this._externalContext).getConfigRefreshPeriod() * 1000L;
        if (refreshPeriod > 0L) {
            long ttl = lastUpdate + refreshPeriod;
            if (System.currentTimeMillis() > ttl && this.getLastModifiedTime() > ttl) {
                try {
                    this.purgeConfiguration();
                }
                catch (NoSuchMethodException e) {
                    log.error((Object)"Configuration objects do not support clean-up. Update aborted");
                    return;
                }
                catch (IllegalAccessException e) {
                    log.fatal((Object)("Error during configuration clean-up" + e.getMessage()));
                }
                catch (InvocationTargetException e) {
                    log.fatal((Object)("Error during configuration clean-up" + e.getMessage()));
                }
                this.configure();
            }
        }
    }

    private void purgeConfiguration() throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object[] emptyParameterList = new Class[]{};
        ApplicationFactory applicationFactory = (ApplicationFactory)FactoryFinder.getFactory((String)"javax.faces.application.ApplicationFactory");
        Method purgeMethod = applicationFactory.getClass().getMethod("purgeApplication", (Class<?>[])emptyParameterList);
        purgeMethod.invoke((Object)applicationFactory, emptyParameterList);
        RenderKitFactory renderKitFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
        purgeMethod = renderKitFactory.getClass().getMethod("purgeRenderKit", (Class<?>[])emptyParameterList);
        purgeMethod.invoke((Object)renderKitFactory, emptyParameterList);
        RuntimeConfig.getCurrentInstance(this._externalContext).purge();
        LifecycleFactory lifecycleFactory = (LifecycleFactory)FactoryFinder.getFactory((String)"javax.faces.lifecycle.LifecycleFactory");
        purgeMethod = lifecycleFactory.getClass().getMethod("purgeLifecycle", (Class<?>[])emptyParameterList);
        purgeMethod.invoke((Object)lifecycleFactory, emptyParameterList);
    }

    public void configure() throws FacesException {
        try {
            this.feedStandardConfig();
            this.feedMetaInfServicesFactories();
            this.feedClassloaderConfigurations();
            this.feedContextSpecifiedConfig();
            this.feedWebAppConfig();
            if (log.isInfoEnabled()) {
                this.logMetaInf();
            }
        }
        catch (IOException e) {
            throw new FacesException((Throwable)e);
        }
        catch (SAXException e) {
            throw new FacesException((Throwable)e);
        }
        this.configureFactories();
        this.configureApplication();
        this.configureRenderKits();
        this.configureRuntimeConfig();
        this.configureLifecycle();
        this.handleSerialFactory();
        lastUpdate = System.currentTimeMillis();
    }

    private void feedStandardConfig() throws IOException, SAXException {
        InputStream stream = ClassUtils.getResourceAsStream(STANDARD_FACES_CONFIG_RESOURCE);
        if (stream == null) {
            throw new FacesException("Standard faces config META-INF/standard-faces-config.xml not found");
        }
        if (log.isInfoEnabled()) {
            log.info((Object)"Reading standard config META-INF/standard-faces-config.xml");
        }
        this.getDispenser().feed(this.getUnmarshaller().getFacesConfig(stream, STANDARD_FACES_CONFIG_RESOURCE));
        stream.close();
    }

    protected void logMetaInf() {
        try {
            ArrayList<VersionInfo> li = new ArrayList<VersionInfo>();
            li.add(new VersionInfo(MYFACES_API_PACKAGE_NAME));
            li.add(new VersionInfo(MYFACES_IMPL_PACKAGE_NAME));
            li.add(new VersionInfo(MYFACES_TOMAHAWK_SANDBOX15_PACKAGE_NAME));
            li.add(new VersionInfo(MYFACES_TOMAHAWK_SANDBOX_PACKAGE_NAME));
            li.add(new VersionInfo(MYFACES_TOMAHAWK_PACKAGE_NAME));
            Iterator it = ClassUtils.getResources("META-INF/MANIFEST.MF", this);
            while (it.hasNext()) {
                VersionInfo versionInfo;
                URL url = (URL)it.next();
                for (int i = 0; i < li.size() && !FacesConfigurator.checkJar(versionInfo = (VersionInfo)li.get(i), url); ++i) {
                }
            }
            for (int i = 0; i < li.size(); ++i) {
                VersionInfo versionInfo = (VersionInfo)li.get(i);
                if (versionInfo.getUsedVersion() != null) {
                    if (!log.isInfoEnabled()) continue;
                    log.info((Object)("Starting up MyFaces-package : " + versionInfo.getPackageName() + " in version : " + versionInfo.getUsedVersion() + " from path : " + versionInfo.getUsedVersionPath()));
                    continue;
                }
                if (!log.isInfoEnabled()) continue;
                log.info((Object)("MyFaces-package : " + versionInfo.getPackageName() + " not found."));
            }
        }
        catch (Throwable e) {
            throw new FacesException(e);
        }
    }

    private static boolean checkJar(VersionInfo versionInfo, URL path) {
        int index;
        String version = versionInfo.getLastVersion();
        String pathString = path.toString();
        if (!pathString.startsWith(JAR_PREFIX)) {
            return false;
        }
        if (pathString.length() <= META_INF_MANIFEST_SUFFIX.length() + JAR_PREFIX.length()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("PathString : " + pathString + " not long enough to be parsed."));
            }
            return false;
        }
        File file = new File(pathString = pathString.substring(JAR_PREFIX.length(), pathString.length() - META_INF_MANIFEST_SUFFIX.length()));
        String fileName = file.getName();
        if (fileName.endsWith(JAR_EXTENSION) && (index = fileName.indexOf(versionInfo.getPackageName())) != -1) {
            int beginIndex = index + versionInfo.getPackageName().length() + 1;
            if (beginIndex > fileName.length() - 1) {
                log.debug((Object)("beginIndex out of bounds. fileName: " + fileName));
                return false;
            }
            int endIndex = fileName.length() - JAR_EXTENSION.length();
            if (endIndex < 0 || endIndex <= beginIndex) {
                log.debug((Object)("endIndex out of bounds. fileName: " + fileName));
                return false;
            }
            String newVersion = fileName.substring(beginIndex, endIndex);
            if (version == null) {
                versionInfo.addJarInfo(pathString, newVersion);
            } else if (version.equals(newVersion)) {
                versionInfo.addJarInfo(pathString, version);
            } else {
                log.error((Object)("You are using the MyFaces-package : " + versionInfo.getPackageName() + " in different versions; first (and probably used) version is : " + versionInfo.getUsedVersion() + ", currently encountered version is : " + newVersion + ". This will cause undesired behaviour. Please clean out your class-path." + " The first encountered version is loaded from : " + versionInfo.getUsedVersionPath() + ". The currently encountered version is loaded from : " + path));
            }
            return true;
        }
        return false;
    }

    protected void feedMetaInfServicesFactories() {
        try {
            for (String factoryName : FACTORY_NAMES) {
                Iterator it = ClassUtils.getResources(META_INF_SERVICES_RESOURCE_PREFIX + factoryName, this);
                while (it.hasNext()) {
                    String className;
                    URL url = (URL)it.next();
                    InputStream stream = this.openStreamWithoutCache(url);
                    InputStreamReader isr = new InputStreamReader(stream);
                    BufferedReader br = new BufferedReader(isr);
                    try {
                        className = br.readLine();
                    }
                    catch (IOException e) {
                        throw new FacesException("Unable to read class name from file " + url.toExternalForm(), (Throwable)e);
                    }
                    br.close();
                    isr.close();
                    stream.close();
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Found " + factoryName + " factory implementation: " + className));
                    }
                    if (factoryName.equals("javax.faces.application.ApplicationFactory")) {
                        this.getDispenser().feedApplicationFactory(className);
                        continue;
                    }
                    if (factoryName.equals("javax.faces.context.FacesContextFactory")) {
                        this.getDispenser().feedFacesContextFactory(className);
                        continue;
                    }
                    if (factoryName.equals("javax.faces.lifecycle.LifecycleFactory")) {
                        this.getDispenser().feedLifecycleFactory(className);
                        continue;
                    }
                    if (factoryName.equals("javax.faces.render.RenderKitFactory")) {
                        this.getDispenser().feedRenderKitFactory(className);
                        continue;
                    }
                    throw new IllegalStateException("Unexpected factory name " + factoryName);
                }
            }
        }
        catch (Throwable e) {
            throw new FacesException(e);
        }
    }

    private InputStream openStreamWithoutCache(URL url) throws IOException {
        URLConnection connection = url.openConnection();
        connection.setUseCaches(false);
        return connection.getInputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void feedClassloaderConfigurations() {
        try {
            TreeMap<String, URL> facesConfigs = new TreeMap<String, URL>();
            Iterator it = ClassUtils.getResources(FACES_CONFIG_RESOURCE, this);
            while (it.hasNext()) {
                URL url = (URL)it.next();
                String systemId = url.toExternalForm();
                facesConfigs.put(systemId, url);
            }
            for (Map.Entry entry : facesConfigs.entrySet()) {
                InputStream stream = null;
                try {
                    this.openStreamWithoutCache((URL)entry.getValue());
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Reading config : " + (String)entry.getKey()));
                    }
                    this.getDispenser().feed(this.getUnmarshaller().getFacesConfig(stream, (String)entry.getKey()));
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
        }
        catch (Throwable e) {
            throw new FacesException(e);
        }
    }

    private void feedContextSpecifiedConfig() throws IOException, SAXException {
        List configFilesList = this.getConfigFilesList();
        for (int i = 0; i < configFilesList.size(); ++i) {
            String systemId = (String)configFilesList.get(i);
            InputStream stream = this._externalContext.getResourceAsStream(systemId);
            if (stream == null) {
                log.error((Object)("Faces config resource " + systemId + " not found"));
                continue;
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("Reading config " + systemId));
            }
            this.getDispenser().feed(this.getUnmarshaller().getFacesConfig(stream, systemId));
            stream.close();
        }
    }

    private List getConfigFilesList() {
        String configFiles = this._externalContext.getInitParameter("javax.faces.CONFIG_FILES");
        ArrayList<String> configFilesList = new ArrayList<String>();
        if (configFiles != null) {
            StringTokenizer st = new StringTokenizer(configFiles, ",", false);
            while (st.hasMoreTokens()) {
                String systemId = st.nextToken().trim();
                if (DEFAULT_FACES_CONFIG.equals(systemId)) {
                    if (!log.isWarnEnabled()) continue;
                    log.warn((Object)"/WEB-INF/faces-config.xml has been specified in the javax.faces.CONFIG_FILES context parameter of the deployment descriptor. This will automatically be removed, if we wouldn't do this, it would be loaded twice.  See JSF spec 1.1, 10.3.2");
                    continue;
                }
                configFilesList.add(systemId);
            }
        }
        return configFilesList;
    }

    private void feedWebAppConfig() throws IOException, SAXException {
        InputStream stream = this._externalContext.getResourceAsStream(DEFAULT_FACES_CONFIG);
        if (stream != null) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Reading config /WEB-INF/faces-config.xml");
            }
            this.getDispenser().feed(this.getUnmarshaller().getFacesConfig(stream, DEFAULT_FACES_CONFIG));
            stream.close();
        }
    }

    private void configureFactories() {
        FacesConfigDispenser dispenser = this.getDispenser();
        this.setFactories("javax.faces.application.ApplicationFactory", dispenser.getApplicationFactoryIterator(), DEFAULT_APPLICATION_FACTORY);
        this.setFactories("javax.faces.context.FacesContextFactory", dispenser.getFacesContextFactoryIterator(), DEFAULT_FACES_CONTEXT_FACTORY);
        this.setFactories("javax.faces.lifecycle.LifecycleFactory", dispenser.getLifecycleFactoryIterator(), DEFAULT_LIFECYCLE_FACTORY);
        this.setFactories("javax.faces.render.RenderKitFactory", dispenser.getRenderKitFactoryIterator(), DEFAULT_RENDER_KIT_FACTORY);
    }

    private void setFactories(String factoryName, Iterator factories, String defaultFactory) {
        FactoryFinder.setFactory((String)factoryName, (String)defaultFactory);
        while (factories.hasNext()) {
            String factory = (String)factories.next();
            if (factory.equals(defaultFactory)) continue;
            FactoryFinder.setFactory((String)factoryName, (String)factory);
        }
    }

    private void configureApplication() {
        Application application = ((ApplicationFactory)FactoryFinder.getFactory((String)"javax.faces.application.ApplicationFactory")).getApplication();
        FacesConfigDispenser dispenser = this.getDispenser();
        application.setActionListener((ActionListener)this.getApplicationObject(ActionListener.class, dispenser.getActionListenerIterator(), null));
        if (dispenser.getDefaultLocale() != null) {
            application.setDefaultLocale(LocaleUtils.toLocale(dispenser.getDefaultLocale()));
        }
        if (dispenser.getDefaultRenderKitId() != null) {
            application.setDefaultRenderKitId(dispenser.getDefaultRenderKitId());
        }
        if (dispenser.getMessageBundle() != null) {
            application.setMessageBundle(dispenser.getMessageBundle());
        }
        application.setNavigationHandler((NavigationHandler)this.getApplicationObject(NavigationHandler.class, dispenser.getNavigationHandlerIterator(), application.getNavigationHandler()));
        application.setStateManager((StateManager)this.getApplicationObject(StateManager.class, dispenser.getStateManagerIterator(), application.getStateManager()));
        ArrayList<Locale> locales = new ArrayList<Locale>();
        Iterator<String> it = dispenser.getSupportedLocalesIterator();
        while (it.hasNext()) {
            locales.add(LocaleUtils.toLocale(it.next()));
        }
        application.setSupportedLocales(locales);
        application.setViewHandler((ViewHandler)this.getApplicationObject(ViewHandler.class, dispenser.getViewHandlerIterator(), application.getViewHandler()));
        it = dispenser.getComponentTypes();
        while (it.hasNext()) {
            String componentType = it.next();
            application.addComponent(componentType, dispenser.getComponentClass(componentType));
        }
        it = dispenser.getConverterIds();
        while (it.hasNext()) {
            String converterId = it.next();
            application.addConverter(converterId, dispenser.getConverterClassById(converterId));
        }
        it = dispenser.getConverterClasses();
        while (it.hasNext()) {
            String converterClass = it.next();
            try {
                application.addConverter(ClassUtils.simpleClassForName(converterClass), dispenser.getConverterClassByClass(converterClass));
            }
            catch (Exception ex) {
                log.error((Object)"Converter could not be added. Reason:", (Throwable)ex);
            }
        }
        if (application instanceof ApplicationImpl) {
            it = dispenser.getConverterConfigurationByClassName();
            while (it.hasNext()) {
                String converterClassName = it.next();
                ((ApplicationImpl)application).addConverterConfiguration(converterClassName, dispenser.getConverterConfiguration(converterClassName));
            }
        }
        it = dispenser.getValidatorIds();
        while (it.hasNext()) {
            String validatorId = it.next();
            application.addValidator(validatorId, dispenser.getValidatorClass(validatorId));
        }
        RuntimeConfig runtimeConfig = this.getRuntimeConfig();
        runtimeConfig.setPropertyResolverChainHead((PropertyResolver)this.getApplicationObject(PropertyResolver.class, dispenser.getPropertyResolverIterator(), (Object)new DefaultPropertyResolver()));
        runtimeConfig.setVariableResolverChainHead((VariableResolver)this.getApplicationObject(VariableResolver.class, dispenser.getVariableResolverIterator(), (Object)new VariableResolverImpl()));
    }

    protected RuntimeConfig getRuntimeConfig() {
        if (this._runtimeConfig == null) {
            this._runtimeConfig = RuntimeConfig.getCurrentInstance(this._externalContext);
        }
        return this._runtimeConfig;
    }

    public void setRuntimeConfig(RuntimeConfig runtimeConfig) {
        this._runtimeConfig = runtimeConfig;
    }

    private Object getApplicationObject(Class interfaceClass, Iterator classNamesIterator, Object defaultObject) {
        Object current = defaultObject;
        while (classNamesIterator.hasNext()) {
            String implClassName = (String)classNamesIterator.next();
            Class implClass = ClassUtils.simpleClassForName(implClassName);
            if (!interfaceClass.isAssignableFrom(implClass)) {
                throw new IllegalArgumentException("Class " + implClassName + " is no " + interfaceClass.getName());
            }
            if (current == null) {
                current = ClassUtils.newInstance(implClass);
                continue;
            }
            try {
                Constructor delegationConstructor = implClass.getConstructor(interfaceClass);
                try {
                    current = delegationConstructor.newInstance(current);
                }
                catch (InstantiationException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    throw new FacesException((Throwable)e);
                }
                catch (IllegalAccessException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    throw new FacesException((Throwable)e);
                }
                catch (InvocationTargetException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    throw new FacesException((Throwable)e);
                }
            }
            catch (NoSuchMethodException e) {
                current = ClassUtils.newInstance(implClass);
            }
        }
        return current;
    }

    private void configureRuntimeConfig() {
        RuntimeConfig runtimeConfig = RuntimeConfig.getCurrentInstance(this._externalContext);
        FacesConfigDispenser dispenser = this.getDispenser();
        Iterator<Object> iterator = dispenser.getManagedBeans();
        while (iterator.hasNext()) {
            ManagedBean bean = iterator.next();
            if (log.isWarnEnabled() && runtimeConfig.getManagedBean(bean.getManagedBeanName()) != null) {
                log.warn((Object)("More than one managed bean w/ the name of '" + bean.getManagedBeanName() + "' - only keeping the last "));
            }
            runtimeConfig.addManagedBean(bean.getManagedBeanName(), bean);
        }
        this.removePurgedBeansFromSessionAndApplication(runtimeConfig);
        iterator = dispenser.getNavigationRules();
        while (iterator.hasNext()) {
            NavigationRule rule = (NavigationRule)iterator.next();
            runtimeConfig.addNavigationRule(rule);
        }
        Iterator<Object> iter = dispenser.getResourceBundles();
        while (iter.hasNext()) {
            runtimeConfig.addResourceBundle(iter.next());
        }
        iter = dispenser.getElResolvers();
        while (iter.hasNext()) {
            runtimeConfig.addFacesConfigElResolver((ELResolver)ClassUtils.newInstance((String)iter.next(), ELResolver.class));
        }
    }

    private void removePurgedBeansFromSessionAndApplication(RuntimeConfig runtimeConfig) {
        Map oldManagedBeans = runtimeConfig.getManagedBeansNotReaddedAfterPurge();
        if (oldManagedBeans != null) {
            for (Map.Entry entry : oldManagedBeans.entrySet()) {
                ManagedBean bean = (ManagedBean)entry.getValue();
                String scope = bean.getManagedBeanScope();
                if (scope != null && scope.equalsIgnoreCase("session")) {
                    this._externalContext.getSessionMap().remove(entry.getKey());
                    continue;
                }
                if (scope == null || !scope.equalsIgnoreCase("application")) continue;
                this._externalContext.getApplicationMap().remove(entry.getKey());
            }
        }
        runtimeConfig.resetManagedBeansNotReaddedAfterPurge();
    }

    private void configureRenderKits() {
        RenderKitFactory renderKitFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
        FacesConfigDispenser dispenser = this.getDispenser();
        Iterator<String> iterator = dispenser.getRenderKitIds();
        while (iterator.hasNext()) {
            String renderKitId = iterator.next();
            String renderKitClass = dispenser.getRenderKitClass(renderKitId);
            if (renderKitClass == null) {
                renderKitClass = DEFAULT_RENDER_KIT_CLASS;
            }
            RenderKit renderKit = (RenderKit)ClassUtils.newInstance(renderKitClass);
            Iterator<Renderer> renderers = dispenser.getRenderers(renderKitId);
            while (renderers.hasNext()) {
                javax.faces.render.Renderer renderer;
                Renderer element = renderers.next();
                try {
                    renderer = (javax.faces.render.Renderer)ClassUtils.newInstance(element.getRendererClass());
                }
                catch (Throwable e) {
                    log.error((Object)("failed to configure class " + element.getRendererClass()), e);
                    continue;
                }
                renderKit.addRenderer(element.getComponentFamily(), element.getRendererType(), renderer);
            }
            renderKitFactory.addRenderKit(renderKitId, renderKit);
        }
    }

    private void configureLifecycle() {
        LifecycleFactory lifecycleFactory = (LifecycleFactory)FactoryFinder.getFactory((String)"javax.faces.lifecycle.LifecycleFactory");
        Lifecycle lifecycle = lifecycleFactory.getLifecycle(this.getLifecycleId());
        Iterator<String> iterator = this.getDispenser().getLifecyclePhaseListeners();
        while (iterator.hasNext()) {
            String listenerClassName = iterator.next();
            try {
                lifecycle.addPhaseListener((PhaseListener)ClassUtils.newInstance(listenerClassName));
            }
            catch (ClassCastException e) {
                log.error((Object)("Class " + listenerClassName + " does not implement PhaseListener"));
            }
        }
    }

    private String getLifecycleId() {
        String id = this._externalContext.getInitParameter("javax.faces.LIFECYCLE_ID");
        if (id != null) {
            return id;
        }
        return "DEFAULT";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSerialFactory() {
        String serialProvider = this._externalContext.getInitParameter("org.apache.myfaces.SERIAL_FACTORY");
        SerialFactory serialFactory = null;
        if (serialProvider == null) {
            serialFactory = new DefaultSerialFactory();
        } else {
            try {
                serialFactory = (SerialFactory)ClassUtils.newInstance(serialProvider);
            }
            catch (ClassCastException e) {
                log.error((Object)("Make sure '" + serialProvider + "' implements the correct interface"), (Throwable)e);
            }
            catch (Exception e) {
                log.error((Object)e);
            }
            finally {
                if (serialFactory == null) {
                    serialFactory = new DefaultSerialFactory();
                    log.error((Object)"Using default serialization provider");
                }
            }
        }
        log.info((Object)("Serialization provider : " + serialFactory.getClass()));
        this._externalContext.getApplicationMap().put("org.apache.myfaces.SERIAL_FACTORY", serialFactory);
    }

    public static class JarInfo {
        private String url;
        private String version;

        public JarInfo(String url, String version) {
            this.url = url;
            this.version = version;
        }

        public String getVersion() {
            return this.version;
        }

        public String getUrl() {
            return this.url;
        }
    }

    public static class VersionInfo {
        private String packageName;
        private List<JarInfo> jarInfos;

        public VersionInfo(String packageName) {
            this.packageName = packageName;
        }

        public String getPackageName() {
            return this.packageName;
        }

        public void addJarInfo(String path, String version) {
            if (this.jarInfos == null) {
                this.jarInfos = new ArrayList<JarInfo>();
            }
            this.jarInfos.add(new JarInfo(path, version));
        }

        public String getLastVersion() {
            if (this.jarInfos == null) {
                return null;
            }
            if (this.jarInfos.size() == 0) {
                return null;
            }
            return this.jarInfos.get(this.jarInfos.size() - 1).getVersion();
        }

        public String getUsedVersion() {
            if (this.jarInfos == null) {
                return null;
            }
            if (this.jarInfos.size() == 0) {
                return null;
            }
            return this.jarInfos.get(0).getVersion();
        }

        public String getUsedVersionPath() {
            if (this.jarInfos == null) {
                return null;
            }
            if (this.jarInfos.size() == 0) {
                return null;
            }
            return this.jarInfos.get(0).getUrl();
        }
    }
}

