/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.context.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Principal;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.faces.FacesException;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.myfaces.context.ReleaseableExternalContext;
import org.apache.myfaces.context.servlet.ApplicationMap;
import org.apache.myfaces.context.servlet.CookieMap;
import org.apache.myfaces.context.servlet.InitParameterMap;
import org.apache.myfaces.context.servlet.RequestHeaderMap;
import org.apache.myfaces.context.servlet.RequestHeaderValuesMap;
import org.apache.myfaces.context.servlet.RequestMap;
import org.apache.myfaces.context.servlet.RequestParameterMap;
import org.apache.myfaces.context.servlet.RequestParameterValuesMap;
import org.apache.myfaces.context.servlet.SessionMap;
import org.apache.myfaces.util.EnumerationIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletExternalContextImpl
extends ExternalContext
implements ReleaseableExternalContext {
    private static final String INIT_PARAMETER_MAP_ATTRIBUTE = InitParameterMap.class.getName();
    private ServletContext _servletContext;
    private ServletRequest _servletRequest;
    private ServletResponse _servletResponse;
    private Map<String, Object> _applicationMap;
    private Map<String, Object> _sessionMap;
    private Map<String, Object> _requestMap;
    private Map<String, String> _requestParameterMap;
    private Map<String, String[]> _requestParameterValuesMap;
    private Map<String, String> _requestHeaderMap;
    private Map<String, String[]> _requestHeaderValuesMap;
    private Map _requestCookieMap;
    private Map<String, String> _initParameterMap;
    private HttpServletRequest _httpServletRequest;
    private String _requestServletPath;
    private String _requestPathInfo;

    public ServletExternalContextImpl(ServletContext servletContext, ServletRequest servletRequest, ServletResponse servletResponse) {
        this._servletContext = servletContext;
        this._servletRequest = servletRequest;
        this._servletResponse = servletResponse;
        this._applicationMap = null;
        this._sessionMap = null;
        this._requestMap = null;
        this._requestParameterMap = null;
        this._requestParameterValuesMap = null;
        this._requestHeaderMap = null;
        this._requestHeaderValuesMap = null;
        this._requestCookieMap = null;
        this._initParameterMap = null;
        HttpServletRequest httpServletRequest = this._httpServletRequest = this.isHttpServletRequest(servletRequest) ? (HttpServletRequest)servletRequest : null;
        if (this._httpServletRequest != null) {
            this._requestServletPath = this._httpServletRequest.getServletPath();
            this._requestPathInfo = this._httpServletRequest.getPathInfo();
        }
    }

    @Override
    public void release() {
        this._servletContext = null;
        this._servletRequest = null;
        this._servletResponse = null;
        this._applicationMap = null;
        this._sessionMap = null;
        this._requestMap = null;
        this._requestParameterMap = null;
        this._requestParameterValuesMap = null;
        this._requestHeaderMap = null;
        this._requestHeaderValuesMap = null;
        this._requestCookieMap = null;
        this._initParameterMap = null;
        this._httpServletRequest = null;
    }

    public Object getSession(boolean create) {
        this.checkHttpServletRequest();
        return ((HttpServletRequest)this._servletRequest).getSession(create);
    }

    public Object getContext() {
        return this._servletContext;
    }

    public Object getRequest() {
        return this._servletRequest;
    }

    public Object getResponse() {
        return this._servletResponse;
    }

    public String getResponseContentType() {
        return this._servletResponse.getContentType();
    }

    public Map<String, Object> getApplicationMap() {
        if (this._applicationMap == null) {
            this._applicationMap = new ApplicationMap(this._servletContext);
        }
        return this._applicationMap;
    }

    public Map<String, Object> getSessionMap() {
        if (this._sessionMap == null) {
            this.checkHttpServletRequest();
            this._sessionMap = new SessionMap(this._httpServletRequest);
        }
        return this._sessionMap;
    }

    public Map<String, Object> getRequestMap() {
        if (this._requestMap == null) {
            this._requestMap = new RequestMap(this._servletRequest);
        }
        return this._requestMap;
    }

    public Map<String, String> getRequestParameterMap() {
        if (this._requestParameterMap == null) {
            this._requestParameterMap = new RequestParameterMap(this._servletRequest);
        }
        return this._requestParameterMap;
    }

    public Map<String, String[]> getRequestParameterValuesMap() {
        if (this._requestParameterValuesMap == null) {
            this._requestParameterValuesMap = new RequestParameterValuesMap(this._servletRequest);
        }
        return this._requestParameterValuesMap;
    }

    public Iterator<String> getRequestParameterNames() {
        return new EnumerationIterator(this._servletRequest.getParameterNames());
    }

    public Map<String, String> getRequestHeaderMap() {
        if (this._requestHeaderMap == null) {
            this.checkHttpServletRequest();
            this._requestHeaderMap = new RequestHeaderMap(this._httpServletRequest);
        }
        return this._requestHeaderMap;
    }

    public Map<String, String[]> getRequestHeaderValuesMap() {
        if (this._requestHeaderValuesMap == null) {
            this.checkHttpServletRequest();
            this._requestHeaderValuesMap = new RequestHeaderValuesMap(this._httpServletRequest);
        }
        return this._requestHeaderValuesMap;
    }

    public Map<String, Object> getRequestCookieMap() {
        if (this._requestCookieMap == null) {
            this.checkHttpServletRequest();
            this._requestCookieMap = new CookieMap(this._httpServletRequest);
        }
        return this._requestCookieMap;
    }

    public Locale getRequestLocale() {
        return this._servletRequest.getLocale();
    }

    public String getRequestPathInfo() {
        this.checkHttpServletRequest();
        return this._requestPathInfo;
    }

    public String getRequestContentType() {
        return this._servletRequest.getContentType();
    }

    public String getRequestContextPath() {
        this.checkHttpServletRequest();
        return this._httpServletRequest.getContextPath();
    }

    public String getInitParameter(String s) {
        return this._servletContext.getInitParameter(s);
    }

    public Map<String, String> getInitParameterMap() {
        if (this._initParameterMap == null && (this._initParameterMap = (Map)this._servletContext.getAttribute(INIT_PARAMETER_MAP_ATTRIBUTE)) == null) {
            this._initParameterMap = new InitParameterMap(this._servletContext);
            this._servletContext.setAttribute(INIT_PARAMETER_MAP_ATTRIBUTE, this._initParameterMap);
        }
        return this._initParameterMap;
    }

    public Set<String> getResourcePaths(String path) {
        this.checkNull(path, "path");
        return this._servletContext.getResourcePaths(path);
    }

    public InputStream getResourceAsStream(String path) {
        this.checkNull(path, "path");
        return this._servletContext.getResourceAsStream(path);
    }

    public String encodeActionURL(String url) {
        this.checkNull(url, "url");
        this.checkHttpServletRequest();
        return ((HttpServletResponse)this._servletResponse).encodeURL(url);
    }

    public String encodeResourceURL(String url) {
        this.checkNull(url, "url");
        this.checkHttpServletRequest();
        return ((HttpServletResponse)this._servletResponse).encodeURL(url);
    }

    public String encodeNamespace(String s) {
        return s;
    }

    public void dispatch(String requestURI) throws IOException, FacesException {
        RequestDispatcher requestDispatcher = this._servletRequest.getRequestDispatcher(requestURI);
        if (requestDispatcher == null) {
            ((HttpServletResponse)this._servletResponse).sendError(404);
            return;
        }
        try {
            requestDispatcher.forward(this._servletRequest, this._servletResponse);
        }
        catch (ServletException e) {
            if (e.getMessage() != null) {
                throw new FacesException(e.getMessage(), (Throwable)e);
            }
            throw new FacesException((Throwable)e);
        }
    }

    public String getRequestServletPath() {
        this.checkHttpServletRequest();
        return this._requestServletPath;
    }

    public String getAuthType() {
        this.checkHttpServletRequest();
        return this._httpServletRequest.getAuthType();
    }

    public String getRemoteUser() {
        this.checkHttpServletRequest();
        return this._httpServletRequest.getRemoteUser();
    }

    public boolean isUserInRole(String role) {
        this.checkNull(role, "role");
        this.checkHttpServletRequest();
        return this._httpServletRequest.isUserInRole(role);
    }

    public Principal getUserPrincipal() {
        this.checkHttpServletRequest();
        return this._httpServletRequest.getUserPrincipal();
    }

    public void log(String message) {
        this.checkNull(message, "message");
        this._servletContext.log(message);
    }

    public void log(String message, Throwable exception) {
        this.checkNull(message, "message");
        this.checkNull(exception, "exception");
        this._servletContext.log(message, exception);
    }

    public void redirect(String url) throws IOException {
        if (!(this._servletResponse instanceof HttpServletResponse)) {
            throw new IllegalArgumentException("Only HttpServletResponse supported");
        }
        ((HttpServletResponse)this._servletResponse).sendRedirect(url);
        FacesContext.getCurrentInstance().responseComplete();
    }

    public Iterator<Locale> getRequestLocales() {
        this.checkHttpServletRequest();
        return new EnumerationIterator(this._httpServletRequest.getLocales());
    }

    public URL getResource(String path) throws MalformedURLException {
        this.checkNull(path, "path");
        return this._servletContext.getResource(path);
    }

    public void setRequest(Object request) {
        this._servletRequest = (ServletRequest)request;
        this._httpServletRequest = this.isHttpServletRequest(this._servletRequest) ? (HttpServletRequest)this._servletRequest : null;
        this._httpServletRequest = this.isHttpServletRequest(this._servletRequest) ? (HttpServletRequest)this._servletRequest : null;
    }

    public void setRequestCharacterEncoding(String encoding) throws UnsupportedEncodingException {
        this._servletRequest.setCharacterEncoding(encoding);
    }

    public String getRequestCharacterEncoding() {
        return this._servletRequest.getCharacterEncoding();
    }

    public String getResponseCharacterEncoding() {
        return this._servletResponse.getCharacterEncoding();
    }

    public void setResponse(Object response) {
        this._servletResponse = (ServletResponse)response;
    }

    public void setResponseCharacterEncoding(String encoding) {
        this._servletResponse.setCharacterEncoding(encoding);
    }

    private void checkNull(Object o, String param) {
        if (o == null) {
            throw new NullPointerException(param + " can not be null.");
        }
    }

    private void checkHttpServletRequest() {
        if (this._httpServletRequest == null) {
            throw new UnsupportedOperationException("Only HttpServletRequest supported");
        }
    }

    private boolean isHttpServletRequest(ServletRequest servletRequest) {
        return servletRequest instanceof HttpServletRequest;
    }
}

