/*
 * Decompiled with CFR 0.152.
 */
package de.jw.cloud42.core.service;

import com.xerox.amazonws.ec2.AvailabilityZone;
import com.xerox.amazonws.ec2.ConsoleOutput;
import com.xerox.amazonws.ec2.GroupDescription;
import com.xerox.amazonws.ec2.ImageDescription;
import com.xerox.amazonws.ec2.InstanceStateChangeDescription;
import com.xerox.amazonws.ec2.InstanceType;
import com.xerox.amazonws.ec2.Jec2;
import com.xerox.amazonws.ec2.KeyPairInfo;
import com.xerox.amazonws.ec2.LaunchConfiguration;
import com.xerox.amazonws.ec2.RegionInfo;
import com.xerox.amazonws.ec2.ReservationDescription;
import com.xerox.amazonws.ec2.TerminatingInstanceDescription;
import de.jw.cloud42.core.domain.Instance;
import de.jw.cloud42.core.service.Cloud42Functions;
import de.jw.cloud42.core.service.Cloud42Settings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Cloud42BaseFunctions
extends Cloud42Functions {
    public RegionInfo[] listRegions() {
        Jec2 ec2 = this.initConnection();
        List result = new ArrayList();
        try {
            result = ec2.describeRegions(new ArrayList());
            return result.toArray(new RegionInfo[0]);
        }
        catch (Exception ex) {
            Logger logger = Logger.getLogger(this.getClass().getName());
            logger.log(Level.SEVERE, "Listing regions failed: " + ex.getMessage());
            return null;
        }
    }

    public ImageDescription[] listImages(boolean all) {
        Jec2 ec2 = this.initConnection();
        List result = new ArrayList();
        try {
            if (all) {
                result = ec2.describeImages(new String[0]);
            } else {
                ArrayList<String> list = new ArrayList<String>();
                list.add(this.getCredentials().getUserID());
                result = ec2.describeImagesByOwner(list);
            }
            return result.toArray(new ImageDescription[0]);
        }
        catch (Exception ex) {
            Logger logger = Logger.getLogger(this.getClass().getName());
            logger.log(Level.SEVERE, "Listing images failed: " + ex.getMessage());
            return null;
        }
    }

    public ReservationDescription runInstance(String imageId, String[] groups, String keyName, byte[] userData, InstanceType instanceType, int count, String availabilityZone, String kernelId, String ramdiskId) {
        Jec2 ec2 = this.initConnection();
        List<String> groupList = Arrays.asList(groups);
        try {
            LaunchConfiguration l = new LaunchConfiguration(imageId);
            l.setAvailabilityZone(availabilityZone);
            l.setInstanceType(instanceType);
            l.setKernelId(kernelId);
            l.setKeyName(keyName);
            l.setMaxCount(count);
            l.setMinCount(count);
            l.setRamdiskId(ramdiskId);
            l.setSecurityGroup(groupList);
            l.setUserData(userData);
            ReservationDescription d = ec2.runInstances(l);
            return d;
        }
        catch (Exception ex) {
            Logger logger = Logger.getLogger(this.getClass().getName());
            logger.log(Level.SEVERE, "Starting instance failed: " + ex.getMessage());
            return null;
        }
    }

    public Instance[] runInstanceBlocking(String imageId, String[] groups, String keyName, byte[] userData, InstanceType instanceType, int count, String availabilityZone, String kernelId, String ramdiskId) {
        ReservationDescription d = this.runInstance(imageId, groups, keyName, userData, instanceType, count, availabilityZone, kernelId, ramdiskId);
        if (d == null) {
            return null;
        }
        ArrayList<Instance> result = new ArrayList<Instance>();
        for (ReservationDescription.Instance i : d.getInstances()) {
            Instance inst = this.describeInstance(i.getInstanceId());
            result.add(inst);
        }
        boolean started = false;
        while (!started) {
            try {
                Thread.sleep(2500L);
            }
            catch (Exception ex) {
                // empty catch block
            }
            started = true;
            for (int index = 0; index < result.size(); ++index) {
                Instance i = this.describeInstance(((Instance)result.get(index)).getInstanceId());
                result.set(index, i);
                if (i.getState().equals("running")) continue;
                started = false;
            }
        }
        try {
            Thread.sleep(15000L);
        }
        catch (Exception ex) {
            // empty catch block
        }
        return result.toArray(new Instance[0]);
    }

    public Instance describeInstance(String instanceId) {
        ArrayList<String> params = new ArrayList<String>();
        params.add(instanceId);
        Jec2 ec2 = this.initConnection();
        try {
            List result = ec2.describeInstances(params);
            if (result != null && result.size() == 1) {
                int index = 0;
                for (ReservationDescription.Instance i : ((ReservationDescription)result.get(0)).getInstances()) {
                    if (i.getInstanceId().equals(instanceId)) {
                        return new Instance((ReservationDescription)result.get(0), index);
                    }
                    ++index;
                }
            }
        }
        catch (Exception ex) {
            Logger logger = Logger.getLogger(this.getClass().getName());
            logger.log(Level.SEVERE, "Describing instance failed: " + ex.getMessage());
        }
        return null;
    }

    public InstanceStateChangeDescription stopInstance(String instanceId) {
        Jec2 ec2 = this.initConnection();
        try {
            return (InstanceStateChangeDescription)ec2.terminateInstances(new String[]{instanceId}).get(0);
        }
        catch (Exception ex) {
            Logger logger = Logger.getLogger(this.getClass().getName());
            logger.log(Level.SEVERE, "Terminating instance failed: " + ex.getMessage());
            return null;
        }
    }

    public TerminatingInstanceDescription[] stopAllInstances() {
        Instance[] list = this.listInstances();
        if (list == null || list.length == 0) {
            return null;
        }
        ArrayList<String> instanceIds = new ArrayList<String>();
        for (Instance i : list) {
            instanceIds.add(i.getInstanceId());
        }
        Jec2 ec2 = this.initConnection();
        try {
            return ec2.terminateInstances(instanceIds).toArray(new TerminatingInstanceDescription[0]);
        }
        catch (Exception ex) {
            Logger logger = Logger.getLogger(this.getClass().getName());
            logger.log(Level.SEVERE, "Terminating all instances failed: " + ex.getMessage());
            return null;
        }
    }

    public void rebootInstance(String instanceId) {
        Jec2 ec2 = this.initConnection();
        try {
            ec2.rebootInstances(new String[]{instanceId});
        }
        catch (Exception ex) {
            Logger logger = Logger.getLogger(this.getClass().getName());
            logger.log(Level.SEVERE, "Rebooting instance failed: " + ex.getMessage());
        }
    }

    public Instance[] listInstances() {
        ArrayList params = new ArrayList();
        Jec2 ec2 = this.initConnection();
        try {
            List instances = ec2.describeInstances(params);
            ArrayList<Instance> result = new ArrayList<Instance>();
            if (instances != null) {
                for (ReservationDescription d : instances) {
                    for (int index = 0; index < d.getInstances().size(); ++index) {
                        result.add(new Instance(d, index));
                    }
                }
                return result.toArray(new Instance[0]);
            }
        }
        catch (Exception ex) {
            Logger logger = Logger.getLogger(this.getClass().getName());
            logger.log(Level.SEVERE, "Listing instances failed: " + ex.getMessage());
        }
        return null;
    }

    public boolean createSecurityGroup(String name, String description) {
        Jec2 ec2 = this.initConnection();
        try {
            ec2.createSecurityGroup(name, description);
            return true;
        }
        catch (Exception ex) {
            Logger logger = Logger.getLogger(this.getClass().getName());
            logger.log(Level.SEVERE, "Creating security group failed: " + ex.getMessage());
            return false;
        }
    }

    public boolean deleteSecurityGroup(String name) {
        Jec2 ec2 = this.initConnection();
        try {
            ec2.deleteSecurityGroup(name);
            return true;
        }
        catch (Exception ex) {
            Logger logger = Logger.getLogger(this.getClass().getName());
            logger.log(Level.SEVERE, "Deleting security group failed: " + ex.getMessage());
            return false;
        }
    }

    public GroupDescription[] listSecurityGroups() {
        Jec2 ec2 = this.initConnection();
        try {
            return ec2.describeSecurityGroups(new ArrayList()).toArray(new GroupDescription[0]);
        }
        catch (Exception ex) {
            Logger logger = Logger.getLogger(this.getClass().getName());
            logger.log(Level.SEVERE, "Listing security groups failed: " + ex.getMessage());
            return null;
        }
    }

    public GroupDescription describeSecurityGroup(String name) {
        Jec2 ec2 = this.initConnection();
        try {
            return (GroupDescription)ec2.describeSecurityGroups(new String[]{name}).get(0);
        }
        catch (Exception ex) {
            Logger logger = Logger.getLogger(this.getClass().getName());
            logger.log(Level.SEVERE, "Describing security group failed: " + ex.getMessage());
            return null;
        }
    }

    public boolean addPermission(String groupname, String protocol, int portFrom, int portTo, String cidrIp) {
        Jec2 ec2 = this.initConnection();
        try {
            ec2.authorizeSecurityGroupIngress(groupname, protocol, portFrom, portTo, cidrIp);
            return true;
        }
        catch (Exception ex) {
            Logger logger = Logger.getLogger(this.getClass().getName());
            logger.log(Level.SEVERE, "Adding incoming permissions failed: " + ex.getMessage());
            return false;
        }
    }

    public boolean addPermission(String groupname, String secGroupName, String secGroupOwnerId) {
        Jec2 ec2 = this.initConnection();
        try {
            ec2.authorizeSecurityGroupIngress(groupname, secGroupName, secGroupOwnerId);
            return true;
        }
        catch (Exception ex) {
            Logger logger = Logger.getLogger(this.getClass().getName());
            logger.log(Level.SEVERE, "Adding incoming permissions for source 'group' failed: " + ex.getMessage());
            return false;
        }
    }

    public boolean removePermission(String groupname, String protocol, int portFrom, int portTo, String cidrIp) {
        Jec2 ec2 = this.initConnection();
        try {
            ec2.revokeSecurityGroupIngress(groupname, protocol, portFrom, portTo, cidrIp);
            return true;
        }
        catch (Exception ex) {
            Logger logger = Logger.getLogger(this.getClass().getName());
            logger.log(Level.SEVERE, "Revoking incoming permissions failed: " + ex.getMessage());
            return false;
        }
    }

    public boolean removePermission(String groupname, String secGroupName, String secGroupOwnerId) {
        Jec2 ec2 = this.initConnection();
        try {
            ec2.revokeSecurityGroupIngress(groupname, secGroupName, secGroupOwnerId);
            return true;
        }
        catch (Exception ex) {
            Logger logger = Logger.getLogger(this.getClass().getName());
            logger.log(Level.SEVERE, "Revoking group/owner permissions failed: " + ex.getMessage());
            return false;
        }
    }

    public String registerImage(String location) {
        Jec2 ec2 = this.initConnection();
        try {
            return ec2.registerImage(location);
        }
        catch (Exception ex) {
            Logger logger = Logger.getLogger(this.getClass().getName());
            logger.log(Level.SEVERE, "Registering image failed: " + ex.getMessage());
            return null;
        }
    }

    public boolean deregisterImage(String imageId) {
        Jec2 ec2 = this.initConnection();
        try {
            ec2.deregisterImage(imageId);
            return true;
        }
        catch (Exception ex) {
            Logger logger = Logger.getLogger(this.getClass().getName());
            logger.log(Level.SEVERE, "Deregistering image failed: " + ex.getMessage());
            return false;
        }
    }

    public KeyPairInfo createKeypair(String name) {
        Jec2 ec2 = this.initConnection();
        try {
            KeyPairInfo result = ec2.createKeyPair(name);
            return result;
        }
        catch (Exception ex) {
            Logger logger = Logger.getLogger(this.getClass().getName());
            logger.log(Level.SEVERE, "Creating keypair failed: " + ex.getMessage());
            return null;
        }
    }

    public boolean deleteKeypair(String name) {
        Jec2 ec2 = this.initConnection();
        try {
            ec2.deleteKeyPair(name);
            return true;
        }
        catch (Exception ex) {
            Logger logger = Logger.getLogger(this.getClass().getName());
            logger.log(Level.SEVERE, "Deleting keypair failed: " + ex.getMessage());
            return false;
        }
    }

    public KeyPairInfo[] listKeypairs() {
        Jec2 ec2 = this.initConnection();
        try {
            return ec2.describeKeyPairs(new String[0]).toArray(new KeyPairInfo[0]);
        }
        catch (Exception ex) {
            Logger logger = Logger.getLogger(this.getClass().getName());
            logger.log(Level.SEVERE, "Listing keypairs failed: " + ex.getMessage());
            return null;
        }
    }

    public KeyPairInfo describeKeypair(String name) {
        Jec2 ec2 = this.initConnection();
        try {
            return (KeyPairInfo)ec2.describeKeyPairs(new String[]{name}).get(0);
        }
        catch (Exception ex) {
            Logger logger = Logger.getLogger(this.getClass().getName());
            logger.log(Level.SEVERE, "Describing keypair failed: " + ex.getMessage());
            return null;
        }
    }

    public AvailabilityZone[] listAvailabilityZones() {
        Jec2 ec2 = this.initConnection();
        try {
            ArrayList l = new ArrayList();
            return ec2.describeAvailabilityZones(l).toArray(new AvailabilityZone[0]);
        }
        catch (Exception ex) {
            Logger logger = Logger.getLogger(this.getClass().getName());
            logger.log(Level.SEVERE, "Listing availability zones failed: " + ex.getMessage());
            return null;
        }
    }

    public ConsoleOutput getConsoleOutput(String instanceId) {
        Jec2 ec2 = this.initConnection();
        try {
            return ec2.getConsoleOutput(instanceId);
        }
        catch (Exception ex) {
            Logger logger = Logger.getLogger(this.getClass().getName());
            logger.log(Level.SEVERE, "Retrieving console output for instance " + instanceId + " failed: " + ex.getMessage());
            return null;
        }
    }

    private Jec2 initConnection() {
        try {
            Cloud42Settings config = Cloud42Settings.getInstance("config.properties");
            boolean isSecure = config.getBoolean("useHTTPS");
            Jec2 ec2 = new Jec2(this.getCredentials().getAwsAccessKeyId(), this.getCredentials().getSecretAccessKey(), isSecure, config.getString("server"), config.getInteger("port"));
            ec2.setResourcePrefix(config.getString("resourcePrefix"));
            ec2.setSignatureVersion(config.getInteger("signatureVersion"));
            if (this.getRegionUrl() != null && !this.getRegionUrl().equals("")) {
                ec2.setRegionUrl(this.getRegionUrl());
            }
            return ec2;
        }
        catch (Exception ex) {
            Logger.getAnonymousLogger().severe("Initializing configuration failed.");
            ex.printStackTrace();
            return null;
        }
    }
}

