/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.amazonws.common;

import com.xerox.amazonws.common.AWSError;
import com.xerox.amazonws.fps.FPSError;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AWSException
extends Exception {
    private String requestId;
    private List<? extends AWSError> errors;

    public AWSException(String s) {
        super(s);
    }

    public AWSException(String s, Throwable cause) {
        super(s, cause);
    }

    public AWSException(String s, String requestId) {
        this(s, requestId, null);
    }

    public AWSException(String s, String requestId, List<? extends AWSError> errors) {
        super(s);
        this.requestId = requestId;
        this.errors = errors;
    }

    protected AWSException(AWSException ex) {
        super(ex.getMessage(), ex.getCause());
        this.requestId = ex.getRequestId();
        this.errors = ex.getErrors();
    }

    public String getRequestId() {
        return this.requestId;
    }

    public List<? extends AWSError> getErrors() {
        return this.errors;
    }

    protected static String concatenateErrors(List<FPSError> errors) {
        StringBuffer buffer = new StringBuffer();
        for (FPSError error : errors) {
            buffer.append(error.getCode()).append(": ").append(error.getMessage()).append('.');
        }
        return buffer.toString();
    }
}

