/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.amazonws.common;

import java.io.CharArrayWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.AccessController;
import java.util.BitSet;
import sun.security.action.GetPropertyAction;

public class SignerEncoder {
    private static BitSet dontEncode;
    private static String defaultEncoding;

    public static String encode(String str) throws UnsupportedEncodingException {
        int lowerDiff = 32;
        StringBuffer ret = new StringBuffer(str.length());
        CharArrayWriter charsToEscape = new CharArrayWriter();
        try {
            for (int pos = 0; pos < str.length(); ++pos) {
                char chr = str.charAt(pos);
                if (dontEncode.get(chr)) {
                    ret.append(chr);
                    continue;
                }
                do {
                    char lower;
                    charsToEscape.write(chr);
                    if (chr < '\ud800' || chr > '\udbff' || pos >= str.length() - 1 || (lower = str.charAt(pos + 1)) < '\udc00' || lower > '\udfff') continue;
                    charsToEscape.write(lower);
                    ++pos;
                } while (++pos < str.length() && !dontEncode.get(chr = str.charAt(pos)));
                charsToEscape.flush();
                String tmp = new String(charsToEscape.toCharArray());
                byte[] bytes = tmp.getBytes("UTF-8");
                for (int i = 0; i < bytes.length; ++i) {
                    ret.append("%");
                    char ch = Character.forDigit(bytes[i] >> 4 & 0xF, 16);
                    if (Character.isLetter(ch)) {
                        ch = (char)(ch - lowerDiff);
                    }
                    ret.append(ch);
                    ch = Character.forDigit(bytes[i] & 0xF, 16);
                    if (Character.isLetter(ch)) {
                        ch = (char)(ch - lowerDiff);
                    }
                    ret.append(ch);
                }
                charsToEscape.reset();
            }
        }
        catch (UnsupportedEncodingException ex) {
            // empty catch block
        }
        return ret.toString();
    }

    public static void main(String[] args) throws Exception {
        String test1 = "abcdef ABCDEF -_.~";
        System.out.println("'" + test1 + "' signer encoded as '" + SignerEncoder.encode(test1) + "'");
        String test2 = "hi\u2022there?";
        System.out.println("'" + test2 + "' signer encoded as '" + SignerEncoder.encode(test2) + "'");
        System.out.println("'" + test2 + "' url encoded as '" + URLEncoder.encode(test2, "UTF-8") + "'");
    }

    static {
        int i;
        dontEncode = new BitSet(256);
        for (i = 97; i <= 122; ++i) {
            dontEncode.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            dontEncode.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            dontEncode.set(i);
        }
        dontEncode.set(45);
        dontEncode.set(95);
        dontEncode.set(46);
        dontEncode.set(126);
        defaultEncoding = AccessController.doPrivileged(new GetPropertyAction("file.encoding"));
    }
}

