/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.amazonws.common;

import java.io.IOException;
import java.net.InetAddress;
import org.apache.http.HttpConnection;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpInetConnection;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolException;
import org.apache.http.ProtocolVersion;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpProcessor;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.RequestTargetHost;
import org.apache.http.protocol.RequestUserAgent;

public class TypicaHttpClient
extends DefaultHttpClient {
    public TypicaHttpClient(ClientConnectionManager conman, HttpParams params) {
        super(conman, params);
    }

    protected BasicHttpProcessor createHttpProcessor() {
        BasicHttpProcessor httpProc = super.createHttpProcessor();
        httpProc.removeRequestInterceptorByClass(RequestTargetHost.class);
        httpProc.removeRequestInterceptorByClass(RequestUserAgent.class);
        httpProc.addInterceptor((HttpRequestInterceptor)new TypicaTargetHost());
        return httpProc;
    }

    class TypicaTargetHost
    implements HttpRequestInterceptor {
        public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
            if (request == null) {
                throw new IllegalArgumentException("HTTP request may not be null");
            }
            if (context == null) {
                throw new IllegalArgumentException("HTTP context may not be null");
            }
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            String method = request.getRequestLine().getMethod();
            if (method.equalsIgnoreCase("CONNECT") && ver.lessEquals((ProtocolVersion)HttpVersion.HTTP_1_0)) {
                return;
            }
            if (!request.containsHeader("Host")) {
                HttpHost targethost = (HttpHost)context.getAttribute("http.target_host");
                if (targethost == null) {
                    InetAddress address;
                    HttpConnection conn = (HttpConnection)context.getAttribute("http.connection");
                    if (conn instanceof HttpInetConnection && (address = ((HttpInetConnection)conn).getRemoteAddress()) != null) {
                        targethost = new HttpHost(address.getHostName());
                    }
                    if (targethost == null) {
                        if (ver.lessEquals((ProtocolVersion)HttpVersion.HTTP_1_0)) {
                            return;
                        }
                        throw new ProtocolException("Target host missing");
                    }
                }
                request.addHeader("Host", targethost.getHostName());
            }
        }
    }
}

