/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.amazonws.ec2;

import com.xerox.amazonws.ec2.BlockDeviceMapping;
import com.xerox.amazonws.ec2.InstanceType;
import com.xerox.amazonws.typica.jaxb.DescribeInstanceAttributeResponse;
import com.xerox.amazonws.typica.jaxb.InstanceBlockDeviceMappingResponseItemType;
import com.xerox.amazonws.typica.jaxb.InstanceBlockDeviceMappingResponseType;
import com.xerox.amazonws.typica.jaxb.NullableAttributeBooleanValueType;
import com.xerox.amazonws.typica.jaxb.NullableAttributeValueType;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescribeInstanceAttributeResult {
    private String requestId;
    private String instanceId;
    private InstanceType instanceType;
    private String kernelId;
    private String ramdiskId;
    private String userData;
    private boolean disableApiTermination;
    private String instanceInitiatedShutdownBehavior;
    private String rootDeviceName;
    private List<BlockDeviceMapping> blockDeviceMappings;

    public DescribeInstanceAttributeResult(String requestId, String instanceId) {
        this.requestId = requestId;
        this.instanceId = instanceId;
        this.blockDeviceMappings = new ArrayList<BlockDeviceMapping>();
    }

    DescribeInstanceAttributeResult(DescribeInstanceAttributeResponse response) {
        NullableAttributeBooleanValueType bool;
        this.requestId = response.getRequestId();
        this.instanceId = response.getInstanceId();
        NullableAttributeValueType val = response.getInstanceType();
        if (val != null) {
            this.instanceType = InstanceType.getTypeFromString(val.getValue());
        }
        if ((val = response.getKernel()) != null) {
            this.kernelId = val.getValue();
        }
        if ((val = response.getRamdisk()) != null) {
            this.ramdiskId = val.getValue();
        }
        if ((val = response.getUserData()) != null) {
            this.userData = val.getValue();
        }
        if ((bool = response.getDisableApiTermination()) != null) {
            this.disableApiTermination = bool.isValue();
        }
        if ((val = response.getInstanceInitiatedShutdownBehavior()) != null) {
            this.instanceInitiatedShutdownBehavior = val.getValue();
        }
        if ((val = response.getRootDeviceName()) != null) {
            this.rootDeviceName = val.getValue();
        }
        this.blockDeviceMappings = new ArrayList<BlockDeviceMapping>();
        InstanceBlockDeviceMappingResponseType bdmSet = response.getBlockDeviceMapping();
        if (bdmSet != null) {
            for (InstanceBlockDeviceMappingResponseItemType mapping : bdmSet.getItems()) {
            }
        }
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public InstanceType getInstanceType() {
        return this.instanceType;
    }

    public String getKernelId() {
        return this.kernelId;
    }

    public String getRamdiskId() {
        return this.ramdiskId;
    }

    public String getUserData() {
        return this.userData;
    }

    public boolean getDisableApiTermination() {
        return this.disableApiTermination;
    }

    public String getInstanceInitiatedShutdownBehavior() {
        return this.instanceInitiatedShutdownBehavior;
    }

    public String getRootDeviceName() {
        return this.rootDeviceName;
    }

    public List<BlockDeviceMapping> getBlockDeviceMappings() {
        return this.blockDeviceMappings;
    }
}

