/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.amazonws.ec2;

import com.xerox.amazonws.ec2.InstanceBlockDeviceMapping;
import com.xerox.amazonws.ec2.InstanceType;
import com.xerox.amazonws.typica.jaxb.EbsInstanceBlockDeviceMappingResponseType;
import com.xerox.amazonws.typica.jaxb.GroupItemType;
import com.xerox.amazonws.typica.jaxb.GroupSetType;
import com.xerox.amazonws.typica.jaxb.InstanceBlockDeviceMappingResponseItemType;
import com.xerox.amazonws.typica.jaxb.InstanceBlockDeviceMappingResponseType;
import com.xerox.amazonws.typica.jaxb.InstanceStateType;
import com.xerox.amazonws.typica.jaxb.ProductCodesSetItemType;
import com.xerox.amazonws.typica.jaxb.RunningInstancesItemType;
import com.xerox.amazonws.typica.jaxb.RunningInstancesSetType;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReservationDescription {
    private String requestId;
    private String owner;
    private String resId;
    private String requesterId;
    private List<Instance> instances = new ArrayList<Instance>();
    private List<String> groups = new ArrayList<String>();

    public ReservationDescription(String requestId, String owner, String resId, String requesterId) {
        this.requestId = requestId;
        this.owner = owner;
        this.resId = resId;
        this.requesterId = requesterId;
    }

    ReservationDescription(String requestId, String ownerId, String reservationId, String requesterId, GroupSetType groupSet, RunningInstancesSetType instSet) {
        this(requestId, ownerId, reservationId, requesterId);
        for (GroupItemType rsp_item : groupSet.getItems()) {
            this.groups.add(rsp_item.getGroupId());
        }
        for (RunningInstancesItemType rsp_item : instSet.getItems()) {
            this.instances.add(new Instance(rsp_item));
        }
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getReservationId() {
        return this.resId;
    }

    public String getRequesterId() {
        return this.requesterId;
    }

    public Instance addInstance(String imageId, String instanceId, String privateDnsName, String dnsName, InstanceStateType state, String reason, String keyName, String launchIndex, List<String> productCodes, Calendar launchTime, InstanceType instanceType, String availabilityZone, String kernelId, String ramdiskId, String platform, boolean monitoring, String subnetId, String privateIpAddress, String ipAddress, String architecture, String rootDeviceType, String rootDeviceName, List<InstanceBlockDeviceMapping> blockDeviceMapping, String instanceLifecycle, String spotInstanceRequestId, String vpcId, String virtualizationType) {
        Instance instance = new Instance(imageId, instanceId, privateDnsName, dnsName, state.getName(), "" + state.getCode(), reason, keyName, launchIndex, productCodes, instanceType, launchTime, availabilityZone, kernelId, ramdiskId, platform, monitoring, subnetId, privateIpAddress, ipAddress, architecture, rootDeviceType, rootDeviceName, blockDeviceMapping, instanceLifecycle, spotInstanceRequestId, vpcId, virtualizationType);
        this.instances.add(instance);
        return instance;
    }

    public List<Instance> getInstances() {
        return this.instances;
    }

    public String addGroup(String groupId) {
        this.groups.add(groupId);
        return groupId;
    }

    public List<String> getGroups() {
        return this.groups;
    }

    public String toString() {
        return "Reservation[id=" + this.resId + ", Loc=" + ", instances=" + this.instances + ", groups=" + this.groups + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Instance {
        private String imageId;
        private String instanceId;
        private String privateDnsName;
        private String dnsName;
        private String reason;
        private String keyName;
        private String launchIndex;
        private List<String> productCodes;
        private InstanceType instanceType;
        private Calendar launchTime;
        private String availabilityZone;
        private String kernelId;
        private String ramdiskId;
        private String platform;
        private String state;
        private String stateCode;
        private boolean monitoring;
        private String subnetId;
        private String vpcId;
        private String privateIpAddress;
        private String ipAddress;
        private String architecture;
        private String rootDeviceType;
        private String rootDeviceName;
        private List<InstanceBlockDeviceMapping> blockDeviceMapping;
        private String instanceLifecycle;
        private String spotInstanceRequestId;
        private String virtualizationType;

        public Instance(String imageId, String instanceId, String privateDnsName, String dnsName, String stateName, String stateCode, String reason, String keyName, String launchIndex, List<String> productCodes, InstanceType instanceType, Calendar launchTime, String availabilityZone, String kernelId, String ramdiskId, String platform, boolean monitoring, String subnetId, String privateIpAddress, String ipAddress, String architecture, String rootDeviceType, String rootDeviceName, List<InstanceBlockDeviceMapping> blockDeviceMapping, String instanceLifecycle, String spotInstanceRequestId, String vpcId, String virtualizationType) {
            this.imageId = imageId;
            this.instanceId = instanceId;
            this.privateDnsName = privateDnsName;
            this.dnsName = dnsName;
            this.state = stateName;
            this.stateCode = stateCode;
            this.reason = reason;
            this.keyName = keyName;
            this.launchIndex = launchIndex;
            this.productCodes = productCodes;
            this.instanceType = instanceType;
            this.launchTime = launchTime;
            this.availabilityZone = availabilityZone;
            this.kernelId = kernelId;
            this.ramdiskId = ramdiskId;
            this.platform = platform;
            this.monitoring = monitoring;
            this.subnetId = subnetId;
            this.vpcId = vpcId;
            this.privateIpAddress = privateIpAddress;
            this.ipAddress = ipAddress;
            this.architecture = architecture;
            this.rootDeviceType = rootDeviceType;
            this.rootDeviceName = rootDeviceName;
            this.blockDeviceMapping = blockDeviceMapping;
            this.instanceLifecycle = instanceLifecycle;
            this.spotInstanceRequestId = spotInstanceRequestId;
            this.virtualizationType = virtualizationType;
        }

        Instance(RunningInstancesItemType rsp_item) {
            List<InstanceBlockDeviceMappingResponseItemType> bdmSet;
            this.imageId = rsp_item.getImageId();
            this.instanceId = rsp_item.getInstanceId();
            this.privateDnsName = rsp_item.getPrivateDnsName();
            this.dnsName = rsp_item.getDnsName();
            this.state = rsp_item.getInstanceState().getName();
            this.stateCode = "" + rsp_item.getInstanceState().getCode();
            this.reason = rsp_item.getStateReason() != null ? rsp_item.getStateReason().getMessage() : "";
            this.keyName = rsp_item.getKeyName();
            this.launchIndex = rsp_item.getAmiLaunchIndex();
            ArrayList<String> codes = new ArrayList<String>();
            for (ProductCodesSetItemType type : rsp_item.getProductCodes().getItems()) {
                codes.add(type.getProductCode());
            }
            this.productCodes = codes;
            this.instanceType = InstanceType.getTypeFromString(rsp_item.getInstanceType());
            this.launchTime = rsp_item.getLaunchTime().toGregorianCalendar();
            this.availabilityZone = rsp_item.getPlacement().getAvailabilityZone();
            this.kernelId = rsp_item.getKernelId();
            this.ramdiskId = rsp_item.getRamdiskId();
            this.platform = rsp_item.getPlatform();
            this.monitoring = rsp_item.getMonitoring().getState().contains("enabled");
            this.subnetId = rsp_item.getSubnetId();
            this.vpcId = rsp_item.getVpcId();
            this.privateIpAddress = rsp_item.getPrivateIpAddress();
            this.ipAddress = rsp_item.getIpAddress();
            this.architecture = rsp_item.getArchitecture();
            this.rootDeviceType = rsp_item.getRootDeviceType();
            this.rootDeviceName = rsp_item.getRootDeviceName();
            this.blockDeviceMapping = new ArrayList<InstanceBlockDeviceMapping>();
            InstanceBlockDeviceMappingResponseType bdmType = rsp_item.getBlockDeviceMapping();
            if (bdmType != null && (bdmSet = bdmType.getItems()) != null) {
                for (InstanceBlockDeviceMappingResponseItemType mapping : bdmSet) {
                    EbsInstanceBlockDeviceMappingResponseType ebs = mapping.getEbs();
                    this.blockDeviceMapping.add(new InstanceBlockDeviceMapping(mapping.getDeviceName(), ebs.getVolumeId(), ebs.getStatus(), ebs.getAttachTime().toGregorianCalendar(), ebs.isDeleteOnTermination()));
                }
            }
            this.instanceLifecycle = rsp_item.getInstanceLifecycle();
            this.spotInstanceRequestId = rsp_item.getSpotInstanceRequestId();
            this.virtualizationType = rsp_item.getVirtualizationType();
        }

        public String getImageId() {
            return this.imageId;
        }

        public String getInstanceId() {
            return this.instanceId;
        }

        public String getPrivateDnsName() {
            return this.privateDnsName;
        }

        public String getDnsName() {
            return this.dnsName;
        }

        public String getReason() {
            return this.reason;
        }

        public String getKeyName() {
            return this.keyName;
        }

        public String getLaunchIndex() {
            return this.launchIndex;
        }

        public List<String> getProductCodes() {
            return this.productCodes;
        }

        public String getState() {
            return this.state;
        }

        public boolean isRunning() {
            return this.state.equals("running");
        }

        public boolean isPending() {
            return this.state.equals("pending");
        }

        public boolean isShuttingDown() {
            return this.state.equals("shutting-down");
        }

        public boolean isTerminated() {
            return this.state.equals("terminated");
        }

        public String getStateCode() {
            return this.stateCode;
        }

        public InstanceType getInstanceType() {
            return this.instanceType;
        }

        public Calendar getLaunchTime() {
            return this.launchTime;
        }

        public String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public String getKernelId() {
            return this.kernelId;
        }

        public String getRamdiskId() {
            return this.ramdiskId;
        }

        public String getPlatform() {
            return this.platform;
        }

        public boolean isMonitoring() {
            return this.monitoring;
        }

        public String getSubnetId() {
            return this.subnetId;
        }

        public String getVpcId() {
            return this.vpcId;
        }

        public String getPrivateIpAddress() {
            return this.privateIpAddress;
        }

        public String getIpAddress() {
            return this.ipAddress;
        }

        public String getArchitecture() {
            return this.architecture;
        }

        public String getRootDeviceType() {
            return this.rootDeviceType;
        }

        public String getRootDeviceName() {
            return this.rootDeviceName;
        }

        public List<InstanceBlockDeviceMapping> getBlockDeviceMappings() {
            return this.blockDeviceMapping;
        }

        public String getInstanceLifecycle() {
            return this.instanceLifecycle;
        }

        public String getSpotInstanceRequestId() {
            return this.spotInstanceRequestId;
        }

        public String getVirtualizationType() {
            return this.virtualizationType;
        }

        public String toString() {
            return "[img=" + this.imageId + ", instance=" + this.instanceId + ", privateDns=" + this.privateDnsName + ", dns=" + this.dnsName + ", loc=" + this.availabilityZone + ", state=" + this.state + "(" + this.stateCode + ") reason=" + this.reason + ", monitoring=" + this.monitoring + ", subnetId=" + this.subnetId + "]";
        }
    }
}

