/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.amazonws.fps;

import com.xerox.amazonws.fps.Amount;
import com.xerox.amazonws.fps.FPSOperation;
import com.xerox.amazonws.fps.PaymentMethod;
import java.io.Serializable;
import java.util.Date;

public class Transaction
implements Serializable {
    private final String transactionID;
    private final Status status;
    private final String detail;
    private final Date dateReceived;
    private final Date dateCompleted;
    private final Amount transactionAmount;
    private final FPSOperation operation;
    private final PaymentMethod paymentMethod;
    private final String senderName;
    private final String callerName;
    private final String recipientName;
    private final Amount fees;
    private final Amount balance;
    private final String callerTokenId;
    private final String senderTokenId;
    private final String recipientTokenId;

    public Transaction(String transactionID, Status status, String detail) {
        this.transactionID = transactionID;
        this.status = status;
        this.detail = detail;
        this.dateReceived = null;
        this.dateCompleted = null;
        this.transactionAmount = null;
        this.operation = null;
        this.paymentMethod = null;
        this.senderName = null;
        this.callerName = null;
        this.recipientName = null;
        this.fees = null;
        this.balance = null;
        this.callerTokenId = null;
        this.senderTokenId = null;
        this.recipientTokenId = null;
    }

    public Transaction(String transactionID, Status status, Date dateReceived, Date dateCompleted, Amount transactionAmount, FPSOperation operation, PaymentMethod paymentMethod, String senderName, String callerName, String recipientName, Amount fees, Amount balance, String callerTokenId, String senderTokenId, String recipientTokenId) {
        this.transactionID = transactionID;
        this.status = status;
        this.detail = null;
        this.dateReceived = dateReceived;
        this.dateCompleted = dateCompleted;
        this.transactionAmount = transactionAmount;
        this.operation = operation;
        this.paymentMethod = paymentMethod;
        this.senderName = senderName;
        this.callerName = callerName;
        this.recipientName = recipientName;
        this.fees = fees;
        this.balance = balance;
        this.callerTokenId = callerTokenId;
        this.senderTokenId = senderTokenId;
        this.recipientTokenId = recipientTokenId;
    }

    public String getTransactionID() {
        return this.transactionID;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getDetail() {
        return this.detail;
    }

    public Date getDateReceived() {
        return this.dateReceived;
    }

    public Date getDateCompleted() {
        return this.dateCompleted;
    }

    public Amount getTransactionAmount() {
        return this.transactionAmount;
    }

    public FPSOperation getOperation() {
        return this.operation;
    }

    public PaymentMethod getPaymentMethod() {
        return this.paymentMethod;
    }

    public String getSenderName() {
        return this.senderName;
    }

    public String getCallerName() {
        return this.callerName;
    }

    public String getRecipientName() {
        return this.recipientName;
    }

    public Amount getFees() {
        return this.fees;
    }

    public Amount getBalance() {
        return this.balance;
    }

    public String getCallerTokenId() {
        return this.callerTokenId;
    }

    public String getSenderTokenId() {
        return this.senderTokenId;
    }

    public String getRecipientTokenId() {
        return this.recipientTokenId;
    }

    public String toString() {
        return "Transaction{transactionID='" + this.transactionID + '\'' + ", status=" + this.status + ", detail='" + this.detail + '\'' + ", dateReceived=" + this.dateReceived + ", dateCompleted=" + this.dateCompleted + ", transactionAmount=" + this.transactionAmount + ", operation=" + this.operation + ", paymentMethod=" + (Object)((Object)this.paymentMethod) + ", senderName='" + this.senderName + '\'' + ", callerName='" + this.callerName + '\'' + ", recipientName='" + this.recipientName + '\'' + ", fees=" + this.fees + ", balance=" + this.balance + ", callerTokenId='" + this.callerTokenId + '\'' + ", senderTokenId='" + this.senderTokenId + '\'' + ", recipientTokenId='" + this.recipientTokenId + '\'' + '}';
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status implements Serializable
    {
        RESERVED("Reserved"),
        SUCCESS("Success"),
        FAILURE("Failure"),
        INITIATED("Initiated"),
        REINITIATED("Reinitiated"),
        TEMPORARY_DECLINE("TemporaryDecline");

        private final String value;

        private Status(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public static Status fromValue(String v) {
            for (Status c : Status.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }
    }
}

