/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.amazonws.sdb;

import com.xerox.amazonws.common.AWSException;
import com.xerox.amazonws.common.AWSQueryConnection;
import com.xerox.amazonws.sdb.Condition;
import com.xerox.amazonws.sdb.DomainMetadataResult;
import com.xerox.amazonws.sdb.Item;
import com.xerox.amazonws.sdb.ItemAttribute;
import com.xerox.amazonws.sdb.QueryWithAttributesResult;
import com.xerox.amazonws.sdb.SDBException;
import com.xerox.amazonws.sdb.SDBResult;
import com.xerox.amazonws.sdb.SimpleDB;
import com.xerox.amazonws.typica.sdb.jaxb.Attribute;
import com.xerox.amazonws.typica.sdb.jaxb.BatchPutAttributesResponse;
import com.xerox.amazonws.typica.sdb.jaxb.DomainMetadataResponse;
import com.xerox.amazonws.typica.sdb.jaxb.SelectResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.xml.bind.JAXBException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Domain
extends AWSQueryConnection {
    private static Log logger = LogFactory.getLog(Domain.class);
    private String domainName;
    private int maxThreads = 30;
    private ThreadPoolExecutor executor;

    protected Domain(String domainName, String awsAccessId, String awsSecretKey, boolean isSecure, String server, int port) throws SDBException {
        super(awsAccessId, awsSecretKey, isSecure, server, port);
        this.domainName = domainName;
        SimpleDB.setVersionHeader(this);
    }

    public String getName() {
        return this.domainName;
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    public void setMaxThreads(int threads) {
        this.maxThreads = threads;
    }

    public Item getItem(String identifier) throws SDBException {
        Item ret = new Item(identifier, this.domainName, this.getAwsAccessKeyId(), this.getSecretAccessKey(), this.isSecure(), this.getPort(), this.getServer());
        ret.setSignatureVersion(this.getSignatureVersion());
        ret.setHttpClient(this.getHttpClient());
        return ret;
    }

    public void deleteItem(String identifier) throws SDBException {
        this.getItem(identifier).deleteAttributes(null);
    }

    public void deleteItem(String identifier, List<Condition> conditions) throws SDBException {
        this.getItem(identifier).deleteAttributes(null, conditions);
    }

    public DomainMetadataResult getMetadata() throws SDBException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("DomainName", this.domainName);
        HttpGet method = new HttpGet();
        DomainMetadataResponse response = this.makeRequestInt((HttpRequestBase)method, "DomainMetadata", params, DomainMetadataResponse.class);
        return new DomainMetadataResult(response.getResponseMetadata().getRequestId(), response.getResponseMetadata().getBoxUsage(), Integer.parseInt(response.getDomainMetadataResult().getItemCount()), Integer.parseInt(response.getDomainMetadataResult().getAttributeValueCount()), Integer.parseInt(response.getDomainMetadataResult().getAttributeNameCount()), Long.parseLong(response.getDomainMetadataResult().getItemNamesSizeBytes()), Long.parseLong(response.getDomainMetadataResult().getAttributeValuesSizeBytes()), Long.parseLong(response.getDomainMetadataResult().getAttributeNamesSizeBytes()), new Date(Long.parseLong(response.getDomainMetadataResult().getTimestamp()) * 1000L));
    }

    public QueryWithAttributesResult selectItems(String selectExpression, String nextToken) throws SDBException {
        return this.selectItems(selectExpression, nextToken, false);
    }

    public QueryWithAttributesResult selectItems(String selectExpression, String nextToken, boolean consistent) throws SDBException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("SelectExpression", selectExpression);
        if (nextToken != null) {
            params.put("NextToken", nextToken);
        }
        if (consistent) {
            params.put("ConsistentRead", "true");
        }
        HttpGet method = new HttpGet();
        SelectResponse response = this.makeRequestInt((HttpRequestBase)method, "Select", params, SelectResponse.class);
        LinkedHashMap<String, List<ItemAttribute>> results = new LinkedHashMap<String, List<ItemAttribute>>();
        for (com.xerox.amazonws.typica.sdb.jaxb.Item i : response.getSelectResult().getItems()) {
            ArrayList<ItemAttribute> attrs = new ArrayList<ItemAttribute>();
            for (Attribute a : i.getAttributes()) {
                attrs.add(this.createAttribute(a));
            }
            String iName = i.getName().getValue();
            String encoding = i.getName().getEncoding();
            if (encoding != null && encoding.equals("base64")) {
                iName = new String(Base64.decodeBase64((byte[])iName.getBytes()));
            }
            results.put(iName, attrs);
        }
        return new QueryWithAttributesResult(response.getSelectResult().getNextToken(), response.getResponseMetadata().getRequestId(), response.getResponseMetadata().getBoxUsage(), results);
    }

    public SDBResult batchPutAttributes(Map<String, List<ItemAttribute>> items) throws SDBException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("DomainName", this.domainName);
        int k = 1;
        for (String item : items.keySet()) {
            params.put("Item." + k + ".ItemName", item);
            int i = 1;
            for (ItemAttribute attr : items.get(item)) {
                String val = attr.getValue();
                if (val == null) continue;
                params.put("Item." + k + ".Attribute." + i + ".Name", attr.getName());
                params.put("Item." + k + ".Attribute." + i + ".Value", val);
                if (attr.isReplace()) {
                    params.put("Item." + k + ".Attribute." + i + ".Replace", "true");
                }
                ++i;
            }
            ++k;
        }
        HttpPost method = new HttpPost();
        BatchPutAttributesResponse response = this.makeRequestInt((HttpRequestBase)method, "BatchPutAttributes", params, BatchPutAttributesResponse.class);
        return new SDBResult(null, response.getResponseMetadata().getRequestId(), response.getResponseMetadata().getBoxUsage());
    }

    static List<Domain> createList(String[] domainNames, String awsAccessKeyId, String awsSecretAccessKey, boolean isSecure, String server, int port, int signatureVersion, HttpClient hc) throws SDBException {
        ArrayList<Domain> ret = new ArrayList<Domain>();
        for (int i = 0; i < domainNames.length; ++i) {
            Domain dom = new Domain(domainNames[i], awsAccessKeyId, awsSecretAccessKey, isSecure, server, port);
            dom.setSignatureVersion(signatureVersion);
            dom.setHttpClient(hc);
            ret.add(dom);
        }
        return ret;
    }

    public ThreadPoolExecutor getThreadPoolExecutor() {
        if (this.executor != null) {
            return this.executor;
        }
        return new ThreadPoolExecutor(this.maxThreads, this.maxThreads, 5L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(this.maxThreads));
    }

    public void setThreadPoolExecutor(ThreadPoolExecutor executor) {
        this.executor = executor;
    }

    protected <T> T makeRequestInt(HttpRequestBase method, String action, Map<String, String> params, Class<T> respType) throws SDBException {
        try {
            return this.makeRequest(method, action, params, respType);
        }
        catch (AWSException ex) {
            throw new SDBException(ex);
        }
        catch (JAXBException ex) {
            throw new SDBException("Problem parsing returned message.", (Exception)((Object)ex));
        }
        catch (SAXException ex) {
            throw new SDBException("Problem parsing returned message.", ex);
        }
        catch (HttpException ex) {
            throw new SDBException(ex.getMessage(), (Exception)((Object)ex));
        }
        catch (IOException ex) {
            throw new SDBException(ex.getMessage(), ex);
        }
    }

    private ItemAttribute createAttribute(Attribute a) {
        String name = a.getName().getValue();
        String encoding = a.getName().getEncoding();
        if (encoding != null && encoding.equals("base64")) {
            name = new String(Base64.decodeBase64((byte[])name.getBytes()));
        }
        String value = a.getValue().getValue();
        encoding = a.getValue().getEncoding();
        if (encoding != null && encoding.equals("base64")) {
            value = new String(Base64.decodeBase64((byte[])value.getBytes()));
        }
        return new ItemAttribute(name, value, false);
    }

    protected class RejectionHandler
    implements RejectedExecutionHandler {
        protected RejectionHandler() {
        }

        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            r.run();
        }
    }
}

