/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.amazonws.sdb;

import com.xerox.amazonws.common.AWSException;
import com.xerox.amazonws.common.AWSQueryConnection;
import com.xerox.amazonws.sdb.Condition;
import com.xerox.amazonws.sdb.ItemAttribute;
import com.xerox.amazonws.sdb.SDBException;
import com.xerox.amazonws.sdb.SDBResult;
import com.xerox.amazonws.sdb.SimpleDB;
import com.xerox.amazonws.typica.sdb.jaxb.Attribute;
import com.xerox.amazonws.typica.sdb.jaxb.DeleteAttributesResponse;
import com.xerox.amazonws.typica.sdb.jaxb.GetAttributesResponse;
import com.xerox.amazonws.typica.sdb.jaxb.PutAttributesResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Item
extends AWSQueryConnection {
    private static Log logger = LogFactory.getLog(Item.class);
    private String domainName;
    private String identifier;

    protected Item(String identifier, String domainName, String awsAccessId, String awsSecretKey, boolean isSecure, int port, String server) throws SDBException {
        super(awsAccessId, awsSecretKey, isSecure, server, port);
        this.domainName = domainName;
        this.identifier = identifier;
        SimpleDB.setVersionHeader(this);
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public List<ItemAttribute> getAttributes() throws SDBException {
        return this.getAttributes((String)null);
    }

    public List<ItemAttribute> getAttributes(String attributeName) throws SDBException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("DomainName", this.domainName);
        params.put("ItemName", this.identifier);
        if (attributeName != null) {
            params.put("AttributeName.1", attributeName);
        }
        HttpGet method = new HttpGet();
        try {
            GetAttributesResponse response = this.makeRequestInt((HttpRequestBase)method, "GetAttributes", params, GetAttributesResponse.class);
            ArrayList<ItemAttribute> ret = new ArrayList<ItemAttribute>();
            List<Attribute> attrs = response.getGetAttributesResult().getAttributes();
            for (Attribute attr : attrs) {
                ret.add(this.createAttribute(attr));
            }
            return ret;
        }
        catch (UnsupportedEncodingException ex) {
            throw new SDBException(ex.getMessage(), ex);
        }
    }

    public List<ItemAttribute> getAttributes(List<String> attributes) throws SDBException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("DomainName", this.domainName);
        params.put("ItemName", this.identifier);
        int idx = 1;
        if (attributes != null) {
            for (String attr : attributes) {
                params.put("AttributeName." + idx, attr);
                ++idx;
            }
        }
        HttpGet method = new HttpGet();
        try {
            GetAttributesResponse response = this.makeRequestInt((HttpRequestBase)method, "GetAttributes", params, GetAttributesResponse.class);
            ArrayList<ItemAttribute> ret = new ArrayList<ItemAttribute>();
            List<Attribute> attrs = response.getGetAttributesResult().getAttributes();
            for (Attribute attr : attrs) {
                ret.add(this.createAttribute(attr));
            }
            return ret;
        }
        catch (UnsupportedEncodingException ex) {
            throw new SDBException(ex.getMessage(), ex);
        }
    }

    public Map<String, List<String>> getAttributesMap(List<String> attributes) throws SDBException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("DomainName", this.domainName);
        params.put("ItemName", this.identifier);
        int idx = 1;
        if (attributes != null) {
            for (String attr : attributes) {
                params.put("AttributeName." + idx, attr);
                ++idx;
            }
        }
        HttpGet method = new HttpGet();
        try {
            GetAttributesResponse response = this.makeRequestInt((HttpRequestBase)method, "GetAttributes", params, GetAttributesResponse.class);
            HashMap<String, List<String>> ret = new HashMap<String, List<String>>();
            List<Attribute> attrs = response.getGetAttributesResult().getAttributes();
            for (Attribute attr : attrs) {
                ArrayList<String> vals;
                String name = attr.getName().getValue();
                String encoding = attr.getName().getEncoding();
                if (encoding != null && encoding.equals("base64")) {
                    name = new String(Base64.decodeBase64((byte[])name.getBytes()), "UTF-8");
                }
                if ((vals = (ArrayList<String>)ret.get(name)) == null) {
                    vals = new ArrayList<String>();
                    ret.put(name, vals);
                }
                String value = attr.getValue().getValue();
                encoding = attr.getValue().getEncoding();
                if (encoding != null && encoding.equals("base64")) {
                    value = new String(Base64.decodeBase64((byte[])value.getBytes()), "UTF-8");
                }
                vals.add(value);
            }
            return ret;
        }
        catch (UnsupportedEncodingException ex) {
            throw new SDBException(ex.getMessage(), ex);
        }
    }

    public SDBResult putAttributes(List<ItemAttribute> attributes) throws SDBException {
        return this.putAttributes(attributes, null);
    }

    public SDBResult putAttributes(List<ItemAttribute> attributes, List<Condition> conditions) throws SDBException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("DomainName", this.domainName);
        params.put("ItemName", this.identifier);
        int i = 1;
        for (ItemAttribute attr : attributes) {
            String val = attr.getValue();
            if (val == null) continue;
            params.put("Attribute." + i + ".Name", attr.getName());
            params.put("Attribute." + i + ".Value", val);
            if (attr.isReplace()) {
                params.put("Attribute." + i + ".Replace", "true");
            }
            ++i;
        }
        if (conditions != null) {
            i = 1;
            for (Condition cond : conditions) {
                params.put("Expected." + i + ".Name", cond.getName());
                String value = cond.getValue();
                if (value != null) {
                    params.put("Expected." + i + ".Value", value);
                } else {
                    params.put("Expected." + i + ".Exists", cond.isExists() ? "true" : "false");
                }
                ++i;
            }
        }
        HttpGet method = new HttpGet();
        PutAttributesResponse response = this.makeRequestInt((HttpRequestBase)method, "PutAttributes", params, PutAttributesResponse.class);
        return new SDBResult(null, response.getResponseMetadata().getRequestId(), response.getResponseMetadata().getBoxUsage());
    }

    public SDBResult deleteAttributes(List<ItemAttribute> attributes) throws SDBException {
        return this.deleteAttributes(attributes, null);
    }

    public SDBResult deleteAttributes(List<ItemAttribute> attributes, List<Condition> conditions) throws SDBException {
        String value;
        int i;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("DomainName", this.domainName);
        params.put("ItemName", this.identifier);
        if (attributes != null) {
            i = 1;
            for (ItemAttribute attr : attributes) {
                params.put("Attribute." + i + ".Name", attr.getName());
                value = attr.getValue();
                if (value != null) {
                    params.put("Attribute." + i + ".Value", value);
                }
                ++i;
            }
        }
        if (conditions != null) {
            i = 1;
            for (Condition cond : conditions) {
                params.put("Expected." + i + ".Name", cond.getName());
                value = cond.getValue();
                if (value != null) {
                    params.put("Expected." + i + ".Value", value);
                } else {
                    params.put("Expected." + i + ".Exists", cond.isExists() ? "true" : "false");
                }
                ++i;
            }
        }
        HttpGet method = new HttpGet();
        DeleteAttributesResponse response = this.makeRequestInt((HttpRequestBase)method, "DeleteAttributes", params, DeleteAttributesResponse.class);
        return new SDBResult(null, response.getResponseMetadata().getRequestId(), response.getResponseMetadata().getBoxUsage());
    }

    protected <T> T makeRequestInt(HttpRequestBase method, String action, Map<String, String> params, Class<T> respType) throws SDBException {
        try {
            return this.makeRequest(method, action, params, respType);
        }
        catch (AWSException ex) {
            throw new SDBException(ex);
        }
        catch (JAXBException ex) {
            throw new SDBException("Problem parsing returned message.", (Exception)((Object)ex));
        }
        catch (SAXException ex) {
            throw new SDBException("Problem parsing returned message.", ex);
        }
        catch (HttpException ex) {
            throw new SDBException(ex.getMessage(), (Exception)((Object)ex));
        }
        catch (IOException ex) {
            throw new SDBException(ex.getMessage(), ex);
        }
    }

    private ItemAttribute createAttribute(Attribute a) throws UnsupportedEncodingException {
        String name = a.getName().getValue();
        String encoding = a.getName().getEncoding();
        if (encoding != null && encoding.equals("base64")) {
            name = new String(Base64.decodeBase64((byte[])name.getBytes()), "UTF-8");
        }
        String value = a.getValue().getValue();
        encoding = a.getValue().getEncoding();
        if (encoding != null && encoding.equals("base64")) {
            value = new String(Base64.decodeBase64((byte[])value.getBytes()), "UTF-8");
        }
        return new ItemAttribute(name, value, false);
    }
}

