/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.amazonws.simpledb;

import com.xerox.amazonws.common.AWSException;
import com.xerox.amazonws.common.AWSQueryConnection;
import com.xerox.amazonws.common.Result;
import com.xerox.amazonws.simpledb.Condition;
import com.xerox.amazonws.simpledb.DomainMetadata;
import com.xerox.amazonws.simpledb.Item;
import com.xerox.amazonws.simpledb.ItemCache;
import com.xerox.amazonws.simpledb.ItemVO;
import com.xerox.amazonws.simpledb.SDBException;
import com.xerox.amazonws.simpledb.SDBListResult;
import com.xerox.amazonws.simpledb.SDBResult;
import com.xerox.amazonws.typica.sdb.jaxb.Attribute;
import com.xerox.amazonws.typica.sdb.jaxb.BatchPutAttributesResponse;
import com.xerox.amazonws.typica.sdb.jaxb.DeleteAttributesResponse;
import com.xerox.amazonws.typica.sdb.jaxb.DomainMetadataResponse;
import com.xerox.amazonws.typica.sdb.jaxb.DomainMetadataResult;
import com.xerox.amazonws.typica.sdb.jaxb.GetAttributesResponse;
import com.xerox.amazonws.typica.sdb.jaxb.PutAttributesResponse;
import com.xerox.amazonws.typica.sdb.jaxb.SelectResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Domain {
    private static Log logger = LogFactory.getLog(Domain.class);
    private AWSQueryConnection connection;
    private String domainName;
    private ItemCache cache;

    protected Domain(String domainName, AWSQueryConnection connection) throws SDBException {
        this.domainName = domainName;
        this.connection = connection;
    }

    public AWSQueryConnection getConnectionDelegate() {
        return this.connection;
    }

    public String getName() {
        return this.domainName;
    }

    public SDBResult<DomainMetadata> getMetadata() throws SDBException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("DomainName", this.domainName);
        HttpGet method = new HttpGet();
        DomainMetadataResponse response = this.makeRequestInt((HttpRequestBase)method, "DomainMetadata", params, DomainMetadataResponse.class);
        DomainMetadataResult result = response.getDomainMetadataResult();
        return new SDBResult<DomainMetadata>(response.getResponseMetadata().getRequestId(), response.getResponseMetadata().getBoxUsage(), new DomainMetadata(Integer.parseInt(result.getItemCount()), Integer.parseInt(result.getAttributeValueCount()), Integer.parseInt(result.getAttributeNameCount()), Long.parseLong(result.getItemNamesSizeBytes()), Long.parseLong(result.getAttributeValuesSizeBytes()), Long.parseLong(result.getAttributeNamesSizeBytes()), new Date(Long.parseLong(result.getTimestamp()) * 1000L)));
    }

    public SDBResult addItem(Item item) throws SDBException {
        return this.addItem(item.getIdentifier(), item.getAttributes(), null);
    }

    public SDBResult addItem(String identifier, Map<String, Set<String>> attributes, List<Condition> conditions) throws SDBException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("DomainName", this.domainName);
        params.put("ItemName", identifier);
        int i = 1;
        for (String key : attributes.keySet()) {
            Set<String> vals = attributes.get(key);
            if (vals == null || vals.size() <= 0) continue;
            for (String val : vals) {
                params.put("Attribute." + i + ".Name", key);
                params.put("Attribute." + i + ".Value", val);
                ++i;
            }
        }
        if (conditions != null) {
            i = 1;
            for (Condition cond : conditions) {
                params.put("Expected." + i + ".Name", cond.getName());
                String value = cond.getValue();
                if (value != null) {
                    params.put("Expected." + i + ".Value", value);
                } else {
                    params.put("Expected." + i + ".Exists", cond.isExists() ? "true" : "false");
                }
                ++i;
            }
        }
        HttpGet method = new HttpGet();
        PutAttributesResponse response = this.makeRequestInt((HttpRequestBase)method, "PutAttributes", params, PutAttributesResponse.class);
        if (this.cache != null) {
            ItemVO newItem = new ItemVO(identifier);
            Map<String, Set<String>> attrs = newItem.getAttributes();
            attrs.putAll(attributes);
            Item old = this.cache.getItem(identifier);
            if (old != null) {
                for (String key : old.getAttributes().keySet()) {
                    Set<String> oldAttrs = old.getAttributes().get(key);
                    Set<String> newAttrs = attrs.get(key);
                    if (newAttrs != null) {
                        newAttrs.addAll(oldAttrs);
                        continue;
                    }
                    attrs.put(key, oldAttrs);
                }
            }
            this.cache.putItem(newItem);
        }
        return new SDBResult(response.getResponseMetadata().getRequestId(), response.getResponseMetadata().getBoxUsage());
    }

    public SDBResult batchPutAttributes(List<Item> items) throws SDBException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("DomainName", this.domainName);
        int k = 1;
        for (Item item : items) {
            params.put("Item." + k + ".ItemName", item.getIdentifier());
            int i = 1;
            for (String attr : item.getAttributes().keySet()) {
                Set<String> vals = item.getAttributeValues(attr);
                if (vals == null || vals.size() <= 0) continue;
                for (String val : vals) {
                    params.put("Item." + k + ".Attribute." + i + ".Name", attr);
                    params.put("Item." + k + ".Attribute." + i + ".Value", val);
                    ++i;
                }
            }
            ++k;
        }
        HttpGet method = new HttpGet();
        BatchPutAttributesResponse response = this.makeRequestInt((HttpRequestBase)method, "BatchPutAttributes", params, BatchPutAttributesResponse.class);
        return new SDBResult(response.getResponseMetadata().getRequestId(), response.getResponseMetadata().getBoxUsage());
    }

    public SDBResult replaceAttributes(String identifier, Map<String, Set<String>> attributes, List<Condition> conditions) throws SDBException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("DomainName", this.domainName);
        params.put("ItemName", identifier);
        int i = 1;
        for (String key : attributes.keySet()) {
            Set<String> vals = attributes.get(key);
            if (vals == null || vals.size() <= 0) continue;
            for (String val : vals) {
                params.put("Attribute." + i + ".Name", key);
                params.put("Attribute." + i + ".Value", val);
                params.put("Attribute." + i + ".Replace", "true");
                ++i;
            }
        }
        if (conditions != null) {
            i = 1;
            for (Condition cond : conditions) {
                params.put("Expected." + i + ".Name", cond.getName());
                String value = cond.getValue();
                if (value != null) {
                    params.put("Expected." + i + ".Value", value);
                } else {
                    params.put("Expected." + i + ".Exists", cond.isExists() ? "true" : "false");
                }
                ++i;
            }
        }
        HttpGet method = new HttpGet();
        PutAttributesResponse response = this.makeRequestInt((HttpRequestBase)method, "PutAttributes", params, PutAttributesResponse.class);
        if (this.cache != null) {
            ItemVO newItem = new ItemVO(identifier);
            Map<String, Set<String>> attrs = newItem.getAttributes();
            attrs.putAll(attributes);
            Item old = this.cache.getItem(identifier);
            if (old != null) {
                attrs.putAll(old.getAttributes());
            }
            this.cache.putItem(newItem);
        }
        return new SDBResult(response.getResponseMetadata().getRequestId(), response.getResponseMetadata().getBoxUsage());
    }

    public SDBResult deleteAttributes(String identifier, Set<String> attributes, List<Condition> conditions) throws SDBException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("DomainName", this.domainName);
        params.put("ItemName", identifier);
        int i = 1;
        if (attributes != null && attributes.size() > 0) {
            for (String val : attributes) {
                params.put("Attribute." + i + ".Name", val);
                ++i;
            }
        }
        if (conditions != null) {
            i = 1;
            for (Condition cond : conditions) {
                params.put("Expected." + i + ".Name", cond.getName());
                String value = cond.getValue();
                if (value != null) {
                    params.put("Expected." + i + ".Value", value);
                } else {
                    params.put("Expected." + i + ".Exists", cond.isExists() ? "true" : "false");
                }
                ++i;
            }
        }
        HttpGet method = new HttpGet();
        DeleteAttributesResponse response = this.makeRequestInt((HttpRequestBase)method, "DeleteAttributes", params, DeleteAttributesResponse.class);
        if (this.cache != null) {
            // empty if block
        }
        return new SDBResult(response.getResponseMetadata().getRequestId(), response.getResponseMetadata().getBoxUsage());
    }

    public SDBResult deleteItem(String identifier) throws SDBException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("DomainName", this.domainName);
        params.put("ItemName", identifier);
        HttpGet method = new HttpGet();
        DeleteAttributesResponse response = this.makeRequestInt((HttpRequestBase)method, "DeleteAttributes", params, DeleteAttributesResponse.class);
        if (this.cache != null) {
            this.cache.removeItem(identifier);
        }
        return new SDBResult(response.getResponseMetadata().getRequestId(), response.getResponseMetadata().getBoxUsage());
    }

    public Item createItem(String identifier) {
        return new ItemVO(identifier);
    }

    public Result<Item> getItem(String identifier) throws SDBException {
        Item cached;
        if (this.cache != null && (cached = this.cache.getItem(identifier)) != null) {
            return new Result<Item>(null, cached);
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("DomainName", this.domainName);
        params.put("ItemName", identifier);
        HttpGet method = new HttpGet();
        GetAttributesResponse response = this.makeRequestInt((HttpRequestBase)method, "GetAttributes", params, GetAttributesResponse.class);
        ItemVO newItem = new ItemVO(identifier);
        Map<String, Set<String>> attrs = newItem.getAttributes();
        for (Attribute a : response.getGetAttributesResult().getAttributes()) {
            Set<String> vals;
            String name = a.getName().getValue();
            String encoding = a.getName().getEncoding();
            if (encoding != null && encoding.equals("base64")) {
                name = new String(Base64.decodeBase64((byte[])name.getBytes()));
            }
            String value = a.getValue().getValue();
            encoding = a.getValue().getEncoding();
            if (encoding != null && encoding.equals("base64")) {
                value = new String(Base64.decodeBase64((byte[])value.getBytes()));
            }
            if ((vals = attrs.get(name)) == null) {
                vals = Collections.synchronizedSet(new HashSet());
                attrs.put(name, vals);
            }
            vals.add(value);
        }
        if (this.cache != null) {
            this.cache.putItem(newItem);
        }
        return new Result<Item>(null, newItem);
    }

    public SDBListResult<Item> selectItems(String selectExpression, String nextToken, boolean consistent) throws SDBException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("SelectExpression", selectExpression);
        if (nextToken != null) {
            params.put("NextToken", nextToken);
        }
        if (consistent) {
            params.put("ConsistentRead", "true");
        }
        HttpGet method = new HttpGet();
        SelectResponse response = this.makeRequestInt((HttpRequestBase)method, "Select", params, SelectResponse.class);
        SDBListResult<Item> ret = new SDBListResult<Item>(response.getSelectResult().getNextToken(), response.getResponseMetadata().getRequestId(), response.getResponseMetadata().getBoxUsage());
        List<ItemVO> results = ret.getItems();
        for (com.xerox.amazonws.typica.sdb.jaxb.Item i : response.getSelectResult().getItems()) {
            String iName = i.getName().getValue();
            String encoding = i.getName().getEncoding();
            if (encoding != null && encoding.equals("base64")) {
                iName = new String(Base64.decodeBase64((byte[])iName.getBytes()));
            }
            ItemVO newItem = new ItemVO(iName);
            Map<String, Set<String>> attrs = newItem.getAttributes();
            for (Attribute a : i.getAttributes()) {
                Set<String> vals;
                String name = a.getName().getValue();
                encoding = a.getName().getEncoding();
                if (encoding != null && encoding.equals("base64")) {
                    name = new String(Base64.decodeBase64((byte[])name.getBytes()));
                }
                String value = a.getValue().getValue();
                encoding = a.getValue().getEncoding();
                if (encoding != null && encoding.equals("base64")) {
                    value = new String(Base64.decodeBase64((byte[])value.getBytes()));
                }
                if ((vals = attrs.get(name)) == null) {
                    vals = Collections.synchronizedSet(new HashSet());
                    attrs.put(name, vals);
                }
                vals.add(value);
            }
            results.add(newItem);
        }
        return ret;
    }

    public ItemCache getItemCache() {
        return this.cache;
    }

    public void setCacheProvider(ItemCache cache) {
        this.cache = cache;
    }

    static List<Domain> createList(String[] domainNames, AWSQueryConnection connection) throws SDBException {
        ArrayList<Domain> ret = new ArrayList<Domain>();
        for (int i = 0; i < domainNames.length; ++i) {
            Domain dom = new Domain(domainNames[i], connection);
            ret.add(dom);
        }
        return ret;
    }

    protected <T> T makeRequestInt(HttpRequestBase method, String action, Map<String, String> params, Class<T> respType) throws SDBException {
        try {
            return this.connection.makeRequest(method, action, params, respType);
        }
        catch (AWSException ex) {
            throw new SDBException(ex);
        }
        catch (JAXBException ex) {
            throw new SDBException("Problem parsing returned message.", (Exception)((Object)ex));
        }
        catch (SAXException ex) {
            throw new SDBException("Problem parsing returned message.", ex);
        }
        catch (HttpException ex) {
            throw new SDBException(ex.getMessage(), (Exception)((Object)ex));
        }
        catch (IOException ex) {
            throw new SDBException(ex.getMessage(), ex);
        }
    }
}

