/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.amazonws.simpledb;

import com.xerox.amazonws.common.AWSException;
import com.xerox.amazonws.common.AWSQueryConnection;
import com.xerox.amazonws.simpledb.Domain;
import com.xerox.amazonws.simpledb.SDBException;
import com.xerox.amazonws.simpledb.SDBListResult;
import com.xerox.amazonws.simpledb.SDBResult;
import com.xerox.amazonws.typica.sdb.jaxb.CreateDomainResponse;
import com.xerox.amazonws.typica.sdb.jaxb.DeleteDomainResponse;
import com.xerox.amazonws.typica.sdb.jaxb.ListDomainsResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleDB {
    private static Log logger = LogFactory.getLog(SimpleDB.class);
    private AWSQueryConnection connection;

    public SimpleDB(String awsAccessId, String awsSecretKey) {
        this(awsAccessId, awsSecretKey, true);
    }

    public SimpleDB(String awsAccessId, String awsSecretKey, boolean isSecure) {
        this(awsAccessId, awsSecretKey, isSecure, "sdb.amazonaws.com");
    }

    public SimpleDB(String awsAccessId, String awsSecretKey, boolean isSecure, String server) {
        this(awsAccessId, awsSecretKey, isSecure, server, isSecure ? 443 : 80);
    }

    public SimpleDB(String awsAccessId, String awsSecretKey, boolean isSecure, String server, int port) {
        this.connection = new AWSQueryConnection(awsAccessId, awsSecretKey, isSecure, server, port);
        SimpleDB.setVersionHeader(this.connection);
    }

    public AWSQueryConnection getConnectionDelegate() {
        return this.connection;
    }

    public void setEndpoint(String endpointHost) {
        this.connection.setServer(endpointHost);
    }

    public SDBResult<Domain> createDomain(String name) throws SDBException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("DomainName", name);
        HttpGet method = new HttpGet();
        CreateDomainResponse response = this.makeRequestInt((HttpRequestBase)method, "CreateDomain", params, CreateDomainResponse.class);
        Domain ret = new Domain(name, this.connection);
        return new SDBResult<Domain>(response.getResponseMetadata().getRequestId(), response.getResponseMetadata().getBoxUsage(), ret);
    }

    public SDBResult deleteDomain(Domain domain) throws SDBException {
        return this.deleteDomain(domain.getName());
    }

    public SDBResult deleteDomain(String name) throws SDBException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("DomainName", name);
        HttpGet method = new HttpGet();
        DeleteDomainResponse response = this.makeRequestInt((HttpRequestBase)method, "DeleteDomain", params, DeleteDomainResponse.class);
        return new SDBResult(response.getResponseMetadata().getRequestId(), response.getResponseMetadata().getBoxUsage());
    }

    public Domain getDomain(String domainName) throws SDBException {
        return new Domain(domainName, this.connection);
    }

    public SDBListResult<Domain> listDomains() throws SDBException {
        return this.listDomains(null);
    }

    public SDBListResult<Domain> listDomains(String nextToken) throws SDBException {
        return this.listDomains(nextToken, 0);
    }

    public SDBListResult<Domain> listDomains(String nextToken, int maxResults) throws SDBException {
        HashMap<String, String> params = new HashMap<String, String>();
        if (nextToken != null) {
            params.put("NextToken", nextToken);
        }
        if (maxResults > 0) {
            params.put("MaxNumberOfDomains", "" + maxResults);
        }
        HttpGet method = new HttpGet();
        ListDomainsResponse response = this.makeRequestInt((HttpRequestBase)method, "ListDomains", params, ListDomainsResponse.class);
        SDBListResult<Domain> ret = new SDBListResult<Domain>(response.getListDomainsResult().getNextToken(), response.getResponseMetadata().getRequestId(), response.getResponseMetadata().getBoxUsage());
        List<Domain> results = ret.getItems();
        results.addAll(Domain.createList(response.getListDomainsResult().getDomainNames().toArray(new String[0]), this.connection));
        return ret;
    }

    protected <T> T makeRequestInt(HttpRequestBase method, String action, Map<String, String> params, Class<T> respType) throws SDBException {
        try {
            return this.connection.makeRequest(method, action, params, respType);
        }
        catch (AWSException ex) {
            throw new SDBException(ex);
        }
        catch (JAXBException ex) {
            throw new SDBException("Problem parsing returned message.", (Exception)((Object)ex));
        }
        catch (SAXException ex) {
            throw new SDBException("Problem parsing returned message.", ex);
        }
        catch (HttpException ex) {
            throw new SDBException(ex.getMessage(), (Exception)((Object)ex));
        }
        catch (IOException ex) {
            throw new SDBException(ex.getMessage(), ex);
        }
    }

    static void setVersionHeader(AWSQueryConnection connection) {
        ArrayList<String> vals = new ArrayList<String>();
        vals.add("2009-04-15");
        connection.getHeaders().put("Version", vals);
    }
}

