/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.amazonws.sns;

import com.xerox.amazonws.common.AWSException;
import com.xerox.amazonws.common.AWSQueryConnection;
import com.xerox.amazonws.common.ListResult;
import com.xerox.amazonws.common.Result;
import com.xerox.amazonws.sns.SNSException;
import com.xerox.amazonws.sns.SubscriptionInfo;
import com.xerox.amazonws.typica.sns.jaxb.AddPermissionResponse;
import com.xerox.amazonws.typica.sns.jaxb.ConfirmSubscriptionResponse;
import com.xerox.amazonws.typica.sns.jaxb.CreateTopicResponse;
import com.xerox.amazonws.typica.sns.jaxb.DeleteTopicResponse;
import com.xerox.amazonws.typica.sns.jaxb.GetTopicAttributesResponse;
import com.xerox.amazonws.typica.sns.jaxb.ListSubscriptionsByTopicResponse;
import com.xerox.amazonws.typica.sns.jaxb.ListSubscriptionsByTopicResult;
import com.xerox.amazonws.typica.sns.jaxb.ListSubscriptionsResponse;
import com.xerox.amazonws.typica.sns.jaxb.ListSubscriptionsResult;
import com.xerox.amazonws.typica.sns.jaxb.ListTopicsResponse;
import com.xerox.amazonws.typica.sns.jaxb.ListTopicsResult;
import com.xerox.amazonws.typica.sns.jaxb.PublishResponse;
import com.xerox.amazonws.typica.sns.jaxb.RemovePermissionResponse;
import com.xerox.amazonws.typica.sns.jaxb.SetTopicAttributesResponse;
import com.xerox.amazonws.typica.sns.jaxb.SubscribeResponse;
import com.xerox.amazonws.typica.sns.jaxb.Subscription;
import com.xerox.amazonws.typica.sns.jaxb.Topic;
import com.xerox.amazonws.typica.sns.jaxb.TopicAttributesMap;
import com.xerox.amazonws.typica.sns.jaxb.TopicAttributesMapEntry;
import com.xerox.amazonws.typica.sns.jaxb.UnsubscribeResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotificationService {
    private static Log logger = LogFactory.getLog(NotificationService.class);
    private AWSQueryConnection connection;

    public NotificationService(String awsAccessId, String awsSecretKey) {
        this(awsAccessId, awsSecretKey, true);
    }

    public NotificationService(String awsAccessId, String awsSecretKey, boolean isSecure) {
        this(awsAccessId, awsSecretKey, isSecure, "sns.us-east-1.amazonaws.com");
    }

    public NotificationService(String awsAccessId, String awsSecretKey, boolean isSecure, String server) {
        this(awsAccessId, awsSecretKey, isSecure, server, isSecure ? 443 : 80);
    }

    public NotificationService(String awsAccessId, String awsSecretKey, boolean isSecure, String server, int port) {
        this.connection = new AWSQueryConnection(awsAccessId, awsSecretKey, isSecure, server, port);
        NotificationService.setVersionHeader(this.connection);
    }

    public AWSQueryConnection getConnectionDelegate() {
        return this.connection;
    }

    public void addPermission(String topicArn, String label, List<String> accountIds, List<String> actionNames) throws SNSException {
        int i;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("TopicArn", topicArn);
        params.put("Label", label);
        for (i = 0; i < accountIds.size(); ++i) {
            params.put("AWSAccountId.member." + (i + 1), accountIds.get(i));
        }
        for (i = 0; i < actionNames.size(); ++i) {
            params.put("ActionName.member." + (i + 1), actionNames.get(i));
        }
        HttpGet method = new HttpGet();
        AddPermissionResponse response = this.makeRequestInt((HttpRequestBase)method, "AddPermission", params, AddPermissionResponse.class);
    }

    public Result<String> confirmSubscription(String topicArn, String token, boolean authenticateOnUnsubscribe) throws SNSException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("TopicArn", topicArn);
        params.put("Token", token);
        if (authenticateOnUnsubscribe) {
            params.put("AuthenticateOnUnsubscribe", "true");
        }
        HttpGet method = new HttpGet();
        ConfirmSubscriptionResponse response = this.makeRequestInt((HttpRequestBase)method, "ConfirmSubscription", params, ConfirmSubscriptionResponse.class);
        return new Result<String>(response.getResponseMetadata().getRequestId(), response.getConfirmSubscriptionResult().getSubscriptionArn());
    }

    public Result<String> createTopic(String name) throws SNSException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Name", name);
        HttpGet method = new HttpGet();
        CreateTopicResponse response = this.makeRequestInt((HttpRequestBase)method, "CreateTopic", params, CreateTopicResponse.class);
        return new Result<String>(response.getResponseMetadata().getRequestId(), response.getCreateTopicResult().getTopicArn());
    }

    public void deleteTopic(String topicArn) throws SNSException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("TopicArn", topicArn);
        HttpGet method = new HttpGet();
        this.makeRequestInt((HttpRequestBase)method, "DeleteTopic", params, DeleteTopicResponse.class);
    }

    public Map<String, String> getTopicAttributes(String topicArn) throws SNSException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("TopicArn", topicArn);
        HttpGet method = new HttpGet();
        GetTopicAttributesResponse response = this.makeRequestInt((HttpRequestBase)method, "GetTopicAttributes", params, GetTopicAttributesResponse.class);
        HashMap<String, String> ret = new HashMap<String, String>();
        TopicAttributesMap attrs = response.getGetTopicAttributesResult().getAttributes();
        for (TopicAttributesMapEntry e : attrs.getEntries()) {
            ret.put(e.getKey(), e.getValue());
        }
        return ret;
    }

    public ListResult<SubscriptionInfo> listSubscriptions(String nextToken) throws SNSException {
        HashMap<String, String> params = new HashMap<String, String>();
        if (nextToken != null) {
            params.put("NextToken", nextToken);
        }
        HttpGet method = new HttpGet();
        ListSubscriptionsResponse response = this.makeRequestInt((HttpRequestBase)method, "ListSubscriptions", params, ListSubscriptionsResponse.class);
        ListSubscriptionsResult result = response.getListSubscriptionsResult();
        ListResult<SubscriptionInfo> ret = new ListResult<SubscriptionInfo>(result.getNextToken(), response.getResponseMetadata().getRequestId());
        for (Subscription s : result.getSubscriptions().getMembers()) {
            ret.getItems().add(new SubscriptionInfo(s.getTopicArn(), s.getProtocol(), s.getSubscriptionArn(), s.getOwner(), s.getEndpoint()));
        }
        return ret;
    }

    public ListResult<SubscriptionInfo> listSubscriptionsByTopic(String topicArn, String nextToken) throws SNSException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("TopicArn", topicArn);
        if (nextToken != null) {
            params.put("NextToken", nextToken);
        }
        HttpGet method = new HttpGet();
        ListSubscriptionsByTopicResponse response = this.makeRequestInt((HttpRequestBase)method, "ListSubscriptionsByTopic", params, ListSubscriptionsByTopicResponse.class);
        ListSubscriptionsByTopicResult result = response.getListSubscriptionsByTopicResult();
        ListResult<SubscriptionInfo> ret = new ListResult<SubscriptionInfo>(result.getNextToken(), response.getResponseMetadata().getRequestId());
        for (Subscription s : result.getSubscriptions().getMembers()) {
            ret.getItems().add(new SubscriptionInfo(s.getTopicArn(), s.getProtocol(), s.getSubscriptionArn(), s.getOwner(), s.getEndpoint()));
        }
        return ret;
    }

    public ListResult<String> listTopics(String nextToken) throws SNSException {
        HashMap<String, String> params = new HashMap<String, String>();
        if (nextToken != null) {
            params.put("NextToken", nextToken);
        }
        HttpGet method = new HttpGet();
        ListTopicsResponse response = this.makeRequestInt((HttpRequestBase)method, "ListTopics", params, ListTopicsResponse.class);
        ListTopicsResult result = response.getListTopicsResult();
        ListResult<String> ret = new ListResult<String>(result.getNextToken(), response.getResponseMetadata().getRequestId());
        for (Topic t : result.getTopics().getMembers()) {
            ret.getItems().add(t.getTopicArn());
        }
        return ret;
    }

    public Result<String> publish(String topicArn, String message, String subject) throws SNSException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("TopicArn", topicArn);
        params.put("Message", message);
        if (subject != null) {
            params.put("Subject", subject);
        }
        HttpGet method = new HttpGet();
        PublishResponse response = this.makeRequestInt((HttpRequestBase)method, "Publish", params, PublishResponse.class);
        return new Result<String>(response.getResponseMetadata().getRequestId(), response.getPublishResult().getMessageId());
    }

    public void removePermission(String topicArn, String label) throws SNSException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("TopicArn", topicArn);
        params.put("Label", label);
        HttpGet method = new HttpGet();
        this.makeRequestInt((HttpRequestBase)method, "RemovePermission", params, RemovePermissionResponse.class);
    }

    public void setTopicAttributes(String topicArn, String name, String value) throws SNSException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("TopicArn", topicArn);
        params.put("AttributeName", name);
        params.put("AttributeValue", value);
        HttpGet method = new HttpGet();
        this.makeRequestInt((HttpRequestBase)method, "SetTopicAttributes", params, SetTopicAttributesResponse.class);
    }

    public Result<String> subscribe(String topicArn, String protocol, String endpoint) throws SNSException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("TopicArn", topicArn);
        params.put("Protocol", protocol);
        params.put("Endpoint", endpoint);
        HttpGet method = new HttpGet();
        SubscribeResponse response = this.makeRequestInt((HttpRequestBase)method, "Subscribe", params, SubscribeResponse.class);
        return new Result<String>(response.getResponseMetadata().getRequestId(), response.getSubscribeResult().getSubscriptionArn());
    }

    public void unsubscribe(String subscriptionArn) throws SNSException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("SubscriptionArn", subscriptionArn);
        HttpGet method = new HttpGet();
        this.makeRequestInt((HttpRequestBase)method, "Unsubscribe", params, UnsubscribeResponse.class);
    }

    protected <T> T makeRequestInt(HttpRequestBase method, String action, Map<String, String> params, Class<T> respType) throws SNSException {
        try {
            return this.connection.makeRequest(method, action, params, respType);
        }
        catch (AWSException ex) {
            throw new SNSException(ex);
        }
        catch (JAXBException ex) {
            throw new SNSException("Problem parsing returned message.", (Exception)((Object)ex));
        }
        catch (SAXException ex) {
            throw new SNSException("Problem parsing returned message.", ex);
        }
        catch (HttpException ex) {
            throw new SNSException(ex.getMessage(), (Exception)((Object)ex));
        }
        catch (IOException ex) {
            throw new SNSException(ex.getMessage(), ex);
        }
    }

    static void setVersionHeader(AWSQueryConnection connection) {
        ArrayList<String> vals = new ArrayList<String>();
        vals.add("2010-03-31");
        connection.getHeaders().put("Version", vals);
    }
}

