/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.amazonws.common;

import com.xerox.amazonws.common.AWSConnection;
import com.xerox.amazonws.common.AWSError;
import com.xerox.amazonws.common.AWSException;
import com.xerox.amazonws.common.JAXBuddy;
import com.xerox.amazonws.common.TypicaHttpClient;
import com.xerox.amazonws.typica.jaxb.ErrorResponse;
import com.xerox.amazonws.typica.jaxb.Response;
import com.xerox.amazonws.typica.loadbalance.jaxb.Error;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.Collator;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import javax.xml.bind.JAXBException;
import javax.xml.bind.UnmarshalException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AWSQueryConnection
extends AWSConnection {
    private static final Log log = LogFactory.getLog(AWSQueryConnection.class);
    private static String userAgent = "typica/";
    private int maxRetries = 5;
    private HttpClient hc = null;
    private int maxConnections = 100;
    private String proxyHost = null;
    private int proxyPort;
    private String proxyUser;
    private String proxyPassword;
    private String proxyDomain;
    private int connectionManagerTimeout = 0;
    private int soTimeout = 0;
    private int connectionTimeout = 0;
    private TimeZone serverTimeZone = TimeZone.getTimeZone("GMT");

    public AWSQueryConnection(String awsAccessId, String awsSecretKey, boolean isSecure, String server, int port) {
        super(awsAccessId, awsSecretKey, isSecure, server, port);
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(int connections) {
        this.maxConnections = connections;
        this.hc = null;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public void setMaxRetries(int retries) {
        this.maxRetries = retries;
    }

    public void setProxyValues(String host, int port) {
        this.proxyHost = host;
        this.proxyPort = port;
        this.hc = null;
    }

    public void setProxyValues(String host, int port, String user, String password) {
        this.proxyHost = host;
        this.proxyPort = port;
        this.proxyUser = user;
        this.proxyPassword = password;
        this.hc = null;
    }

    public void setProxyValues(String host, int port, String user, String password, String domain) {
        this.proxyHost = host;
        this.proxyPort = port;
        this.proxyUser = user;
        this.proxyPassword = password;
        this.proxyDomain = domain;
        this.hc = null;
    }

    public void useSystemProxy() {
        this.proxyHost = System.getProperty("http.proxyHost");
        if (this.proxyHost != null && this.proxyHost.trim().equals("")) {
            this.proxyHost = null;
        }
        this.proxyPort = this.getPort();
        try {
            this.proxyPort = Integer.parseInt(System.getProperty("http.proxyPort"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.proxyUser = System.getProperty("http.proxyUser");
        this.proxyPassword = System.getProperty("http.proxyPassword");
        this.proxyDomain = System.getProperty("http.proxyDomain");
        this.hc = null;
    }

    public int getConnectionManagerTimeout() {
        return this.connectionManagerTimeout;
    }

    public void setConnectionManagerTimeout(int timeout) {
        this.connectionManagerTimeout = timeout;
        this.hc = null;
    }

    public int getSoTimeout() {
        return this.soTimeout;
    }

    public void setSoTimeout(int timeout) {
        this.soTimeout = timeout;
        this.hc = null;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int timeout) {
        this.connectionTimeout = timeout;
        this.hc = null;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public TimeZone getServerTimeZone() {
        return this.serverTimeZone;
    }

    public void setServerTimeZone(TimeZone serverTimeZone) {
        this.serverTimeZone = serverTimeZone;
    }

    protected HttpClient getHttpClient() {
        if (this.hc == null) {
            this.configureHttpClient();
        }
        return this.hc;
    }

    public void setHttpClient(HttpClient hc) {
        this.hc = hc;
    }

    public <T> T makeRequest(HttpRequestBase method, String action, Map<String, String> params, Class<T> respType) throws HttpException, IOException, JAXBException, AWSException, SAXException {
        HashMap<Object, Object> qParams = params != null ? new HashMap<String, String>(params) : new HashMap();
        qParams.put("Action", action);
        qParams.put("AWSAccessKeyId", this.getAwsAccessKeyId());
        qParams.put("SignatureVersion", "" + this.getSignatureVersion());
        qParams.put("Timestamp", AWSQueryConnection.httpDate(this.serverTimeZone));
        if (this.getSignatureVersion() == 2) {
            qParams.put("SignatureMethod", this.getAlgorithm());
        }
        if (this.headers != null) {
            for (String key : this.headers.keySet()) {
                Iterator j = ((List)this.headers.get(key)).iterator();
                while (j.hasNext()) {
                    qParams.put(key, j.next());
                }
            }
        }
        ArrayList keys = new ArrayList(qParams.keySet());
        if (this.getSignatureVersion() == 2) {
            Collections.sort(keys);
        } else {
            Collator stringCollator = Collator.getInstance();
            stringCollator.setStrength(0);
            Collections.sort(keys, stringCollator);
        }
        StringBuilder resource = new StringBuilder();
        if (this.getSignatureVersion() == 0) {
            resource.append((String)qParams.get("Action"));
            resource.append((String)qParams.get("Timestamp"));
        } else if (this.getSignatureVersion() == 2) {
            resource.append(method.getMethod());
            resource.append("\n");
            resource.append(this.getServer().toLowerCase());
            resource.append("\n/");
            String reqURL = this.makeURL("").toString();
            if (reqURL.lastIndexOf(47) < reqURL.length() - 1) {
                int idx = reqURL.lastIndexOf(58);
                resource.append(reqURL.substring(reqURL.indexOf(47, idx) + 1));
            }
            resource.append("\n");
            boolean first = true;
            for (String key : keys) {
                if (!first) {
                    resource.append("&");
                } else {
                    first = false;
                }
                resource.append(key);
                resource.append("=");
                resource.append(this.urlencode((String)qParams.get(key)));
            }
        } else {
            for (String key : keys) {
                resource.append(key);
                resource.append((String)qParams.get(key));
            }
        }
        String unencoded = this.encode(this.getSecretAccessKey(), resource.toString(), false);
        String encoded = this.urlencode(unencoded);
        resource = new StringBuilder();
        if (method.getMethod().equals("POST")) {
            ArrayList<BasicNameValuePair> postParams = new ArrayList<BasicNameValuePair>();
            for (String key : keys) {
                postParams.add(new BasicNameValuePair(key, (String)qParams.get(key)));
            }
            postParams.add(new BasicNameValuePair("Signature", unencoded));
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(postParams, "UTF-8");
            method.setHeader((Header)new BasicHeader("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8"));
            ((HttpPost)method).setEntity((HttpEntity)entity);
        } else {
            for (String key : keys) {
                resource.append("&");
                resource.append(key);
                resource.append("=");
                resource.append(this.urlencode((String)qParams.get(key)));
            }
            resource.setCharAt(0, '?');
            resource.append("&Signature=");
            resource.append(encoded);
        }
        URL url = this.makeURL(resource.toString());
        try {
            method.setURI(new URI(url.toString()));
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
        method.setHeader((Header)new BasicHeader("User-Agent", userAgent));
        if (this.getSignatureVersion() == 0) {
            method.setHeader((Header)new BasicHeader("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8"));
        }
        T response = null;
        boolean done = false;
        int retries = 0;
        boolean doRetry = false;
        AWSException error = null;
        HttpResponse httpResponse = null;
        do {
            int responseCode = 600;
            try {
                httpResponse = this.getHttpClient().execute((HttpUriRequest)method);
                responseCode = httpResponse.getStatusLine().getStatusCode();
            }
            catch (SocketException ex) {
                doRetry = true;
                error = new AWSException(ex.getMessage(), ex);
            }
            if (responseCode < 300) {
                if (respType != null) {
                    InputStream iStr = httpResponse.getEntity().getContent();
                    response = JAXBuddy.deserializeXMLStream(respType, iStr);
                }
                done = true;
            } else {
                String body;
                if (responseCode < 400) {
                    throw new HttpException("redirect error : " + responseCode);
                }
                if (responseCode < 500) {
                    body = this.getString(httpResponse.getEntity());
                    throw this.createException(body, "Client error : ");
                }
                if (responseCode < 600) {
                    doRetry = true;
                    body = this.getString(httpResponse.getEntity());
                    error = this.createException(body, "");
                }
            }
            if (!doRetry) continue;
            if (++retries > this.maxRetries) {
                throw new HttpException("Number of retries exceeded : " + action, (Throwable)error);
            }
            doRetry = false;
            try {
                Thread.sleep((long)(Math.random() * (Math.pow(4.0, retries - 1) * 100.0)));
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
        } while (!done);
        return response;
    }

    private void configureHttpClient() {
        BasicHttpParams params = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)this.connectionTimeout);
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)this.soTimeout);
        params.setParameter("http.conn-manager.max-total", (Object)new Integer(this.maxConnections));
        params.setParameter("http.virtual-host", (Object)this.getServer());
        SchemeRegistry registry = new SchemeRegistry();
        registry.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80));
        registry.register(new Scheme("https", (SocketFactory)SSLSocketFactory.getSocketFactory(), 443));
        ThreadSafeClientConnManager connMgr = new ThreadSafeClientConnManager((HttpParams)params, registry);
        this.hc = new TypicaHttpClient((ClientConnectionManager)connMgr, (HttpParams)params);
        if (this.proxyHost != null) {
            DefaultHttpClient defaultHC = (DefaultHttpClient)this.hc;
            log.info((Object)("Proxy Host set to " + this.proxyHost + ":" + this.proxyPort));
            HttpHost proxy = new HttpHost(this.proxyHost, this.proxyPort);
            defaultHC.getParams().setParameter("http.route.default-proxy", (Object)proxy);
            if (this.proxyUser != null && !this.proxyUser.trim().equals("")) {
                AuthScope scope = new AuthScope(this.proxyHost, this.proxyPort);
                Object creds = null;
                creds = this.proxyDomain != null ? new NTCredentials(this.proxyUser, this.proxyPassword, this.proxyHost, this.proxyDomain) : new UsernamePasswordCredentials(this.proxyUser, this.proxyPassword);
                defaultHC.getCredentialsProvider().setCredentials(scope, (Credentials)creds);
            }
        }
    }

    protected String getString(HttpEntity entity) {
        if (entity == null) {
            return null;
        }
        try {
            return EntityUtils.toString((HttpEntity)entity);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void close(HttpEntity entity) {
        if (entity != null) {
            try {
                entity.consumeContent();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void close(InputStream istream) {
        if (istream != null) {
            try {
                istream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private AWSException createException(String errorResponse, String msgPrefix) throws IOException, JAXBException, SAXException {
        String requestId;
        String errorMsg;
        ArrayList<AWSError> errors = null;
        ByteArrayInputStream bais = new ByteArrayInputStream(errorResponse.getBytes());
        if (errorResponse.indexOf("<ErrorResponse") > -1) {
            try {
                com.xerox.amazonws.typica.sqs2.jaxb.ErrorResponse resp = JAXBuddy.deserializeXMLStream(com.xerox.amazonws.typica.sqs2.jaxb.ErrorResponse.class, bais);
                List<com.xerox.amazonws.typica.sqs2.jaxb.Error> errs = resp.getErrors();
                errorMsg = "(" + errs.get(0).getCode() + ") " + errs.get(0).getMessage();
                requestId = resp.getRequestId();
                errors = new ArrayList();
                for (com.xerox.amazonws.typica.sqs2.jaxb.Error e : errs) {
                    errors.add(new AWSError(AWSError.ErrorType.getTypeFromString(e.getType()), e.getCode(), e.getMessage()));
                }
            }
            catch (UnmarshalException ex) {
                try {
                    bais = new ByteArrayInputStream(errorResponse.getBytes());
                    ErrorResponse resp = JAXBuddy.deserializeXMLStream(ErrorResponse.class, bais);
                    List<com.xerox.amazonws.typica.jaxb.Error> errs = resp.getErrors();
                    errorMsg = "(" + errs.get(0).getCode() + ") " + errs.get(0).getMessage();
                    requestId = resp.getRequestID();
                    errors = new ArrayList();
                    for (com.xerox.amazonws.typica.jaxb.Error e : errs) {
                        errors.add(new AWSError(AWSError.ErrorType.getTypeFromString(e.getType()), e.getCode(), e.getMessage()));
                    }
                }
                catch (UnmarshalException ex2) {
                    try {
                        bais = new ByteArrayInputStream(errorResponse.getBytes());
                        com.xerox.amazonws.typica.monitor.jaxb.ErrorResponse resp = JAXBuddy.deserializeXMLStream(com.xerox.amazonws.typica.monitor.jaxb.ErrorResponse.class, bais);
                        List<com.xerox.amazonws.typica.monitor.jaxb.Error> errs = resp.getErrors();
                        errorMsg = "(" + errs.get(0).getCode() + ") " + errs.get(0).getMessage();
                        requestId = resp.getRequestId();
                        errors = new ArrayList();
                        for (com.xerox.amazonws.typica.monitor.jaxb.Error e : errs) {
                            errors.add(new AWSError(AWSError.ErrorType.getTypeFromString(e.getType()), e.getCode(), e.getMessage()));
                        }
                    }
                    catch (UnmarshalException ex3) {
                        try {
                            bais = new ByteArrayInputStream(errorResponse.getBytes());
                            com.xerox.amazonws.typica.loadbalance.jaxb.ErrorResponse resp = JAXBuddy.deserializeXMLStream(com.xerox.amazonws.typica.loadbalance.jaxb.ErrorResponse.class, bais);
                            List<Error> errs = resp.getErrors();
                            errorMsg = "(" + errs.get(0).getCode() + ") " + errs.get(0).getMessage();
                            requestId = resp.getRequestId();
                            errors = new ArrayList();
                            for (Error e : errs) {
                                errors.add(new AWSError(AWSError.ErrorType.getTypeFromString(e.getType()), e.getCode(), e.getMessage()));
                            }
                        }
                        catch (UnmarshalException ex4) {
                            try {
                                bais = new ByteArrayInputStream(errorResponse.getBytes());
                                com.xerox.amazonws.typica.autoscale.jaxb.ErrorResponse resp = JAXBuddy.deserializeXMLStream(com.xerox.amazonws.typica.autoscale.jaxb.ErrorResponse.class, bais);
                                List<com.xerox.amazonws.typica.autoscale.jaxb.Error> errs = resp.getErrors();
                                errorMsg = "(" + errs.get(0).getCode() + ") " + errs.get(0).getMessage();
                                requestId = resp.getRequestId();
                                errors = new ArrayList();
                                for (com.xerox.amazonws.typica.autoscale.jaxb.Error e : errs) {
                                    errors.add(new AWSError(AWSError.ErrorType.getTypeFromString(e.getType()), e.getCode(), e.getMessage()));
                                }
                            }
                            catch (UnmarshalException ex5) {
                                try {
                                    bais = new ByteArrayInputStream(errorResponse.getBytes());
                                    com.xerox.amazonws.typica.sns.jaxb.ErrorResponse resp = JAXBuddy.deserializeXMLStream(com.xerox.amazonws.typica.sns.jaxb.ErrorResponse.class, bais);
                                    List<com.xerox.amazonws.typica.sns.jaxb.Error> errs = resp.getErrors();
                                    errorMsg = "(" + errs.get(0).getCode() + ") " + errs.get(0).getMessage();
                                    requestId = resp.getRequestId();
                                    errors = new ArrayList();
                                    for (com.xerox.amazonws.typica.sns.jaxb.Error e : errs) {
                                        errors.add(new AWSError(AWSError.ErrorType.getTypeFromString(e.getType()), e.getCode(), e.getMessage()));
                                    }
                                }
                                catch (UnmarshalException ex6) {
                                    errorMsg = "Couldn't parse error response!";
                                    requestId = "???";
                                    log.error((Object)errorMsg, (Throwable)ex6);
                                    log.info((Object)("response = " + errorResponse));
                                }
                            }
                        }
                    }
                }
            }
        } else if (errorResponse.indexOf("<soapenv:Reason") > -1) {
            int idx = errorResponse.indexOf("Text xml:lang=\"en-US\">");
            errorMsg = errorResponse.substring(idx + 22);
            int idx2 = errorMsg.indexOf("<");
            errorMsg = errorMsg.substring(0, idx2);
            requestId = "NA";
            errors = new ArrayList<AWSError>();
            errors.add(new AWSError(AWSError.ErrorType.SENDER, "unknown", errorMsg));
        } else {
            try {
                Response resp = JAXBuddy.deserializeXMLStream(Response.class, bais);
                String errorCode = resp.getErrors().getError().getCode();
                errorMsg = resp.getErrors().getError().getMessage();
                requestId = resp.getRequestID();
                if (errorCode != null && !errorCode.trim().equals("")) {
                    errors = new ArrayList();
                    errors.add(new AWSError(AWSError.ErrorType.SENDER, errorCode, errorMsg));
                }
            }
            catch (SAXException ex) {
                errorMsg = "Couldn't parse error response!";
                requestId = "???";
                log.error((Object)errorMsg, (Throwable)ex);
                log.info((Object)("response = " + errorResponse));
            }
            catch (UnmarshalException ex2) {
                errorMsg = "Couldn't parse error response!";
                requestId = "???";
                log.error((Object)errorMsg, (Throwable)ex2);
                log.info((Object)("response = " + errorResponse));
            }
        }
        return new AWSException(msgPrefix + errorMsg, requestId, errors);
    }

    private static String httpDate(TimeZone serverTimeZone) {
        String DateFormat2 = "yyyy-MM-dd'T'HH:mm:00'Z'";
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:00'Z'", Locale.US);
        format.setTimeZone(serverTimeZone);
        return format.format(new Date());
    }

    protected String httpDate(Calendar date) {
        String DateFormat2 = "yyyy-MM-dd'T'HH:mm:ss'Z'";
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US);
        format.setTimeZone(this.serverTimeZone);
        return format.format(date.getTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        String version = "?";
        try {
            Properties props = new Properties();
            InputStream verStream = ClassLoader.getSystemResourceAsStream("version.properties");
            try {
                props.load(verStream);
            }
            finally {
                verStream.close();
            }
            version = props.getProperty("version");
        }
        catch (Exception exception) {
            // empty catch block
        }
        userAgent = userAgent + version + " (" + System.getProperty("os.arch") + "; " + System.getProperty("os.name") + ")";
    }
}

